/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.util;

import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class RenderUtil {
    public static ResourceLocation beam_texture = new ResourceLocation("mysticallib:textures/effect/beam.png");
    public static ResourceLocation glow_texture = new ResourceLocation("mysticallib:textures/effect/glow.png");
    public static int maxLightX = 0xF000F0;
    public static int maxLightY = 0xF000F0;

    public static void renderBeam(@Nonnull BufferBuilder buf, double x1, double y1, double z1, double x2, double y2, double z2, float r1, float g1, float b1, float a1, float r2, float g2, float b2, float a2, double width, double angle) {
        float rads = (float)Math.toRadians(angle);
        double ac = MathHelper.func_76134_b((float)rads);
        double as = MathHelper.func_76126_a((float)rads);
        float yaw = (float)Math.atan2(x2 - x1, z2 - z1);
        float pitch = (float)Math.atan2(y2 - y1, MathHelper.func_76133_a((double)(Math.pow(x2 - x1, 2.0) + Math.pow(z2 - z1, 2.0))));
        double tX1 = width * (double)MathHelper.func_76134_b((float)yaw);
        double tY1 = 0.0;
        double tZ1 = -width * (double)MathHelper.func_76126_a((float)yaw);
        double tX2 = width * (double)MathHelper.func_76126_a((float)yaw) * -((double)MathHelper.func_76126_a((float)pitch));
        double tY2 = width * (double)MathHelper.func_76134_b((float)pitch);
        double tZ2 = width * (double)MathHelper.func_76134_b((float)yaw) * -((double)MathHelper.func_76126_a((float)pitch));
        double tXc = tX1 * ac + tX2 * as;
        double tYc = tY1 * ac + tY2 * as;
        double tZc = tZ1 * ac + tZ2 * as;
        double tXs = tX1 * -as + tX2 * ac;
        double tYs = tY1 * -as + tY2 * ac;
        double tZs = tZ1 * -as + tZ2 * ac;
        buf.func_181662_b(x1 - tXs, y1 - tYs, z1 - tZs).func_187315_a(0.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buf.func_181662_b(x2 - tXs, y2 - tYs, z2 - tZs).func_187315_a(1.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buf.func_181662_b(x2 + tXs, y2 + tYs, z2 + tZs).func_187315_a(1.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buf.func_181662_b(x1 + tXs, y1 + tYs, z1 + tZs).func_187315_a(0.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buf.func_181662_b(x1 - tXc, y1 - tYc, z1 - tZc).func_187315_a(0.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buf.func_181662_b(x2 - tXc, y2 - tYc, z2 - tZc).func_187315_a(1.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buf.func_181662_b(x2 + tXc, y2 + tYc, z2 + tZc).func_187315_a(1.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buf.func_181662_b(x1 + tXc, y1 + tYc, z1 + tZc).func_187315_a(0.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r1, g1, b1, a1).func_181675_d();
    }

    public static void renderSlash(@Nonnull BufferBuilder buf, double x0, double y0, double z0, float r, float g, float b, float a, float radius, float width, float angleRange) {
        for (float i = -angleRange / 2.0f; i < angleRange / 2.0f; i += angleRange / 16.0f) {
            float coeff1 = 1.0f - Math.abs(i) / (angleRange / 2.0f);
            float coeff2 = 1.0f - Math.abs(i + angleRange / 16.0f) / (angleRange / 2.0f);
            double x1 = x0 + (double)radius * Math.sin(Math.toRadians(i));
            double z1 = z0 + (double)radius * Math.cos(Math.toRadians(i));
            double x2 = x0 + (double)(radius + 0.5f * coeff1 * width) * Math.sin(Math.toRadians(i));
            double z2 = z0 + (double)(radius + 0.5f * coeff1 * width) * Math.cos(Math.toRadians(i));
            double x3 = x0 + (double)(radius + 0.5f * coeff2 * width) * Math.sin(Math.toRadians(i + angleRange / 16.0f));
            double z3 = z0 + (double)(radius + 0.5f * coeff2 * width) * Math.cos(Math.toRadians(i + angleRange / 16.0f));
            double x4 = x0 + (double)radius * Math.sin(Math.toRadians(i + angleRange / 16.0f));
            double z4 = z0 + (double)radius * Math.cos(Math.toRadians(i + angleRange / 16.0f));
            buf.func_181662_b(x1, y0, z1 - (double)(radius / 2.0f)).func_187315_a(1.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff1).func_181675_d();
            buf.func_181662_b(x2, y0, z2 - (double)(radius / 2.0f)).func_187315_a(1.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff1).func_181675_d();
            buf.func_181662_b(x3, y0, z3 - (double)(radius / 2.0f)).func_187315_a(0.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff2).func_181675_d();
            buf.func_181662_b(x4, y0, z4 - (double)(radius / 2.0f)).func_187315_a(0.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff2).func_181675_d();
            x1 = x0 + (double)radius * Math.sin(Math.toRadians(i));
            z1 = z0 + (double)radius * Math.cos(Math.toRadians(i));
            x2 = x0 + (double)(radius - 0.5f * coeff1 * width) * Math.sin(Math.toRadians(i));
            z2 = z0 + (double)(radius - 0.5f * coeff1 * width) * Math.cos(Math.toRadians(i));
            x3 = x0 + (double)(radius - 0.5f * coeff2 * width) * Math.sin(Math.toRadians(i + angleRange / 16.0f));
            z3 = z0 + (double)(radius - 0.5f * coeff2 * width) * Math.cos(Math.toRadians(i + angleRange / 16.0f));
            x4 = x0 + (double)radius * Math.sin(Math.toRadians(i + angleRange / 16.0f));
            z4 = z0 + (double)radius * Math.cos(Math.toRadians(i + angleRange / 16.0f));
            buf.func_181662_b(x1, y0, z1 - (double)(radius / 2.0f)).func_187315_a(1.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff1).func_181675_d();
            buf.func_181662_b(x2, y0, z2 - (double)(radius / 2.0f)).func_187315_a(1.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff1).func_181675_d();
            buf.func_181662_b(x3, y0, z3 - (double)(radius / 2.0f)).func_187315_a(0.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff2).func_181675_d();
            buf.func_181662_b(x4, y0, z4 - (double)(radius / 2.0f)).func_187315_a(0.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff2).func_181675_d();
            buf.func_181662_b(x1, y0, z1 - (double)(radius / 2.0f)).func_187315_a(1.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff1).func_181675_d();
            buf.func_181662_b(x2, y0, z2 - (double)(radius / 2.0f)).func_187315_a(1.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff1).func_181675_d();
            buf.func_181662_b(x3, y0, z3 - (double)(radius / 2.0f)).func_187315_a(0.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff2).func_181675_d();
            buf.func_181662_b(x4, y0, z4 - (double)(radius / 2.0f)).func_187315_a(0.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff2).func_181675_d();
            x1 = x0 + (double)radius * Math.sin(Math.toRadians(i));
            z1 = z0 + (double)radius * Math.cos(Math.toRadians(i));
            x2 = x0 + (double)radius * Math.sin(Math.toRadians(i));
            z2 = z0 + (double)radius * Math.cos(Math.toRadians(i));
            x3 = x0 + (double)radius * Math.sin(Math.toRadians(i + angleRange / 16.0f));
            z3 = z0 + (double)radius * Math.cos(Math.toRadians(i + angleRange / 16.0f));
            x4 = x0 + (double)radius * Math.sin(Math.toRadians(i + angleRange / 16.0f));
            z4 = z0 + (double)radius * Math.cos(Math.toRadians(i + angleRange / 16.0f));
            buf.func_181662_b(x1, y0, z1 - (double)(radius / 2.0f)).func_187315_a(1.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff1).func_181675_d();
            buf.func_181662_b(x2, y0 - (double)(width * 0.5f * coeff1), z2 - (double)(radius / 2.0f)).func_187315_a(1.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff1).func_181675_d();
            buf.func_181662_b(x3, y0 - (double)(width * 0.5f * coeff2), z3 - (double)(radius / 2.0f)).func_187315_a(0.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff2).func_181675_d();
            buf.func_181662_b(x4, y0, z4 - (double)(radius / 2.0f)).func_187315_a(0.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff2).func_181675_d();
            buf.func_181662_b(x1, y0, z1 - (double)(radius / 2.0f)).func_187315_a(1.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff1).func_181675_d();
            buf.func_181662_b(x2, y0 + (double)(width * 0.5f * coeff1), z2 - (double)(radius / 2.0f)).func_187315_a(1.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff1).func_181675_d();
            buf.func_181662_b(x3, y0 + (double)(width * 0.5f * coeff2), z3 - (double)(radius / 2.0f)).func_187315_a(0.0, 0.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff2).func_181675_d();
            buf.func_181662_b(x4, y0, z4 - (double)(radius / 2.0f)).func_187315_a(0.0, 1.0).func_187314_a(maxLightX, maxLightY).func_181666_a(r, g, b, a * coeff2).func_181675_d();
        }
    }
}

