/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.moartinkers;

import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MoarMaterialIntegration
extends MaterialIntegration {
    protected boolean integrated = false;
    private boolean preInit = false;
    protected boolean force;

    public MoarMaterialIntegration(Material material, Fluid fluid, String oreSuffix) {
        this("ingot" + oreSuffix, material, fluid, oreSuffix);
    }

    public MoarMaterialIntegration(String oreRequirement, Material material, Fluid fluid, String oreSuffix) {
        this(material, fluid, oreSuffix, oreRequirement);
    }

    private MoarMaterialIntegration(Material material, Fluid fluid, String oreSuffix, String ... oreRequirement) {
        super(material, fluid, StringUtils.capitalize((String)oreSuffix), oreRequirement);
    }

    public void preInit() {
        this.preInit(false);
    }

    public void preInit(boolean force) {
        if (this.preInit) {
            return;
        }
        this.force = force;
        this.preInit = true;
        if (!TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery")) {
            this.fluid = null;
        }
        if (this.fluid != null) {
            Fluid registeredFluid = FluidRegistry.getFluid((String)this.fluid.getName());
            if (!FluidRegistry.getBucketFluids().contains(registeredFluid)) {
                FluidRegistry.addBucketForFluid((Fluid)registeredFluid);
            }
        }
        if (this.material != null) {
            TinkerRegistry.addMaterial((Material)this.material);
            if (this.fluid != null) {
                this.material.setFluid(this.fluid);
                this.material.setCastable(true);
            } else {
                this.material.setCraftable(true);
            }
        }
    }

    public boolean isIntegrated() {
        return this.integrated;
    }

    public void integrateRecipes() {
        if (this.integrated) {
            return;
        }
        if (!this.force && this.oreRequirement != null && this.oreRequirement.length > 0 && !Config.forceRegisterAll) {
            for (String ore : this.oreRequirement) {
                if (!OreDictionary.getOres((String)ore, (boolean)false).isEmpty()) continue;
                return;
            }
        }
        this.integrated = true;
        if (this.fluid != null && this.oreSuffix != null) {
            TinkerSmeltery.registerOredictMeltingCasting((Fluid)this.fluid, (String)this.oreSuffix);
        }
        if (this.material != null) {
            TinkerSmeltery.registerToolpartMeltingCasting((Material)this.material);
        }
    }

    public MaterialIntegration toolforge() {
        super.toolforge();
        return this;
    }
}

