/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.registry;

import com.google.common.collect.ObjectArrays;
import java.lang.reflect.Constructor;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sblectric.lightningcraft.LightningCraft;
import sblectric.lightningcraft.api.registry.ILightningCraftBlock;
import sblectric.lightningcraft.api.registry.ILightningCraftItem;
import sblectric.lightningcraft.api.util.JointList;
import sblectric.lightningcraft.crafting.LCCraftingManager;
import sblectric.lightningcraft.init.LCBiomes;
import sblectric.lightningcraft.init.LCBlocks;
import sblectric.lightningcraft.init.LCEnchantments;
import sblectric.lightningcraft.init.LCItems;
import sblectric.lightningcraft.init.LCPotions;
import sblectric.lightningcraft.init.LCSoundEvents;
import sblectric.lightningcraft.ref.Log;

public class RegistryHelper {
    public static final List<IRecipe> RECIPES_TO_REGISTER = new JointList<IRecipe>();
    public static final List<Block> BLOCKS_TO_REGISTER = new JointList<Block>();
    public static final List<Block> FLUIDS_TO_REGISTER = new JointList<Block>();
    public static final List<Item> ITEMS_TO_REGISTER = new JointList<Item>();
    public static final List<Biome> BIOMES_TO_REGISTER = new JointList<Biome>();
    public static final List<Enchantment> ENCHANTMENTS_TO_REGISTER = new JointList<Enchantment>();
    public static final List<Potion> POTIONS_TO_REGISTER = new JointList<Potion>();
    public static final List<PotionType> POTION_TYPES_TO_REGISTER = new JointList<PotionType>();
    public static final List<SoundEvent> SOUNDS_TO_REGISTER = new JointList<SoundEvent>();

    public static void registerBlocks(Iterable<ILightningCraftBlock> regBlocks) {
        for (ILightningCraftBlock r : regBlocks) {
            RegistryHelper.registerBlock(r);
        }
    }

    public static void registerItems(Iterable<ILightningCraftItem> regItems) {
        for (ILightningCraftItem r : regItems) {
            r.setRarity();
            RegistryHelper.registerItem(r);
        }
    }

    public static void registerBlock(ILightningCraftBlock regBlock) {
        Block block = (Block)regBlock;
        BLOCKS_TO_REGISTER.add(block.func_149663_c(block.getRegistryName().toString()));
        if (regBlock.getItemClass() != null) {
            ItemBlock item;
            try {
                Class[] ctorArgClasses = new Class[regBlock.getItemClassArgs().length + 1];
                ctorArgClasses[0] = Block.class;
                for (int idx = 1; idx < ctorArgClasses.length; ++idx) {
                    ctorArgClasses[idx] = regBlock.getItemClassArgs()[idx - 1].getClass();
                }
                Constructor<? extends ItemBlock> itemCtor = regBlock.getItemClass().getConstructor(ctorArgClasses);
                item = itemCtor.newInstance(ObjectArrays.concat((Object)regBlock, (Object[])regBlock.getItemClassArgs()));
            }
            catch (Exception e) {
                Log.logger.error("Unable to register block " + block.getRegistryName());
                return;
            }
            ITEMS_TO_REGISTER.add((Item)item.setRegistryName(block.getRegistryName()));
        }
    }

    public static void registerItem(ILightningCraftItem regItem) {
        Item item = (Item)regItem;
        ITEMS_TO_REGISTER.add(item.func_77655_b(item.getRegistryName().toString()));
    }

    @SubscribeEvent
    public void onBlockRegistry(RegistryEvent.Register<Block> e) {
        LCBlocks.registerBlocks();
        for (Block b : new JointList<Block>().join((Iterable<Block>)BLOCKS_TO_REGISTER).join((Iterable<Block>)FLUIDS_TO_REGISTER)) {
            e.getRegistry().register((IForgeRegistryEntry)b);
        }
        BLOCKS_TO_REGISTER.clear();
        FLUIDS_TO_REGISTER.clear();
        Log.logger.info("Blocks registered.");
    }

    @SubscribeEvent
    public void onItemRegistry(RegistryEvent.Register<Item> e) {
        LCItems.registerItems();
        for (Item i : ITEMS_TO_REGISTER) {
            e.getRegistry().register((IForgeRegistryEntry)i);
        }
        ITEMS_TO_REGISTER.clear();
        LCCraftingManager.setOreDictionary();
        LightningCraft.proxy.registerItemModels();
        Log.logger.info("Items registered.");
    }

    @SubscribeEvent
    public void onRecipeRegistry(RegistryEvent.Register<IRecipe> e) {
        LCCraftingManager.addCraftingRecipes();
        for (IRecipe r : RECIPES_TO_REGISTER) {
            e.getRegistry().register((IForgeRegistryEntry)r);
        }
        RECIPES_TO_REGISTER.clear();
        Log.logger.info("Recipes registered.");
    }

    @SubscribeEvent
    public void onBiomeRegistry(RegistryEvent.Register<Biome> e) {
        LCBiomes.mainRegistry();
        for (Biome b : BIOMES_TO_REGISTER) {
            e.getRegistry().register((IForgeRegistryEntry)b);
        }
        BIOMES_TO_REGISTER.clear();
        LCBiomes.setBiomeTypes();
        Log.logger.info("Biomes registered.");
    }

    @SubscribeEvent
    public void onEnchantmentRegistry(RegistryEvent.Register<Enchantment> e) {
        LCEnchantments.mainRegistry();
        for (Enchantment ench : ENCHANTMENTS_TO_REGISTER) {
            e.getRegistry().register((IForgeRegistryEntry)ench);
        }
        ENCHANTMENTS_TO_REGISTER.clear();
        Log.logger.info("Enchantments registered.");
    }

    @SubscribeEvent
    public void onPotionRegistry(RegistryEvent.Register<Potion> e) {
        LCPotions.mainRegistry();
        for (Potion p : POTIONS_TO_REGISTER) {
            e.getRegistry().register((IForgeRegistryEntry)p);
        }
        POTIONS_TO_REGISTER.clear();
        Log.logger.info("Potions registered.");
    }

    @SubscribeEvent
    public void onPotionTypeRegistry(RegistryEvent.Register<PotionType> e) {
        for (PotionType p : POTION_TYPES_TO_REGISTER) {
            e.getRegistry().register((IForgeRegistryEntry)p);
        }
        POTION_TYPES_TO_REGISTER.clear();
        Log.logger.info("Potion types registered.");
    }

    @SubscribeEvent
    public void onSoundEventRegistry(RegistryEvent.Register<SoundEvent> e) {
        LCSoundEvents.mainRegistry();
        for (SoundEvent s : SOUNDS_TO_REGISTER) {
            e.getRegistry().register((IForgeRegistryEntry)s);
        }
        SOUNDS_TO_REGISTER.clear();
        Log.logger.info("Sounds registered.");
    }
}

