/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.init;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sblectric.lightningcraft.api.util.JointList;
import sblectric.lightningcraft.fluids.BlockFluidLC;
import sblectric.lightningcraft.fluids.ModFluid;
import sblectric.lightningcraft.registry.RegistryHelper;

public class LCFluids {
    private static final List<Block> FLUIDS = RegistryHelper.FLUIDS_TO_REGISTER;
    private static Map<Fluid, BlockFluidBase> fluidBlockMap;
    private static Map<BlockFluidBase, String> fluidBlockNameMap;
    private static JointList<Fluid> fluids;
    private static JointList<BlockFluidBase> fluidBlocks;
    public static Fluid moltenElectricium;
    public static BlockFluidBase moltenBlockElectricium;
    public static Fluid moltenSkyfather;
    public static BlockFluidBase moltenBlockSkyfather;
    public static Fluid moltenMystic;
    public static BlockFluidBase moltenBlockMystic;

    public static void createFluids() {
        fluids = new JointList();
        fluidBlocks = new JointList();
        fluidBlockMap = new HashMap<Fluid, BlockFluidBase>();
        fluidBlockNameMap = new HashMap<BlockFluidBase, String>();
        LCFluids.addFluids();
    }

    private static void addFluids() {
        moltenElectricium = LCFluids.createFluid("electricium", 2000, 10000, 800, 12, new Color(32, 250, 250).getRGB());
        fluids.join((Fluid[])new Fluid[]{moltenElectricium, moltenSkyfather = LCFluids.createFluid("skyfather", 2000, 10000, 900, 12, new Color(52, 52, 52).getRGB()), moltenMystic = LCFluids.createFluid("mystic", 2000, 10000, 1000, 12, new Color(180, 0, 0).getRGB())});
        moltenBlockElectricium = LCFluids.addFluidBlock(moltenElectricium, "molten_electricium");
        fluidBlocks.join((BlockFluidBase[])new BlockFluidBase[]{moltenBlockElectricium, moltenBlockSkyfather = LCFluids.addFluidBlock(moltenSkyfather, "molten_skyfather"), moltenBlockMystic = LCFluids.addFluidBlock(moltenMystic, "molten_mystic")});
    }

    private static Fluid createFluid(String name, int density, int viscosity, int temperature, int luminosity, int tintColor) {
        ModFluid fluid = new ModFluid(name, new ResourceLocation("lightningcraft", "blocks/molten_metal_still"), new ResourceLocation("lightningcraft", "blocks/molten_metal_flow"), tintColor);
        fluid.setDensity(density);
        fluid.setViscosity(viscosity);
        fluid.setTemperature(temperature);
        fluid.setLuminosity(luminosity);
        fluid.setUnlocalizedName("lightningcraft:" + name);
        FluidRegistry.addBucketForFluid((Fluid)fluid);
        FluidRegistry.registerFluid((Fluid)fluid);
        return fluid;
    }

    private static BlockFluidClassic addFluidBlock(Fluid fluid, String blockName) {
        BlockFluidLC block = new BlockFluidLC(fluid);
        ResourceLocation location = new ResourceLocation("lightningcraft", blockName);
        block.setRegistryName(location);
        block.func_149663_c(location.toString());
        FLUIDS.add((Block)block);
        fluidBlockMap.put(fluid, (BlockFluidBase)block);
        fluidBlockNameMap.put((BlockFluidBase)block, blockName);
        return block;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRendering() {
        for (Fluid fluid : fluidBlockMap.keySet()) {
            BlockFluidBase block = fluidBlockMap.get(fluid);
            final ModelResourceLocation fluidModelLocation = new ModelResourceLocation("lightningcraft:" + fluidBlockNameMap.get(block), "fluid");
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMapperBase(){

                protected ModelResourceLocation func_178132_a(IBlockState state) {
                    return fluidModelLocation;
                }
            });
        }
    }
}

