/*
 * Decompiled with CFR 0.152.
 */
package xt9.inworldcrafting.common.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import xt9.inworldcrafting.client.ParticleHelper;

public class ParticleMessage
implements IMessage {
    private String type;
    private double posX;
    private double posY;
    private double posZ;
    private int particleCount = 0;

    public ParticleMessage() {
    }

    public ParticleMessage(String type, double x, double y, double z, int particleCount) {
        this.type = type;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.particleCount = particleCount;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.particleCount = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.type);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeInt(this.particleCount);
    }

    public static class Handler
    implements IMessageHandler<ParticleMessage, IMessage> {
        public IMessage onMessage(ParticleMessage message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                for (int i = 0; i < message.particleCount; ++i) {
                    ParticleHelper.spawnParticle(message.type, message.posX, message.posY, message.posZ);
                }
            });
            return null;
        }
    }
}

