/*
 * Decompiled with CFR 0.152.
 */
package eutros.framedcompactdrawers.block;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.EnumKeyType;
import com.jaquadro.minecraft.storagedrawers.block.dynamic.StatusModelData;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import eutros.framedcompactdrawers.block.AbstractKeyButtonToggle;
import eutros.framedcompactdrawers.block.tile.TileControllerCustom;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockControllerCustom
extends AbstractKeyButtonToggle {
    private static final ThreadLocal<Boolean> inTileLookup = ThreadLocal.withInitial(() -> false);
    private StatusModelData statusInfo;

    public BlockControllerCustom() {
        super("framedcompactdrawers:framed_drawer_controller", "framedcompactdrawers.framed_drawer_controller");
    }

    @Override
    @Nonnull
    protected BlockStateContainer createTrueBlockState() {
        return new ExtendedBlockState((Block)this, new IProperty[]{FACING}, new IUnlistedProperty[]{MAT_MODEL});
    }

    @Override
    protected void replaceDefaultState() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    @SideOnly(value=Side.CLIENT)
    public void initDynamic() {
        ResourceLocation location = new ResourceLocation("storagedrawers:models/dynamic/basicDrawers_full1.json");
        this.statusInfo = new StatusModelData(1, location);
    }

    public StatusModelData getStatusInfo(IBlockState state) {
        return this.statusInfo;
    }

    @Override
    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            IBlockState blockNorth = world.func_180495_p(pos.func_177978_c());
            IBlockState blockSouth = world.func_180495_p(pos.func_177968_d());
            IBlockState blockWest = world.func_180495_p(pos.func_177976_e());
            IBlockState blockEast = world.func_180495_p(pos.func_177974_f());
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (facing == EnumFacing.NORTH && blockNorth.func_185913_b() && !blockSouth.func_185913_b()) {
                facing = EnumFacing.SOUTH;
            }
            if (facing == EnumFacing.SOUTH && blockSouth.func_185913_b() && !blockNorth.func_185913_b()) {
                facing = EnumFacing.NORTH;
            }
            if (facing == EnumFacing.WEST && blockWest.func_185913_b() && !blockEast.func_185913_b()) {
                facing = EnumFacing.EAST;
            }
            if (facing == EnumFacing.EAST && blockEast.func_185913_b() && !blockWest.func_185913_b()) {
                facing = EnumFacing.WEST;
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)facing), 2);
        }
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack itemStack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)entity.func_174811_aO().func_176734_d()), 2);
    }

    public TileControllerCustom createTileEntity(World world, @Nullable IBlockState state) {
        return new TileControllerCustom();
    }

    @Override
    public TileControllerCustom getTrueTileEntity(IBlockAccess blockAccess, BlockPos pos) {
        if (inTileLookup.get().booleanValue()) {
            return null;
        }
        inTileLookup.set(true);
        TileEntity tile = blockAccess.func_175625_s(pos);
        inTileLookup.set(false);
        return tile instanceof TileControllerCustom ? (TileControllerCustom)tile : null;
    }

    public TileControllerCustom getTrueTileEntitySafe(World world, BlockPos pos) {
        TileControllerCustom tile = this.getTrueTileEntity((IBlockAccess)world, pos);
        if (tile == null) {
            tile = this.createTileEntity(world, null);
            world.func_175690_a(pos, (TileEntity)tile);
        }
        return tile;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        TileControllerCustom te = this.getTrueTileEntitySafe(world, pos);
        if (te == null) {
            return;
        }
        te.updateCache();
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        EnumFacing blockDir = (EnumFacing)state.func_177229_b((IProperty)FACING);
        TileControllerCustom tile = this.getTrueTileEntitySafe(world, pos);
        if (tile == null || tile.material().getSide().func_190926_b()) {
            return false;
        }
        ItemStack item = player.field_71071_by.func_70448_g();
        if (!item.func_190926_b() && this.toggle(world, pos, player, item.func_77973_b())) {
            return true;
        }
        if (blockDir != side) {
            return false;
        }
        if (!world.field_72995_K) {
            if (StorageDrawers.config.cache.debugTrace && item.func_190926_b()) {
                tile.printDebugInfo();
            }
            tile.interactPutItemsIntoInventory(player);
        }
        return true;
    }

    public boolean toggle(World world, BlockPos pos, EntityPlayer player, Item item) {
        if (world.field_72995_K || item == null) {
            return false;
        }
        if (item == ModItems.drawerKey) {
            this.toggle(world, pos, player, EnumKeyType.DRAWER);
        } else if (item == ModItems.shroudKey) {
            this.toggle(world, pos, player, EnumKeyType.CONCEALMENT);
        } else if (item == ModItems.quantifyKey) {
            this.toggle(world, pos, player, EnumKeyType.QUANTIFY);
        } else if (item == ModItems.personalKey) {
            this.toggle(world, pos, player, EnumKeyType.PERSONAL);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void toggle(World world, BlockPos pos, EntityPlayer player, EnumKeyType keyType) {
        if (world.field_72995_K) {
            return;
        }
        TileControllerCustom te = this.getTrueTileEntitySafe(world, pos);
        if (te == null) {
            return;
        }
        switch (keyType) {
            case DRAWER: {
                te.toggleLock(EnumSet.allOf(LockAttribute.class), LockAttribute.LOCK_POPULATED, player.func_146103_bH());
                break;
            }
            case CONCEALMENT: {
                te.toggleShroud(player.func_146103_bH());
                break;
            }
            case QUANTIFY: {
                te.toggleQuantified(player.func_146103_bH());
                break;
            }
            case PERSONAL: {
                String securityKey = ModItems.personalKey.getSecurityProviderKey(0);
                ISecurityProvider provider = StorageDrawers.securityRegistry.getProvider(securityKey);
                te.toggleProtection(player.func_146103_bH(), provider);
            }
        }
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)(meta + 2));
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return (((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() + 4) % 6;
    }

    @Override
    protected IBlockState droppedStateMorph(IBlockState state) {
        return state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return state.func_177229_b((IProperty)FACING) != side;
    }
}

