/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items.itemmatching;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.items.itemmatching.IMatcher;
import com.rwtema.extrautils2.utils.datastructures.ItemRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public interface IMatcherMaker
extends IMatcher {
    public ItemStack getMainStack();

    public Collection<ItemStack> getSubItems();

    default public Object getCraftingObject() {
        return this.getMainStack();
    }

    public static class MatcherMakerOreDic
    implements IMatcherMaker {
        final List<ItemStack> stacks;
        final List<String> exceptions = new ArrayList<String>();

        public MatcherMakerOreDic(String oreName) {
            this((List<ItemStack>)OreDictionary.getOres((String)oreName));
        }

        public MatcherMakerOreDic(List<ItemStack> stacks) {
            this.stacks = stacks;
        }

        public MatcherMakerOreDic addExceptions(String ... strings) {
            Collections.addAll(this.exceptions, strings);
            return this;
        }

        @Override
        public boolean matchesItemStack(@Nullable ItemStack t) {
            if (StackHelper.isNull(t)) {
                return false;
            }
            boolean b = false;
            for (ItemStack input : this.stacks) {
                if (!OreDictionary.itemMatches((ItemStack)input, (ItemStack)t, (boolean)false)) continue;
                b = true;
                break;
            }
            if (!b) {
                return false;
            }
            if (!this.exceptions.isEmpty()) {
                int[] oreIDs = OreDictionary.getOreIDs((ItemStack)t);
                for (String exception : this.exceptions) {
                    int oreID1 = OreDictionary.getOreID((String)exception);
                    for (int oreID : oreIDs) {
                        if (oreID != oreID1) continue;
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        public ItemStack getMainStack() {
            ItemStack fallbackStack = StackHelper.empty();
            Iterator<ItemStack> iterator = this.stacks.iterator();
            while (iterator.hasNext()) {
                ItemStack stack;
                fallbackStack = stack = iterator.next();
                if (!"minecraft".equals(stack.func_77973_b().getRegistryName().func_110624_b())) continue;
                return StackHelper.safeCopy(stack);
            }
            return fallbackStack;
        }

        @Override
        public Collection<ItemStack> getSubItems() {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ItemStack stack : this.stacks) {
                Collection<ItemStack> subItems = ItemRef.wrapCrafting(stack).getSubItems();
                builder.addAll((Iterable)subItems.stream().filter(this::matchesItemStack).collect(Collectors.toList()));
            }
            return builder.build();
        }

        @Override
        public Object getCraftingObject() {
            return this.stacks;
        }
    }
}

