/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.item;

import fi.dy.masa.enderutilities.inventory.item.InventoryItem;
import fi.dy.masa.enderutilities.inventory.item.InventoryItemMemoryCards;
import fi.dy.masa.enderutilities.inventory.item.InventoryItemPermissions;
import fi.dy.masa.enderutilities.item.base.ItemInventoryModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class InventoryItemModular
extends InventoryItemPermissions {
    protected ItemStack modularItemStack = ItemStack.field_190927_a;
    protected InventoryItemMemoryCards moduleInventory;
    protected ItemModule.ModuleType moduleType;

    public InventoryItemModular(ItemStack containerStack, EntityPlayer player, boolean allowCustomStackSizes, ItemModule.ModuleType moduleType) {
        this(containerStack, player, ((ItemInventoryModular)containerStack.func_77973_b()).getSizeInventory(containerStack), allowCustomStackSizes, ((ItemInventoryModular)containerStack.func_77973_b()).getSizeModuleInventory(containerStack), moduleType);
    }

    public InventoryItemModular(ItemStack containerStack, EntityPlayer player, int mainInvSize, boolean allowCustomStackSizes, int moduleInvSize, ItemModule.ModuleType moduleType) {
        super(containerStack, mainInvSize, 64, allowCustomStackSizes, player.func_130014_f_().field_72995_K, player);
        this.modularItemStack = containerStack;
        this.moduleType = moduleType;
        this.containerUUID = NBTUtils.getUUIDFromItemStack(containerStack, "UUID", true);
        this.hostInventory = null;
        this.moduleInventory = new InventoryItemMemoryCards(this, containerStack, moduleInvSize, player.func_130014_f_().field_72995_K);
        this.moduleInventory.readFromContainerItemStack();
        this.readFromContainerItemStack();
    }

    public InventoryItem getModuleInventory() {
        return this.moduleInventory;
    }

    public ItemStack getModularItemStack() {
        if (this.hostInventory != null && this.containerUUID != null) {
            return InventoryUtils.getItemStackByUUID(this.hostInventory, this.containerUUID, "UUID");
        }
        return this.modularItemStack;
    }

    public void setModularItemStack(ItemStack stack) {
        this.modularItemStack = stack;
    }

    @Override
    public ItemStack getContainerItemStack() {
        return this.getSelectedModuleStack();
    }

    public void readFromSelectedModuleStack() {
        super.readFromContainerItemStack();
    }

    @Override
    public void readFromContainerItemStack() {
        this.moduleInventory.readFromContainerItemStack();
        this.readFromSelectedModuleStack();
    }

    @Override
    protected void writeToContainerItemStack() {
        super.writeToContainerItemStack();
        this.moduleInventory.writeToContainerItemStack();
    }

    public int getSelectedModuleIndex() {
        if (this.getModularItemStack().func_190926_b()) {
            return -1;
        }
        return UtilItemModular.getStoredModuleSelection(this.getModularItemStack(), this.moduleType);
    }

    protected ItemStack getSelectedModuleStack() {
        int index = this.getSelectedModuleIndex();
        return index >= 0 && index < this.moduleInventory.getSlots() ? this.moduleInventory.getStackInSlot(index) : ItemStack.field_190927_a;
    }

    @Override
    public int getInventoryStackLimit() {
        return this.getInventoryStackLimitFromContainerStack(this.getSelectedModuleStack());
    }

    @Override
    public boolean isItemValidForSlot(int slotNum, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        ItemStack modularStack = this.getModularItemStack();
        if (!modularStack.func_190926_b() && modularStack.func_77973_b() == stack.func_77973_b()) {
            return false;
        }
        return super.isItemValidForSlot(slotNum, stack);
    }

    @Override
    public boolean isAccessibleBy(Entity entity) {
        return !this.getModularItemStack().func_190926_b() && super.isAccessibleBy(entity);
    }
}

