/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.gui.client;

import fi.dy.masa.enderutilities.gui.client.base.GuiEnderUtilities;
import fi.dy.masa.enderutilities.gui.client.button.GuiButtonIcon;
import fi.dy.masa.enderutilities.gui.client.button.GuiButtonStateCallback;
import fi.dy.masa.enderutilities.gui.client.button.IButtonStateCallback;
import fi.dy.masa.enderutilities.inventory.container.ContainerInventorySwapper;
import fi.dy.masa.enderutilities.inventory.container.base.MergeSlotRange;
import fi.dy.masa.enderutilities.inventory.container.base.SlotRange;
import fi.dy.masa.enderutilities.inventory.item.InventoryItemModular;
import fi.dy.masa.enderutilities.item.ItemInventorySwapper;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageGuiAction;
import fi.dy.masa.enderutilities.reference.ReferenceTextures;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.registry.ModRegistry;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiInventorySwapper
extends GuiEnderUtilities
implements IButtonStateCallback {
    public static final int BTN_ID_FIRST_SELECT_MODULE = 0;
    public static final int BTN_ID_FIRST_SELECT_PRESET = 4;
    public static final int BTN_ID_FIRST_TOGGLE_ROWS = 8;
    public static final int BTN_ID_FIRST_TOGGLE_COLUMNS = 20;
    public static final int BTN_ID_LOCKED = 40;
    public static final int BTN_ID_CYCLE = 41;
    private final ContainerInventorySwapper containerInvSwapper;
    private final InventoryItemModular inventory;
    private final int invSize;
    private int numModuleSlots;
    private int firstModuleSlotX;
    private int firstModuleSlotY;
    private int firstPlayerInvSlotX;
    private int firstPlayerInvSlotY;
    private int firstArmorSlotX;
    private int firstArmorSlotY;
    private final boolean baublesLoaded;

    public GuiInventorySwapper(ContainerInventorySwapper container) {
        super(container, 199, 249, "gui.container.inventoryswapper");
        this.containerInvSwapper = container;
        this.inventory = container.inventoryItemModular;
        this.invSize = this.inventory.getSlots();
        this.numModuleSlots = this.inventory.getModuleInventory().getSlots();
        this.baublesLoaded = ModRegistry.isModLoadedBaubles();
        if (this.baublesLoaded) {
            this.field_146999_f = 243;
            this.guiTexture = ReferenceTextures.getGuiTexture("gui.container.inventoryswapper.baubles");
            this.infoArea = new GuiEnderUtilities.InfoArea(227, 5, 11, 11, "enderutilities.gui.infoarea.inventoryswapper", new Object[0]);
        } else {
            this.infoArea = new GuiEnderUtilities.InfoArea(7, 43, 11, 11, "enderutilities.gui.infoarea.inventoryswapper", new Object[0]);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        SlotRange armorRange = this.containerInvSwapper.getPlayerArmorSlots();
        MergeSlotRange moduleRange = this.containerInvSwapper.getModuleSlots();
        SlotRange playerRange = this.containerInvSwapper.getPlayerMainInventorySlotRange();
        this.firstModuleSlotX = this.field_147003_i + this.containerInvSwapper.func_75139_a((int)moduleRange.first).field_75223_e;
        this.firstModuleSlotY = this.field_147009_r + this.containerInvSwapper.func_75139_a((int)moduleRange.first).field_75221_f;
        this.firstPlayerInvSlotX = this.field_147003_i + this.containerInvSwapper.func_75139_a((int)playerRange.first).field_75223_e;
        this.firstPlayerInvSlotY = this.field_147009_r + this.containerInvSwapper.func_75139_a((int)playerRange.first).field_75221_f;
        this.firstArmorSlotX = this.field_147003_i + this.containerInvSwapper.func_75139_a((int)armorRange.first).field_75223_e;
        this.firstArmorSlotY = this.field_147009_r + this.containerInvSwapper.func_75139_a((int)armorRange.first).field_75221_f;
        this.createButtons();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int xOff = this.baublesLoaded ? 20 : 0;
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"enderutilities.container.inventoryswapper", (Object[])new Object[0]), 6 + xOff, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"enderutilities.gui.label.slotpresets", (Object[])new Object[0]) + ":", 58 + xOff, 139, 0x404040);
    }

    @Override
    protected void func_146976_a(float gameTicks, int mouseX, int mouseY) {
        ItemStack stack;
        int index;
        int i;
        super.func_146976_a(gameTicks, mouseX, mouseY);
        this.bindTexture(this.guiTextureWidgets);
        if (!this.inventory.isAccessibleBy((Entity)this.player)) {
            for (i = 0; i < this.invSize; ++i) {
                Slot slot = this.containerInvSwapper.func_75139_a(i);
                this.func_73729_b(this.field_147003_i + slot.field_75223_e - 1, this.field_147009_r + slot.field_75221_f - 1, 102, 0, 18, 18);
            }
        }
        if (!this.inventory.getModuleInventory().isAccessibleBy((Entity)this.player)) {
            for (i = 0; i < this.numModuleSlots; ++i) {
                this.func_73729_b(this.firstModuleSlotX - 1 + i * 18, this.firstModuleSlotY - 1, 102, 0, 18, 18);
            }
        }
        if ((index = this.inventory.getSelectedModuleIndex()) >= 0) {
            this.func_73729_b(this.firstModuleSlotX - 1 + index * 18, this.firstModuleSlotY - 1, 102, 18, 18, 18);
            this.func_73729_b(this.firstModuleSlotX + 3 + index * 18, this.firstModuleSlotY + 18, 120, 0, 10, 10);
        }
        if (!(stack = this.containerInvSwapper.getContainerItem()).func_190926_b() && stack.func_77973_b() == EnderUtilitiesItems.INVENTORY_SWAPPER) {
            int r;
            ItemInventorySwapper swapper = (ItemInventorySwapper)stack.func_77973_b();
            byte sel = NBTUtils.getByte(stack, "InventorySwpapper", "SelectedPreset");
            this.func_73729_b(this.firstPlayerInvSlotX + 111 + sel * 12, this.firstPlayerInvSlotY - 29, 120, 0, 10, 10);
            long mask = swapper.getEnabledSlotsMask(stack);
            long bit = 1L;
            for (int c = 0; c < 9; ++c) {
                if ((mask & bit) != 0L) {
                    this.func_73729_b(this.firstPlayerInvSlotX - 1 + c * 18, this.firstPlayerInvSlotY - 1 + 58, 102, 18, 18, 18);
                }
                bit <<= 1;
            }
            for (r = 0; r < 3; ++r) {
                for (int c = 0; c < 9; ++c) {
                    if ((mask & bit) != 0L) {
                        this.func_73729_b(this.firstPlayerInvSlotX - 1 + c * 18, this.firstPlayerInvSlotY - 1 + r * 18, 102, 18, 18, 18);
                    }
                    bit <<= 1;
                }
            }
            for (r = 0; r < 4; ++r) {
                if ((mask & bit) != 0L) {
                    this.func_73729_b(this.firstArmorSlotX - 1, this.firstArmorSlotY - 1 + (3 - r) * 18, 102, 18, 18, 18);
                }
                bit <<= 1;
            }
            if ((mask & bit) != 0L) {
                this.func_73729_b(this.firstArmorSlotX - 1, this.firstArmorSlotY - 1 + 72, 102, 18, 18, 18);
            }
            bit <<= 1;
            if (this.baublesLoaded) {
                for (int i2 = 0; i2 < 7; ++i2) {
                    if ((mask & bit) != 0L) {
                        this.func_73729_b(this.firstArmorSlotX - 21, this.firstArmorSlotY - 1 + i2 * 18, 102, 18, 18, 18);
                    }
                    bit <<= 1;
                }
            }
        }
        for (int i3 = 0; i3 < this.numModuleSlots; ++i3) {
            if (!this.inventory.getModuleInventory().getStackInSlot(i3).func_190926_b()) continue;
            this.func_73729_b(this.firstModuleSlotX + i3 * 18, this.firstModuleSlotY, 240, 144, 16, 16);
        }
        if (this.baublesLoaded) {
            this.bindTexture(this.guiTextureWidgets);
            int swapperBaublesStart = this.containerInvSwapper.getSwapperBaublesSlots().first;
            int playerBaublesStart = this.containerInvSwapper.getPlayerBaublesSlots().first;
            for (int i4 = 0; i4 < 7; ++i4) {
                Slot slot = this.containerInvSwapper.func_75139_a(swapperBaublesStart + i4);
                if (slot != null && !slot.func_75216_d()) {
                    this.func_73729_b(this.firstModuleSlotX + 77, this.firstArmorSlotY + i4 * 18, 224, i4 * 16, 16, 16);
                }
                if ((slot = this.containerInvSwapper.func_75139_a(playerBaublesStart + i4)) == null || slot.func_75216_d()) continue;
                this.func_73729_b(this.firstArmorSlotX - 20, this.firstArmorSlotY + i4 * 18, 224, i4 * 16, 16, 16);
            }
        }
    }

    protected void createButtons() {
        int i;
        this.field_146292_n.clear();
        for (i = 0; i < this.numModuleSlots; ++i) {
            this.field_146292_n.add(new GuiButtonIcon(0 + i, this.firstModuleSlotX + 4 + i * 18, this.firstModuleSlotY + 19, 8, 8, 0, 0, this.guiTextureWidgets, 8, 0));
        }
        for (i = 0; i < 4; ++i) {
            this.field_146292_n.add(new GuiButtonIcon(4 + i, this.firstPlayerInvSlotX + 112 + i * 12, this.firstPlayerInvSlotY - 28, 8, 8, 0, 128 + i * 8, this.guiTextureWidgets, 8, 0));
        }
        this.field_146292_n.add(new GuiButtonIcon(8, this.firstPlayerInvSlotX - 17, this.firstPlayerInvSlotY + 59, 14, 14, 60, 28, this.guiTextureWidgets, 14, 0));
        for (i = 0; i < 3; ++i) {
            this.field_146292_n.add(new GuiButtonIcon(8 + i + 1, this.firstPlayerInvSlotX - 17, this.firstPlayerInvSlotY + 1 + i * 18, 14, 14, 60, 28, this.guiTextureWidgets, 14, 0));
        }
        for (i = 0; i < 9; ++i) {
            this.field_146292_n.add(new GuiButtonIcon(20 + i, this.firstPlayerInvSlotX + 1 + i * 18, this.firstPlayerInvSlotY - 17, 14, 14, 60, 42, this.guiTextureWidgets, 14, 0));
        }
        this.field_146292_n.add(new GuiButtonIcon(29, this.firstArmorSlotX + 1, this.firstArmorSlotY + 91, 14, 14, 60, 56, this.guiTextureWidgets, 14, 0));
        this.field_146292_n.add(new GuiButtonStateCallback(40, this.firstPlayerInvSlotX + 1, this.firstPlayerInvSlotY - 28, 8, 8, 8, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(0, 0, "enderutilities.gui.label.item.enabled"), GuiButtonStateCallback.ButtonState.createTranslate(0, 48, "enderutilities.gui.label.item.disabled")));
        this.field_146292_n.add(new GuiButtonStateCallback(41, this.firstPlayerInvSlotX + 13, this.firstPlayerInvSlotY - 28, 8, 8, 8, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(0, 40, "enderutilities.gui.label.cyclemode.disabled"), GuiButtonStateCallback.ButtonState.createTranslate(0, 88, "enderutilities.gui.label.cyclemode.enabled")));
        if (this.baublesLoaded) {
            this.field_146292_n.add(new GuiButtonIcon(30, this.firstArmorSlotX - 19, this.firstArmorSlotY + 127, 14, 14, 60, 56, this.guiTextureWidgets, 14, 0));
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k >= 0 && button.field_146127_k < 0 + this.numModuleSlots) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1003, 0, button.field_146127_k - 0));
        } else if (button.field_146127_k >= 4 && button.field_146127_k < 8) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1003, 1, button.field_146127_k - 4));
        } else if (button.field_146127_k >= 8 && button.field_146127_k < 12) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1003, 2, button.field_146127_k - 8));
        } else if (button.field_146127_k >= 20 && button.field_146127_k <= 30) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1003, 3, button.field_146127_k - 20));
        } else if (button.field_146127_k == 40) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1003, 4, 0));
        } else if (button.field_146127_k == 41) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1003, 5, 0));
        }
    }

    @Override
    public int getButtonStateIndex(int callbackId) {
        ItemStack stack = this.containerInvSwapper.getContainerItem();
        if (!stack.func_190926_b()) {
            if (callbackId == 40) {
                return NBTUtils.getBoolean(stack, "InventorySwpapper", "Locked") ? 1 : 0;
            }
            if (callbackId == 41) {
                return NBTUtils.getBoolean(stack, "InventorySwpapper", "Cycle") ? 1 : 0;
            }
        }
        return 0;
    }

    @Override
    public boolean isButtonEnabled(int callbackId) {
        return true;
    }
}

