/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.block;

import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.item.block.ItemBlockStorage;
import fi.dy.masa.enderutilities.tileentity.TileEntityBarrel;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.TileUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockBarrel
extends BlockEnderUtilitiesInventory {
    public static final PropertyBool LABEL_UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool LABEL_DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool LABEL_FRONT = PropertyBool.func_177716_a((String)"front");
    public static final PropertyBool LABEL_BACK = PropertyBool.func_177716_a((String)"back");
    public static final PropertyBool LABEL_LEFT = PropertyBool.func_177716_a((String)"left");
    public static final PropertyBool LABEL_RIGHT = PropertyBool.func_177716_a((String)"right");

    public BlockBarrel(String name, float hardness, float resistance, int harvestLevel, Material material) {
        super(name, hardness, resistance, harvestLevel, material);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)CREATIVE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FACING_H, (Comparable)BlockEnderUtilities.DEFAULT_FACING).func_177226_a((IProperty)LABEL_UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LABEL_DOWN, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LABEL_FRONT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LABEL_BACK, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LABEL_LEFT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LABEL_RIGHT, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{FACING_H, CREATIVE, LABEL_UP, LABEL_DOWN, LABEL_FRONT, LABEL_BACK, LABEL_LEFT, LABEL_RIGHT}, new IUnlistedProperty[]{CAMOBLOCKSTATE, CAMOBLOCKSTATEEXTENDED});
    }

    @Override
    protected boolean isCamoBlock() {
        return true;
    }

    @Override
    public ItemBlock createItemBlock() {
        return new ItemBlockStorage(this);
    }

    @Override
    protected String[] generateUnlocalizedNames() {
        return new String[]{"barrel"};
    }

    @Override
    protected String[] generateTooltipNames() {
        return new String[]{"barrel"};
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @Override
    protected TileEntityEnderUtilities createTileEntityInstance(World worldIn, IBlockState state) {
        return new TileEntityBarrel();
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)CREATIVE)).booleanValue() || this.retainsContentsWhenBroken((IBlockAccess)world, pos, state)) {
            world.func_175666_e(pos, (Block)this);
            world.func_175713_t(pos);
        } else {
            TileEntityBarrel te = BlockBarrel.getTileEntitySafely((IBlockAccess)world, pos, TileEntityBarrel.class);
            if (te != null) {
                InventoryUtils.dropInventoryContentsInWorld(world, pos, te.getUpgradeInventory());
                ItemStack stack = te.getBaseItemHandler().getStackInSlot(0);
                if (!stack.func_190926_b()) {
                    EntityUtils.dropItemStacksInWorld(world, pos, stack, Math.min(stack.func_190916_E(), 4096), true);
                }
                world.func_175666_e(pos, (Block)this);
                world.func_175713_t(pos);
            }
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest && this.retainsContentsWhenBroken((IBlockAccess)world, pos, state)) {
            this.func_176208_a(world, pos, state, player);
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_175698_g(pos);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (this.retainsContentsWhenBroken(world, pos, state)) {
            drops.add((Object)this.getDroppedItemWithNBT(world, pos, state, false));
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    private boolean retainsContentsWhenBroken(IBlockAccess world, BlockPos pos, IBlockState state) {
        TileEntityBarrel te = BlockBarrel.getTileEntitySafely(world, pos, TileEntityBarrel.class);
        return te != null && te.retainsContentsWhenBroken();
    }

    protected ItemStack getDroppedItemWithNBT(IBlockAccess worldIn, BlockPos pos, IBlockState state, boolean addNBTLore) {
        Random rand = worldIn instanceof World ? ((World)worldIn).field_73012_v : RANDOM;
        ItemStack stack = new ItemStack(this.func_180660_a(state, rand, 0), 1, 0);
        TileEntityEnderUtilities te = BlockBarrel.getTileEntitySafely(worldIn, pos, TileEntityEnderUtilities.class);
        if (te != null) {
            return TileUtils.storeTileEntityInStackWithCachedInventory(stack, te, addNBTLore, 9);
        }
        return stack;
    }

    @Deprecated
    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)CREATIVE)).booleanValue()) {
            return -1.0f;
        }
        TileEntityBarrel te = BlockBarrel.getTileEntitySafely((IBlockAccess)world, pos, TileEntityBarrel.class);
        if (te != null && !te.retainsContentsWhenBroken() && te.isOverSpillCapacity()) {
            return -1.0f;
        }
        return super.func_176195_g(state, world, pos);
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)CREATIVE) != false ? 1 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CREATIVE, (Comparable)Boolean.valueOf((meta & 1) != 0));
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityBarrel te = BlockBarrel.getTileEntitySafely(world, pos, TileEntityBarrel.class);
        if (te != null) {
            int labelMask = te.getLabelMask(true);
            EnumFacing facing = te.getFacing();
            state = state.func_177226_a((IProperty)FACING_H, (Comparable)facing);
            state = state.func_177226_a((IProperty)LABEL_UP, (Comparable)Boolean.valueOf((labelMask & 1 << EnumFacing.UP.func_176745_a()) != 0));
            state = state.func_177226_a((IProperty)LABEL_DOWN, (Comparable)Boolean.valueOf((labelMask & 1 << EnumFacing.DOWN.func_176745_a()) != 0));
            state = state.func_177226_a((IProperty)LABEL_FRONT, (Comparable)Boolean.valueOf((labelMask & 1 << facing.func_176745_a()) != 0));
            state = state.func_177226_a((IProperty)LABEL_BACK, (Comparable)Boolean.valueOf((labelMask & 1 << facing.func_176734_d().func_176745_a()) != 0));
            state = state.func_177226_a((IProperty)LABEL_LEFT, (Comparable)Boolean.valueOf((labelMask & 1 << facing.func_176746_e().func_176745_a()) != 0));
            state = state.func_177226_a((IProperty)LABEL_RIGHT, (Comparable)Boolean.valueOf((labelMask & 1 << facing.func_176735_f().func_176745_a()) != 0));
        }
        return state;
    }
}

