/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.handler;

import com.bewitchment.Bewitchment;
import com.bewitchment.Util;
import com.bewitchment.api.BewitchmentAPI;
import com.bewitchment.api.capability.extendedworld.ExtendedWorld;
import com.bewitchment.api.capability.magicpower.MagicPower;
import com.bewitchment.api.event.LockCheckEvent;
import com.bewitchment.api.event.WitchesCauldronEvent;
import com.bewitchment.api.message.DismountBroomMessage;
import com.bewitchment.api.registry.entity.EntityBroom;
import com.bewitchment.common.block.BlockBrazier;
import com.bewitchment.common.block.tile.entity.TileEntityBrazier;
import com.bewitchment.common.block.tile.entity.TileEntityWitchesCauldron;
import com.bewitchment.common.entity.spirit.demon.AbstractGreaterDemon;
import com.bewitchment.common.entity.spirit.demon.EntityBafometyr;
import com.bewitchment.common.entity.spirit.demon.EntityCambion;
import com.bewitchment.common.entity.spirit.demon.EntityCleaver;
import com.bewitchment.common.entity.spirit.demon.EntityDruden;
import com.bewitchment.common.entity.spirit.demon.EntityFeuerwurm;
import com.bewitchment.common.entity.spirit.demon.EntityHellhound;
import com.bewitchment.common.entity.spirit.demon.EntityLeonard;
import com.bewitchment.common.entity.spirit.demon.EntityShadowPerson;
import com.bewitchment.common.entity.spirit.ghost.EntityBlackDog;
import com.bewitchment.common.entity.spirit.ghost.EntityGhost;
import com.bewitchment.common.entity.util.IPledgeable;
import com.bewitchment.common.entity.util.ModEntityMob;
import com.bewitchment.common.item.tool.ItemSkeletonKey;
import com.bewitchment.registry.ModObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.brewing.PotionBrewEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MiscHandler {
    Biome.SpawnListEntry cleaverSpawn = new Biome.SpawnListEntry(EntityCleaver.class, 2, 0, 1);
    Biome.SpawnListEntry bafometyrSpawn = new Biome.SpawnListEntry(EntityBafometyr.class, 2, 0, 1);
    Biome.SpawnListEntry wurmSpawn = new Biome.SpawnListEntry(EntityFeuerwurm.class, 3, 0, 1);
    Biome.SpawnListEntry hellhoundSpawn = new Biome.SpawnListEntry(EntityHellhound.class, 3, 0, 1);
    Biome.SpawnListEntry cambionSpawn = new Biome.SpawnListEntry(EntityCambion.class, 1, 0, 1);
    Biome.SpawnListEntry shadeSpawn = new Biome.SpawnListEntry(EntityShadowPerson.class, 1, 0, 1);
    Biome.SpawnListEntry ghostSpawn = new Biome.SpawnListEntry(EntityGhost.class, 1, 0, 1);
    Biome.SpawnListEntry dogeSpawn = new Biome.SpawnListEntry(EntityBlackDog.class, 1, 0, 1);

    @SubscribeEvent
    public void applyBrewingBuffs(WitchesCauldronEvent.CreatePotionEvent event) {
        if (BewitchmentAPI.hasAlchemistGear((EntityLivingBase)event.getUser())) {
            event.setBoosted(true);
            event.setBottles(event.getBottles() + 1);
        }
        if (ExtendedWorld.playerPledgedToDemon(event.getUser().field_70170_p, event.getUser(), "leonard")) {
            EntityPlayer player = event.getUser();
            List entities = player.field_70170_p.func_175647_a(ModEntityMob.class, new AxisAlignedBB(player.field_70165_t - 32.0, player.field_70163_u - 32.0, player.field_70161_v - 32.0, player.field_70165_t + 32.0, player.field_70163_u + 32.0, player.field_70161_v + 32.0), e -> e instanceof IPledgeable);
            for (Entity entity : entities) {
                if (!(entity instanceof EntityLeonard)) continue;
                event.setAllowHigher(true);
                event.setBottles(event.getBottles() + 1);
            }
        }
    }

    @SubscribeEvent
    public void onNetherEntitySpawnsCheck(WorldEvent.PotentialSpawns ev) {
        WorldServer world = (WorldServer)ev.getWorld();
        if (ev.getType() == EnumCreatureType.MONSTER && world.field_73012_v.nextInt(100) >= 5 && world.field_73011_w.func_186058_p() == DimensionType.NETHER && world.func_72863_F().field_186029_c.func_193414_a((World)world, "Fortress", ev.getPos())) {
            ev.getList().add(this.cleaverSpawn);
            ev.getList().add(this.bafometyrSpawn);
            ev.getList().add(this.wurmSpawn);
            ev.getList().add(this.hellhoundSpawn);
            ev.getList().add(this.cambionSpawn);
            ev.getList().add(this.shadeSpawn);
        }
    }

    @SubscribeEvent
    public void onStrongholdSpawnsCheck(WorldEvent.PotentialSpawns ev) {
        WorldServer world = (WorldServer)ev.getWorld();
        if (ev.getType() == EnumCreatureType.MONSTER && (double)ev.getWorld().func_130001_d() == 0.0 && !world.func_72935_r() && world.field_73012_v.nextInt(100) >= 5 && world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD && world.func_72863_F().field_186029_c.func_193414_a((World)world, "Stronghold", ev.getPos())) {
            ev.getList().add(this.shadeSpawn);
            ev.getList().add(this.ghostSpawn);
            ev.getList().add(this.dogeSpawn);
        }
    }

    @SubscribeEvent
    public void onVillageSpawnsCheck(WorldEvent.PotentialSpawns ev) {
        WorldServer world = (WorldServer)ev.getWorld();
        if (ev.getType() == EnumCreatureType.MONSTER && (double)ev.getWorld().func_130001_d() == 1.0 && !world.func_72935_r() && !world.func_72896_J() && world.field_73012_v.nextInt(100) >= 5 && world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD && world.func_72863_F().field_186029_c.func_193414_a((World)world, "Village", ev.getPos())) {
            ev.getList().add(this.cambionSpawn);
        }
    }

    @SubscribeEvent
    public void onMineshaftSpawnsCheck(WorldEvent.PotentialSpawns ev) {
        WorldServer world = (WorldServer)ev.getWorld();
        if (ev.getType() == EnumCreatureType.MONSTER && (double)ev.getWorld().func_130001_d() == 0.5 && !world.func_72935_r() && world.field_73012_v.nextInt(100) >= 5 && world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD && world.func_72863_F().field_186029_c.func_193414_a((World)world, "Mineshaft", ev.getPos())) {
            ev.getList().add(this.shadeSpawn);
            ev.getList().add(this.ghostSpawn);
        }
    }

    @SubscribeEvent
    public void handleSkeletonKey(LockCheckEvent.LockCheckedEvent event) {
        if (!event.isOpened() && !event.getUser().field_70170_p.field_72995_K) {
            for (ItemStack stack : Bewitchment.proxy.getEntireInventory(event.getUser())) {
                if (!(stack.func_77973_b() instanceof ItemSkeletonKey)) continue;
                event.setSendMessage(false);
                IBlockState state = event.getUser().field_70170_p.func_180495_p(event.getLock());
                float mult = 1.0f;
                if (state.func_177230_c() instanceof BlockContainer) {
                    mult = 4.0f;
                } else if (state.func_177230_c() instanceof BlockTrapDoor) {
                    mult = 3.0f;
                } else if (state.func_177230_c() instanceof BlockDoor) {
                    mult = 2.0f;
                }
                if (event.getUser().field_71068_ca < 10) {
                    event.getUser().func_146105_b((ITextComponent)new TextComponentTranslation("skeleton_key.invalid.xp", new Object[0]), true);
                    return;
                }
                if (MagicPower.attemptDrain(null, event.getUser(), Math.round(250.0f * mult))) {
                    stack.func_77972_a(1, (EntityLivingBase)event.getUser());
                    event.getUser().func_82242_a(-10);
                    event.setResult(true);
                } else {
                    event.getUser().func_146105_b((ITextComponent)new TextComponentTranslation("skeleton_key.invalid.me", new Object[0]), true);
                }
                return;
            }
        }
    }

    @SubscribeEvent
    public void onFindAttackEntity(LivingSetAttackTargetEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K) {
            if (event.getEntityLiving() instanceof ModEntityMob) {
                ModEntityMob mob = (ModEntityMob)event.getEntityLiving();
                if (mob.summoner != null && event.getTarget() != null && event.getTarget().getPersistentID() == mob.summoner) {
                    mob.func_70624_b(null);
                }
            }
            if (event.getEntityLiving() instanceof EntityTameable && event.getTarget() instanceof EntityDruden) {
                ((EntityTameable)event.getEntityLiving()).func_70624_b(null);
            }
            if (event.getEntityLiving() instanceof EntityGolem && event.getTarget() instanceof EntityCambion) {
                ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
            }
            if (event.getEntityLiving() instanceof EntityBafometyr && event.getTarget() instanceof EntityPlayer && ExtendedWorld.playerPledgedToDemon(event.getEntityLiving().field_70170_p, (EntityPlayer)event.getTarget(), "baphomet")) {
                ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
            }
            if (event.getEntityLiving() instanceof EntityFeuerwurm && event.getTarget() instanceof EntityPlayer && ExtendedWorld.playerPledgedToDemon(event.getEntityLiving().field_70170_p, (EntityPlayer)event.getTarget(), "baphomet")) {
                ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
            }
            if (event.getEntityLiving() instanceof EntityCambion && event.getTarget() instanceof EntityPlayer && ExtendedWorld.playerPledgedToDemon(event.getEntityLiving().field_70170_p, (EntityPlayer)event.getTarget(), "leonard")) {
                ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
            }
            if (event.getEntityLiving() instanceof IPledgeable && event.getTarget() instanceof EntityPlayer && ExtendedWorld.playerPledgedToDemon(event.getEntityLiving().field_70170_p, (EntityPlayer)event.getTarget(), ((IPledgeable)event.getEntityLiving()).getPledgeName())) {
                ((EntityMob)event.getEntityLiving()).func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public void lootLoad(LootTableLoadEvent evt) {
        if (evt.getName().equals((Object)LootTableList.field_186425_g)) {
            evt.getTable().addPool(new LootPool(new LootEntry[]{new LootEntryTable(new ResourceLocation("bewitchment", "chests/nether_materials"), 5, 0, new LootCondition[0], "bewitchment_nether_materials_entry")}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), "bewitchment_nether_materials_pool"));
        }
        if (evt.getName().equals((Object)LootTableList.field_186422_d) || evt.getName().equals((Object)LootTableList.field_186424_f) || evt.getName().equals((Object)LootTableList.field_186428_j) || evt.getName().equals((Object)LootTableList.field_186427_i) || evt.getName().equals((Object)LootTableList.field_186425_g) || evt.getName().equals((Object)LootTableList.field_186423_e) || evt.getName().equals((Object)LootTableList.field_186430_l) || evt.getName().equals((Object)LootTableList.field_186429_k) || evt.getName().equals((Object)LootTableList.field_186431_m) || evt.getName().equals((Object)LootTableList.field_186421_c) || evt.getName().equals((Object)LootTableList.field_186426_h) || evt.getName().equals((Object)LootTableList.field_191192_o)) {
            evt.getTable().addPool(new LootPool(new LootEntry[]{new LootEntryTable(new ResourceLocation("bewitchment", "chests/materials"), 5, 0, new LootCondition[0], "bewitchment_materials_entry")}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), "bewitchment_materials_pool"));
        }
    }

    @SubscribeEvent
    public void attemptBrew(PotionBrewEvent.Pre event) {
        for (int i = 0; i < event.getLength() - 1; ++i) {
            ItemStack stack = event.getItem(i);
            if (!stack.func_77942_o() || !stack.func_77978_p().func_74767_n("bewitchment_brew")) continue;
            Item item = event.getItem(3).func_77973_b();
            event.setItem(i, TileEntityWitchesCauldron.createPotion(PotionUtils.func_185189_a((ItemStack)stack), item == Items.field_151016_H ? 1 : (item == Items.field_185157_bK ? 2 : 0)));
            event.getItem(3).func_190918_g(1);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void explode(ExplosionEvent.Detonate event) {
        for (int i = event.getAffectedBlocks().size() - 1; i >= 0; --i) {
            if (!this.isNextToJuniperDoor(event.getWorld(), (BlockPos)event.getAffectedBlocks().get(i))) continue;
            event.getAffectedBlocks().remove(i);
        }
    }

    @SubscribeEvent
    public void breakBlock(BlockEvent.BreakEvent event) {
        if (this.isNextToJuniperDoor(event.getWorld(), event.getPos())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void breakSpeed(PlayerEvent.BreakSpeed event) {
        if (this.isNextToJuniperDoor(event.getEntityPlayer().field_70170_p, event.getPos())) {
            event.setNewSpeed(0.0f);
        }
    }

    private boolean isNextToJuniperDoor(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() != ModObjects.juniper_door.door && world.func_180495_p(pos.func_177984_a()).func_177230_c() == ModObjects.juniper_door.door;
    }

    @SubscribeEvent
    public void onCollectFire(PlayerInteractEvent.RightClickBlock event) {
        Block block = event.getWorld().func_180495_p(event.getPos().func_177972_a(Objects.requireNonNull(event.getFace()))).func_177230_c();
        EntityPlayer player = event.getEntityPlayer();
        if (block == ModObjects.hellfire && !player.func_70093_af() && player.func_184586_b(event.getHand()).func_77973_b() == Items.field_151069_bo && !event.getWorld().field_72995_K) {
            Util.replaceAndConsumeItem(player, event.getHand(), new ItemStack(ModObjects.bottled_hellfire));
            event.getWorld().func_175698_g(event.getPos().func_177972_a(event.getFace()));
            event.getWorld().func_184133_a(null, event.getPos().func_177972_a(event.getFace()), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.75f);
        }
    }

    @SubscribeEvent
    public void extinguishFire(PlayerInteractEvent.LeftClickBlock event) {
        BlockPos pos = event.getPos().func_177972_a(event.getFace());
        if (event.getWorld().func_180495_p(pos).func_177230_c() == ModObjects.hellfire) {
            event.getWorld().func_180498_a(event.getEntityPlayer(), 1009, pos, 0);
            event.getWorld().func_175698_g(pos);
        }
    }

    @SubscribeEvent
    public void wakeUp(PlayerWakeUpEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.func_130014_f_();
        BlockPos pos = player.func_180425_c();
        ArrayList<Potion> potions = new ArrayList<Potion>();
        int length = 600;
        int strength = 0;
        for (BlockPos temp : BlockPos.func_177975_b((BlockPos)player.func_180425_c().func_177982_a(-2, -2, -2), (BlockPos)player.func_180425_c().func_177982_a(2, 2, 2))) {
            if (!(world.func_180495_p(temp).func_177230_c() instanceof BlockBrazier) || !((Boolean)world.func_180495_p(temp).func_177229_b((IProperty)BlockBrazier.LIT)).booleanValue()) continue;
            TileEntityBrazier te = (TileEntityBrazier)world.func_175625_s(temp);
            if (te.incense == null) continue;
            if (length == 600 && te.incense.getRegistryName().equals((Object)new ResourceLocation("bewitchment", "intensity"))) {
                ++strength;
                continue;
            }
            if (strength == 0 && te.incense.getRegistryName().equals((Object)new ResourceLocation("bewitchment", "concentration"))) {
                length = 1200;
                continue;
            }
            potions.addAll(te.incense.effects);
        }
        strength = Math.min(strength, 2);
        for (Potion potion : potions) {
            if (potion == MobEffects.field_76443_y) {
                player.func_70690_d(new PotionEffect(potion, 60, 1));
                continue;
            }
            player.func_70690_d(new PotionEffect(potion, 20 * length, strength));
        }
    }

    @SubscribeEvent
    public void takeBlood(LivingDeathEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            if ((event.getEntityLiving() instanceof EntityAnimal || event.getEntityLiving() instanceof EntityPlayer || event.getEntityLiving() instanceof EntityVillager) && player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == ModObjects.athame && player.func_184586_b(EnumHand.OFF_HAND).func_77973_b() == Items.field_151069_bo) {
                Util.replaceAndConsumeItem(player, EnumHand.OFF_HAND, new ItemStack(ModObjects.bottle_of_blood));
            }
        }
    }

    @SubscribeEvent
    public void depledgeGoats(LivingHurtEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof AbstractGreaterDemon && event.getSource().func_76346_g() instanceof EntityPlayer) {
            ExtendedWorld.depledgePlayerToDemon(event.getEntityLiving().field_70170_p, (EntityPlayer)event.getSource().func_76346_g(), (IPledgeable)event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void dismountBroom(EntityMountEvent event) {
        if (event.isDismounting() && event.getEntityBeingMounted() instanceof EntityBroom) {
            if (!event.getEntityBeingMounted().field_70170_p.field_72995_K && event.getEntityMounting() instanceof EntityPlayerMP) {
                Bewitchment.network.sendTo((IMessage)new DismountBroomMessage(), (EntityPlayerMP)event.getEntityMounting());
            }
            if (event.getEntityBeingMounted().field_70170_p.field_72995_K && event.getEntityMounting() instanceof EntityPlayerSP) {
                Bewitchment.network.sendToServer((IMessage)new DismountBroomMessage());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (player instanceof EntityPlayerMP) {
            ExtendedWorld.get(player.field_70170_p).syncToClient((EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public void customDyeInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof EntitySheep) {
            EntityPlayer player = event.getEntityPlayer();
            EntitySheep sheep = (EntitySheep)event.getTarget();
            if (!(sheep.func_70892_o() || sheep.func_175509_cj() == EnumDyeColor.BLACK && sheep.func_175509_cj() == EnumDyeColor.BROWN)) {
                if (player.func_184586_b(event.getHand()).func_77973_b() == ModObjects.iron_gall_ink) {
                    if (!player.func_184812_l_()) {
                        player.func_184586_b(event.getHand()).func_190920_e(player.func_184586_b(event.getHand()).func_190916_E() - 1);
                    }
                    sheep.func_175512_b(EnumDyeColor.BLACK);
                }
                if (player.func_184586_b(event.getHand()).func_77973_b() == ModObjects.dragons_blood_resin) {
                    if (!player.func_184812_l_()) {
                        player.func_184586_b(event.getHand()).func_190920_e(player.func_184586_b(event.getHand()).func_190916_E() - 1);
                    }
                    sheep.func_175512_b(EnumDyeColor.RED);
                }
                if (player.func_184586_b(event.getHand()).func_77973_b() == ModObjects.ink_cap_dye) {
                    if (!player.func_184812_l_()) {
                        player.func_184586_b(event.getHand()).func_190920_e(player.func_184586_b(event.getHand()).func_190916_E() - 1);
                    }
                    sheep.func_175512_b(EnumDyeColor.BLUE);
                }
                if (player.func_184586_b(event.getHand()).func_77973_b() == ModObjects.catechu_brown) {
                    if (!player.func_184812_l_()) {
                        player.func_184586_b(event.getHand()).func_190920_e(player.func_184586_b(event.getHand()).func_190916_E() - 1);
                    }
                    sheep.func_175512_b(EnumDyeColor.BROWN);
                }
            }
        }
    }
}

