/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.materialsystem.parttype;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.teamacronymcoders.base.materialsystem.MaterialUser;
import com.teamacronymcoders.base.materialsystem.items.ItemMaterialArmor;
import com.teamacronymcoders.base.materialsystem.materialparts.MaterialPart;
import com.teamacronymcoders.base.materialsystem.partdata.DataPartParsers;
import com.teamacronymcoders.base.materialsystem.partdata.MaterialPartData;
import com.teamacronymcoders.base.materialsystem.parttype.PartDataPiece;
import com.teamacronymcoders.base.materialsystem.parttype.PartType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.EnumHelper;

public class ArmorPartType
extends PartType {
    private Map<Integer, ItemStack> chestPlates;

    public ArmorPartType() {
        super("Armor");
        ArrayList dataPieceList = Lists.newArrayList();
        dataPieceList.add(new PartDataPiece("enchantability"));
        dataPieceList.add(new PartDataPiece("durability"));
        dataPieceList.add(new PartDataPiece("reduction"));
        dataPieceList.add(new PartDataPiece("toughness"));
        this.setData(dataPieceList);
    }

    @Override
    public void setup(@Nonnull MaterialPart materialPart, @Nonnull MaterialUser materialUser) {
        ItemArmor.ArmorMaterial iron = ItemArmor.ArmorMaterial.IRON;
        MaterialPartData data = materialPart.getData();
        int enchantability = data.getValue("enchantability", iron.func_78045_a(), DataPartParsers::getInt);
        float toughness = data.getValue("toughness", Float.valueOf(iron.func_189416_e()), DataPartParsers::getFloat).floatValue();
        int durability = data.getValue("durability", 15, DataPartParsers::getInt);
        List<Integer> damageReduction = data.getValues("reduction", new Integer[]{2, 5, 6, 2}, DataPartParsers::getInt, 4);
        int[] damageArray = new int[damageReduction.size()];
        for (int i = 0; i < damageReduction.size(); ++i) {
            damageArray[i] = damageReduction.get(i);
        }
        String name = materialPart.getMaterial().getUnlocalizedName();
        ItemArmor.ArmorMaterial armorMaterial = EnumHelper.addArmorMaterial((String)name, (String)name, (int)durability, (int[])damageArray, (int)enchantability, (SoundEvent)SoundEvents.field_187725_r, (float)toughness);
        if (this.chestPlates == null) {
            this.chestPlates = Maps.newHashMap();
        }
        materialUser.registerItem((Item)new ItemMaterialArmor(materialPart, armorMaterial, EntityEquipmentSlot.HEAD));
        materialUser.registerItem((Item)new ItemMaterialArmor(materialPart, armorMaterial, EntityEquipmentSlot.LEGS));
        materialUser.registerItem((Item)new ItemMaterialArmor(materialPart, armorMaterial, EntityEquipmentSlot.FEET));
        ItemMaterialArmor chestPlate = new ItemMaterialArmor(materialPart, armorMaterial, EntityEquipmentSlot.CHEST);
        this.chestPlates.put(materialPart.getId(), new ItemStack((Item)chestPlate));
        materialUser.registerItem((Item)chestPlate);
    }

    @Override
    public ItemStack getItemStack(MaterialPart materialPart) {
        return this.chestPlates.get(materialPart.getId());
    }
}

