/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ParticleEffectWatcher
implements ITickHandler {
    public static final ParticleEffectWatcher INSTANCE = new ParticleEffectWatcher();
    private Map<Integer, List<BlockPos>> worldWatch = Maps.newHashMap();

    private ParticleEffectWatcher() {
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        this.worldWatch.getOrDefault(((World)context[0]).field_73011_w.getDimension(), Lists.newArrayList()).clear();
    }

    public boolean mayFire(World world, BlockPos pos) {
        int dimId = world.field_73011_w.getDimension();
        this.worldWatch.putIfAbsent(dimId, Lists.newArrayList());
        List<BlockPos> worldPos = this.worldWatch.get(dimId);
        return !worldPos.contains(pos) && worldPos.add(pos);
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.WORLD);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "ParticleEffect Limiter";
    }
}

