/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting;

import appeng.api.config.Actionable;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AEConfig;
import appeng.crafting.CraftBranchFailure;
import appeng.crafting.CraftingJob;
import appeng.crafting.CraftingTreeNode;
import appeng.crafting.MECraftingInventory;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.google.common.collect.ImmutableCollection;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class CraftingTreeProcess {
    private final CraftingTreeNode parent;
    final ICraftingPatternDetails details;
    private final CraftingJob job;
    private final Object2LongArrayMap<CraftingTreeNode> nodes = new Object2LongArrayMap();
    private final int depth;
    private final ICraftingGrid cc;
    private final World world;
    boolean possible = true;
    private long crafts = 0L;
    private long bytes = 0L;

    public CraftingTreeProcess(ICraftingGrid cc, CraftingJob job, ICraftingPatternDetails details, CraftingTreeNode craftingTreeNode, int depth) {
        this.parent = craftingTreeNode;
        this.details = details;
        this.job = job;
        this.depth = depth;
        this.cc = cc;
        this.world = job.getWorld();
    }

    public void addProcess() {
        if (!this.nodes.isEmpty()) {
            return;
        }
        IAEItemStack[] list = this.details.getInputs();
        block0: for (IAEItemStack part : this.details.getCondensedInputs()) {
            if (part == null) continue;
            for (int x = 0; x < list.length; ++x) {
                IAEItemStack comparePart = list[x];
                if (!part.equals(comparePart)) continue;
                boolean isPartContainer = false;
                if (part.getItem().hasContainerItem(part.getDefinition())) {
                    part = list[x];
                    isPartContainer = true;
                }
                long wantedSize = part.getStackSize();
                if (AEConfig.instance().getEnableCraftingSubstitutes()) {
                    long requestAmount;
                    long remaining;
                    IAEItemStack found;
                    if (this.details.canSubstitute()) {
                        for (IAEItemStack subs : this.details.getSubstituteInputs(x)) {
                            found = this.job.checkAvailable(subs);
                            remaining = found != null ? found.getStackSize() : 0L;
                            if (remaining <= 0L) continue;
                            if (remaining >= wantedSize) {
                                requestAmount = wantedSize;
                                wantedSize = 0L;
                            } else {
                                requestAmount = remaining;
                                wantedSize -= remaining;
                            }
                            subs = (IAEItemStack)subs.copy().setStackSize(requestAmount);
                            CraftingTreeNode node = new CraftingTreeNode(this.cc, this.job, subs, this, x, this.depth + 1);
                            this.nodes.put((Object)node, requestAmount);
                            if (wantedSize != 0L) continue;
                            break;
                        }
                    } else {
                        found = this.job.checkAvailable(part);
                        remaining = found != null ? found.getStackSize() : 0L;
                        if (remaining > 0L) {
                            if (remaining >= wantedSize) {
                                requestAmount = wantedSize;
                                wantedSize = 0L;
                            } else {
                                requestAmount = remaining;
                                wantedSize -= remaining;
                            }
                            part = (IAEItemStack)part.copy().setStackSize(requestAmount);
                            this.nodes.put((Object)new CraftingTreeNode(this.cc, this.job, part, this, x, this.depth + 1), requestAmount);
                        }
                    }
                    if (wantedSize > 0L && this.details.canSubstitute() && this.cc.getCraftingFor(part, this.details, x, this.world).isEmpty()) {
                        ICraftingPatternDetails prioritizedPattern = null;
                        IAEItemStack prioritizedIAE = null;
                        for (IAEItemStack subs : this.details.getSubstituteInputs(x)) {
                            ImmutableCollection<ICraftingPatternDetails> detailCollection = this.cc.getCraftingFor(subs, this.details, x, this.world);
                            for (ICraftingPatternDetails sp : detailCollection) {
                                if (prioritizedPattern == null) {
                                    prioritizedPattern = sp;
                                    prioritizedIAE = subs;
                                    continue;
                                }
                                if (sp.getPriority() <= prioritizedPattern.getPriority()) continue;
                                prioritizedPattern = sp;
                            }
                            if (prioritizedIAE == null) continue;
                            subs = (IAEItemStack)subs.copy().setStackSize(wantedSize);
                            CraftingTreeNode node = new CraftingTreeNode(this.cc, this.job, subs, this, x, this.depth + 1);
                            this.nodes.put((Object)node, wantedSize);
                            wantedSize = 0L;
                            break;
                        }
                    }
                }
                if (wantedSize > 0L) {
                    part = (IAEItemStack)part.copy().setStackSize(wantedSize);
                    this.nodes.put((Object)new CraftingTreeNode(this.cc, this.job, part, this, x, this.depth + 1), wantedSize);
                    wantedSize = 0L;
                }
                if (!isPartContainer && wantedSize == 0L) continue block0;
            }
        }
    }

    boolean notRecursive(ICraftingPatternDetails details) {
        return this.parent == null || this.parent.notRecursive(details);
    }

    long getTimes(long remaining, long stackSize) {
        for (IAEItemStack part : this.details.getCondensedOutputs()) {
            for (IAEItemStack o : this.details.getCondensedInputs()) {
                if (!part.equals(o) && !o.getItem().hasContainerItem(part.getDefinition())) continue;
                return 1L;
            }
        }
        return remaining / stackSize + (long)(remaining % stackSize != 0L ? 1 : 0);
    }

    void request(MECraftingInventory inv, long amountOfTimes, IActionSource src) throws CraftBranchFailure, InterruptedException {
        IAEItemStack o;
        this.addProcess();
        this.job.handlePausing();
        ArrayList<IAEItemStack> containerItems = null;
        for (Map.Entry entry : this.nodes.object2LongEntrySet()) {
            ItemStack is;
            IAEItemStack stack = ((CraftingTreeNode)entry.getKey()).request(inv, (Long)entry.getValue() * amountOfTimes, src);
            if (!this.details.isCraftable() || !stack.getItem().hasContainerItem(stack.getDefinition()) || (o = AEItemStack.fromItemStack(is = Platform.getContainerItem(stack.createItemStack()))) == null) continue;
            if (containerItems == null) {
                containerItems = new ArrayList<IAEItemStack>();
            }
            ++this.bytes;
            o.setCachedItemStack(is);
            containerItems.add(o);
        }
        if (containerItems != null) {
            for (IAEItemStack i : containerItems) {
                inv.injectItems(i, Actionable.MODULATE, src);
            }
        }
        for (IAEItemStack out : this.details.getCondensedOutputs()) {
            o = out.copy();
            o.setStackSize(o.getStackSize() * amountOfTimes);
            inv.injectItems(o, Actionable.MODULATE, src);
        }
        this.crafts += amountOfTimes;
    }

    void dive(CraftingJob job) {
        job.addTask(this.getAmountCrafted(this.parent.getStack(1L)), this.crafts, this.details, this.depth);
        for (Map.Entry entry : this.nodes.object2LongEntrySet()) {
            ((CraftingTreeNode)entry.getKey()).dive(job);
        }
        job.addBytes(this.crafts * 8L + this.bytes);
    }

    IAEItemStack getAmountCrafted(IAEItemStack what2) {
        for (IAEItemStack is : this.details.getCondensedOutputs()) {
            if (!is.isSameType(what2)) continue;
            what2 = what2.copy();
            what2.setStackSize(is.getStackSize());
            return what2;
        }
        for (IAEItemStack is : this.details.getCondensedOutputs()) {
            if (is.getItem() != what2.getItem() || !is.getItem().func_77645_m() && is.getItemDamage() != what2.getItemDamage()) continue;
            what2 = is.copy();
            what2.setStackSize(is.getStackSize());
            return what2;
        }
        throw new IllegalStateException("Crafting Tree construction failed.");
    }

    void setSimulate() {
        this.crafts = 0L;
        this.bytes = 0L;
        for (Map.Entry entry : this.nodes.object2LongEntrySet()) {
            ((CraftingTreeNode)entry.getKey()).setSimulate();
        }
    }

    void setJob(MECraftingInventory storage, CraftingCPUCluster craftingCPUCluster, IActionSource src) throws CraftBranchFailure {
        craftingCPUCluster.addCrafting(this.details, this.crafts);
        for (Map.Entry entry : this.nodes.object2LongEntrySet()) {
            ((CraftingTreeNode)entry.getKey()).setJob(storage, craftingCPUCluster, src);
        }
    }

    void getPlan(IItemList<IAEItemStack> plan) {
        for (IAEItemStack i : this.details.getOutputs()) {
            i = i.copy();
            i.setCountRequestable(i.getStackSize() * this.crafts);
            plan.addRequestable(i);
        }
        for (Map.Entry entry : this.nodes.object2LongEntrySet()) {
            ((CraftingTreeNode)entry.getKey()).getPlan(plan);
        }
    }
}

