/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.renderers.blocks;

import com.infinityraider.agricraft.blocks.BlockPeripheral;
import com.infinityraider.agricraft.renderers.models.ModelPeripheralProbe;
import com.infinityraider.agricraft.tiles.TileEntityPeripheral;
import com.infinityraider.agricraft.tiles.analyzer.TileEntitySeedAnalyzer;
import com.infinityraider.agricraft.utility.IconHelper;
import com.infinityraider.infinitylib.block.BlockBase;
import com.infinityraider.infinitylib.block.tile.TileEntityBase;
import com.infinityraider.infinitylib.render.block.RenderBlockWithTileBase;
import com.infinityraider.infinitylib.render.model.ModelTechne;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RenderPeripheral
extends RenderBlockWithTileBase<BlockPeripheral, TileEntityPeripheral> {
    public static final ResourceLocation TEXTURE_TOP = new ResourceLocation("agricraft:blocks/peripheral_top");
    public static final ResourceLocation TEXTURE_SIDE = new ResourceLocation("agricraft:blocks/peripheral_side");
    public static final ResourceLocation TEXTURE_BOTTOM = new ResourceLocation("agricraft:blocks/peripheral_bottom");
    public static final ResourceLocation TEXTURE_INNER = new ResourceLocation("agricraft:blocks/peripheral_inner");
    public static final ResourceLocation TEXTURE_PROBE = new ResourceLocation("agricraft:blocks/peripheral_probe");
    private static final ModelTechne<ModelPeripheralProbe> MODEL_PERIPHERAL = new ModelTechne((ModelBase)new ModelPeripheralProbe()).setDiffuseLighting(false);
    private List<BakedQuad> probeQuads;

    public RenderPeripheral(BlockPeripheral block) {
        super((BlockBase)block, (TileEntityBase)new TileEntityPeripheral(), true, true, true);
    }

    public List<ResourceLocation> getAllTextures() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        list.add(TEXTURE_TOP);
        list.add(TEXTURE_SIDE);
        list.add(TEXTURE_BOTTOM);
        list.add(TEXTURE_INNER);
        list.add(TEXTURE_PROBE);
        return list;
    }

    public TextureAtlasSprite getIcon() {
        return IconHelper.getIcon(TEXTURE_PROBE.toString());
    }

    public boolean applyAmbientOcclusion() {
        return false;
    }

    public void renderWorldBlockStatic(ITessellator tessellator, IBlockState state, BlockPeripheral block, EnumFacing side) {
        this.renderChasis(tessellator);
        this.renderProbe(tessellator);
    }

    public void renderWorldBlockDynamic(ITessellator tessellator, World world, BlockPos pos, double x, double y, double z, BlockPeripheral block, TileEntityPeripheral tile, float partialTick, int destroyStage, float alpha) {
        tessellator.draw();
        this.renderSeed(tile, 0.0, 0.0, 0.0);
        tessellator.startDrawingQuads(DefaultVertexFormats.field_176600_a);
    }

    public void renderInventoryBlock(ITessellator tessellator, World world, IBlockState state, BlockPeripheral block, TileEntityPeripheral tile, ItemStack stack, EntityLivingBase entity, ItemCameraTransforms.TransformType type) {
        this.renderChasis(tessellator);
        this.renderProbe(tessellator);
    }

    private void renderChasis(ITessellator tessellator) {
        TextureAtlasSprite iconTop = RenderPeripheral.getIcon((ResourceLocation)TEXTURE_TOP);
        TextureAtlasSprite iconSide = RenderPeripheral.getIcon((ResourceLocation)TEXTURE_SIDE);
        TextureAtlasSprite iconBottom = RenderPeripheral.getIcon((ResourceLocation)TEXTURE_BOTTOM);
        TextureAtlasSprite iconInside = RenderPeripheral.getIcon((ResourceLocation)TEXTURE_INNER);
        tessellator.drawScaledFace(0.0f, 0.0f, 16.0f, 16.0f, EnumFacing.UP, iconTop, 16.0f);
        tessellator.drawScaledFace(0.0f, 0.0f, 16.0f, 16.0f, EnumFacing.DOWN, iconTop, 14.0f);
        tessellator.drawScaledFace(0.0f, 0.0f, 16.0f, 16.0f, EnumFacing.UP, iconInside, 2.0f);
        tessellator.drawScaledFace(0.0f, 0.0f, 16.0f, 16.0f, EnumFacing.DOWN, iconBottom, 0.0f);
        for (EnumFacing side : EnumFacing.field_176754_o) {
            tessellator.pushMatrix();
            RenderPeripheral.rotateBlock((ITessellator)tessellator, (EnumFacing)side);
            tessellator.drawScaledFace(0.0f, 0.0f, 16.0f, 16.0f, EnumFacing.NORTH, iconSide, 0.0f);
            tessellator.drawScaledFaceDouble(0.0f, 0.0f, 16.0f, 16.0f, EnumFacing.NORTH, iconInside, 4.0f);
            tessellator.popMatrix();
        }
    }

    private void renderProbe(ITessellator tessellator) {
        if (this.probeQuads == null) {
            this.probeQuads = MODEL_PERIPHERAL.getBakedQuads(tessellator.getVertexFormat(), RenderPeripheral.getIcon((ResourceLocation)TEXTURE_PROBE));
        }
        for (EnumFacing side : EnumFacing.field_176754_o) {
            tessellator.pushMatrix();
            RenderPeripheral.rotateBlock((ITessellator)tessellator, (EnumFacing)side);
            tessellator.addQuads(this.probeQuads);
            tessellator.popMatrix();
        }
    }

    private void renderSeed(TileEntitySeedAnalyzer te, double x, double y, double z) {
        if (te != null && te.hasSpecimen()) {
            GlStateManager.func_179123_a();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179101_C();
            RenderPeripheral.renderItemStack((ItemStack)te.getSpecimen(), (double)0.5, (double)0.5, (double)0.5, (double)0.75, (boolean)true);
            GlStateManager.func_179121_F();
            GlStateManager.func_179099_b();
        }
    }
}

