/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.blocks.irrigation;

import com.infinityraider.agricraft.api.v1.misc.IAgriConnectable;
import com.infinityraider.agricraft.api.v1.util.AgriSideMetaMatrix;
import com.infinityraider.agricraft.blocks.BlockCustomWood;
import com.infinityraider.agricraft.items.blocks.ItemBlockCustomWood;
import com.infinityraider.agricraft.reference.AgriCraftConfig;
import com.infinityraider.agricraft.renderers.blocks.RenderTank;
import com.infinityraider.agricraft.tiles.irrigation.TileEntityTank;
import com.infinityraider.infinitylib.utility.WorldHelper;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWaterTank
extends BlockCustomWood<TileEntityTank> {
    private final ItemBlockCustomWood itemBlock;

    public BlockWaterTank() {
        super("water_tank");
        this.func_149675_a(false);
        this.itemBlock = new ItemBlockCustomWood((Block)this);
    }

    public Optional<ItemBlockCustomWood> getItemBlock() {
        return Optional.of(this.itemBlock);
    }

    public TileEntityTank createNewTileEntity(World world, int meta) {
        return new TileEntityTank();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (World)world, (BlockPos)pos, (EnumFacing)side);
        ItemStack stack = player.func_184586_b(hand);
        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
        return fluid != null;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos, IAgriConnectable.class).ifPresent(IAgriConnectable::refreshConnections);
        WorldHelper.getTileNeighbors((World)world, (BlockPos)pos, IAgriConnectable.class).forEach(IAgriConnectable::refreshConnections);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos, IAgriConnectable.class).ifPresent(IAgriConnectable::refreshConnections);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        WorldHelper.getTileNeighbors((World)world, (BlockPos)pos, IAgriConnectable.class).forEach(IAgriConnectable::refreshConnections);
    }

    @SideOnly(value=Side.CLIENT)
    public RenderTank getRenderer() {
        return new RenderTank(this);
    }

    @Override
    protected void addUnlistedProperties(Consumer<IUnlistedProperty> consumer) {
        super.addUnlistedProperties(consumer);
        AgriSideMetaMatrix.addUnlistedProperties(consumer);
    }

    @Override
    protected IExtendedBlockState getExtendedCustomWoodState(IExtendedBlockState state, Optional<TileEntityTank> tile) {
        return tile.map(IAgriConnectable::getConnections).orElseGet(AgriSideMetaMatrix::new).writeToBlockState(state);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean isEnabled() {
        return AgriCraftConfig.enableIrrigation;
    }
}

