/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.networking.packets;

import com.gildedgames.the_aether.networking.packets.AetherPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class PacketSetTime
extends AetherPacket<PacketSetTime> {
    public float timeVariable;
    public int dimensionId;

    public PacketSetTime() {
    }

    public PacketSetTime(float timeVariable, int dimensionId) {
        this.dimensionId = dimensionId;
        this.timeVariable = timeVariable;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimensionId = buf.readInt();
        this.timeVariable = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimensionId);
        buf.writeFloat(this.timeVariable);
    }

    @Override
    public void handleClient(PacketSetTime message, EntityPlayer player) {
    }

    @Override
    public void handleServer(PacketSetTime message, EntityPlayer player) {
        message.setTime(message.timeVariable, message.dimensionId);
    }

    public void setTime(float sliderValue, int dimension) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        for (int i = 0; i < server.field_71305_c.length; ++i) {
            long shouldTime = (long)(24000.0f * sliderValue);
            long worldTime = server.field_71305_c[i].func_72912_H().func_76073_f();
            long remainder = worldTime % 24000L;
            long add = shouldTime > remainder ? shouldTime - remainder : shouldTime + 24000L - remainder;
            server.field_71305_c[i].func_72877_b(worldTime + add);
        }
    }
}

