/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.items.tools;

import com.gildedgames.the_aether.items.ItemsAether;
import com.gildedgames.the_aether.items.util.EnumAetherToolType;
import com.gildedgames.the_aether.registry.creative_tabs.AetherCreativeTabs;
import com.google.common.collect.ImmutableSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.NonNullList;

public abstract class ItemAetherTool
extends ItemTool {
    private static final float[] ATTACK_DAMAGES = new float[]{6.0f, 8.0f, 8.0f, 8.0f, 6.0f};
    private static final float[] ATTACK_SPEEDS = new float[]{-3.2f, -3.2f, -3.1f, -3.0f, -3.0f};
    private String toolClass;
    public Random random = new Random();
    public EnumAetherToolType toolType;

    public ItemAetherTool(Item.ToolMaterial toolMaterial, EnumAetherToolType toolType) {
        super(1.0f, 2.0f, toolMaterial, toolType.getToolBlockSet());
        this.toolType = toolType;
        if (toolType == EnumAetherToolType.PICKAXE) {
            this.toolClass = "pickaxe";
            this.field_77865_bY = 1.0f + toolMaterial.func_78000_c();
            this.field_185065_c = -2.8f;
        } else if (toolType == EnumAetherToolType.AXE) {
            this.toolClass = "axe";
            this.field_77865_bY = ATTACK_DAMAGES[toolMaterial.ordinal()];
            this.field_185065_c = ATTACK_SPEEDS[toolMaterial.ordinal()];
        } else if (toolType == EnumAetherToolType.SHOVEL) {
            this.toolClass = "shovel";
            this.field_77865_bY = 1.5f + toolMaterial.func_78000_c();
            this.field_185065_c = -3.0f;
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == AetherCreativeTabs.tools || tab == CreativeTabs.field_78027_g) {
            items.add((Object)new ItemStack((Item)this));
        }
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        if (blockState != null && blockState.func_177230_c().isToolEffective(this.toolClass, blockState)) {
            return this.field_77862_b.func_77996_d();
        }
        return super.getHarvestLevel(stack, toolClass, player, blockState);
    }

    public boolean func_150897_b(IBlockState block) {
        return this.toolType.canHarvestBlock(this.field_77862_b, block);
    }

    public float func_150893_a(ItemStack stack, IBlockState block) {
        for (String type : this.getToolClasses(stack)) {
            if (!block.func_177230_c().isToolEffective(type, block)) continue;
            return this.field_77864_a;
        }
        return this.toolType.getStrVsBlock(stack, block) == 4.0f ? this.field_77864_a : 1.0f;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return this.toolClass != null ? ImmutableSet.of((Object)this.toolClass) : super.getToolClasses(stack);
    }

    public float getEffectiveSpeed() {
        return this.field_77864_a;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, EntityLivingBase entity, EntityLivingBase attacker) {
        return stack.func_77973_b() == ItemsAether.skyroot_axe || stack.func_77973_b() == ItemsAether.holystone_axe || stack.func_77973_b() == ItemsAether.zanite_axe || stack.func_77973_b() == ItemsAether.gravitite_axe || stack.func_77973_b() == ItemsAether.valkyrie_axe;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return (stack.func_77973_b() == ItemsAether.skyroot_axe || stack.func_77973_b() == ItemsAether.holystone_axe || stack.func_77973_b() == ItemsAether.zanite_axe || stack.func_77973_b() == ItemsAether.gravitite_axe || stack.func_77973_b() == ItemsAether.valkyrie_axe) && EnchantmentHelper.func_82781_a((ItemStack)book).containsKey(Enchantments.field_185302_k) || super.isBookEnchantable(stack, book);
    }
}

