/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common.field.text;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wanion.lib.WanionLib;
import wanion.lib.client.gui.interaction.WInteraction;
import wanion.lib.common.INBTMessage;
import wanion.lib.common.field.IField;
import wanion.lib.network.SmartNBTMessage;

public class TextField
implements IField<TextField> {
    private final String fieldName;
    private String content;
    private EntityPlayer player;

    public TextField(@Nonnull String fieldName) {
        this(fieldName, "");
    }

    public TextField(@Nonnull String fieldName, @Nonnull String content) {
        this(fieldName, content, null);
    }

    public TextField(@Nonnull String fieldName, @Nonnull String content, EntityPlayer player) {
        this.fieldName = fieldName;
        this.content = content;
        this.player = player;
    }

    public synchronized int length() {
        return this.content.length();
    }

    @Nonnull
    public synchronized String getContent() {
        return this.content;
    }

    public synchronized void setContent(@Nonnull String content) {
        this.content = content;
    }

    public final synchronized void clear() {
        this.content = "";
    }

    public final synchronized boolean isEmpty() {
        return this.content.isEmpty();
    }

    @Override
    @Nonnull
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    @Nonnull
    public TextField copy() {
        return new TextField(this.fieldName, this.content, this.player);
    }

    @Override
    public boolean canInteractWith(@Nonnull EntityPlayer player) {
        return this.player == null || this.player == player || this.player.func_70005_c_().equals(player.func_70005_c_());
    }

    @Override
    public void startInteraction(@Nonnull EntityPlayer player) {
        this.player = player;
    }

    @Override
    public void endInteraction(@Nonnull EntityPlayer player) {
        if (player == this.player || player.equals((Object)this.player)) {
            this.player = null;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getHoveringText(@Nonnull WInteraction wInteraction) {
        EntityPlayer player = wInteraction.getEntityPlayer();
        return this.player != null && this.player != player ? I18n.func_135052_a((String)"wanionlib.field.occupied", (Object[])new Object[]{this.player.func_70005_c_()}) : null;
    }

    @Override
    @Nonnull
    public NBTTagCompound writeNBT() {
        NBTTagCompound fieldNBT = new NBTTagCompound();
        fieldNBT.func_74778_a("fieldName", this.fieldName);
        fieldNBT.func_74778_a("content", this.content);
        if (this.player != null) {
            fieldNBT.func_74778_a("player", this.player.func_70005_c_());
        }
        return fieldNBT;
    }

    @Override
    public void afterWriteNBT(@Nonnull NBTTagCompound smartNBT) {
        smartNBT.func_82580_o("player");
    }

    @Override
    public void readNBT(@Nonnull NBTTagCompound smartNBT) {
        this.setContent(smartNBT.func_74779_i("content"));
        this.player = smartNBT.func_74764_b("player") ? WanionLib.proxy.getPlayerByUsername(smartNBT.func_74779_i("player")) : null;
    }

    @Override
    public void receiveNBT(@Nonnull NBTTagCompound fieldUpdate) {
        String content;
        if (fieldUpdate.func_82582_d() || !this.fieldName.equals(fieldUpdate.func_74779_i("fieldName"))) {
            return;
        }
        EntityPlayerMP updatePlayer = WanionLib.proxy.getPlayerByUsername(fieldUpdate.func_74779_i("player"));
        boolean interacting = fieldUpdate.func_74767_n("interacting");
        if (this.player == null && interacting) {
            this.startInteraction((EntityPlayer)updatePlayer);
        } else if (this.player == updatePlayer && !interacting) {
            this.endInteraction((EntityPlayer)updatePlayer);
        }
        String string = content = fieldUpdate.func_74764_b("content") ? fieldUpdate.func_74779_i("content") : null;
        if (content != null) {
            this.setContent(content);
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof TextField && this.fieldName.equals(((TextField)obj).fieldName) && this.content.equals(((TextField)obj).content) && Objects.equals(this.player, ((TextField)obj).player);
    }

    @SideOnly(value=Side.CLIENT)
    public void sendUpdateToServer(int windowId) {
        NBTTagCompound smartNBT = new NBTTagCompound();
        NBTTagList fieldTagList = new NBTTagList();
        fieldTagList.func_74742_a((NBTBase)this.writeNBT());
        smartNBT.func_74782_a("field", (NBTBase)fieldTagList);
        WanionLib.networkWrapper.sendToServer((IMessage)new SmartNBTMessage(windowId, smartNBT));
    }

    public void sendTextFieldNBT(int windowId, @Nonnull EntityPlayer entityPlayer, boolean interacting) {
        this.sendTextFieldNBT(windowId, entityPlayer, interacting, null);
    }

    public void sendTextFieldNBT(int windowId, @Nonnull EntityPlayer entityPlayer, boolean interacting, String content) {
        if (WanionLib.proxy.isServer()) {
            return;
        }
        NBTTagCompound textFieldNBT = new NBTTagCompound();
        textFieldNBT.func_74778_a("fieldName", this.fieldName);
        textFieldNBT.func_74778_a("player", entityPlayer.func_70005_c_());
        textFieldNBT.func_74757_a("interacting", interacting);
        if (content != null) {
            textFieldNBT.func_74778_a("content", content);
        }
        INBTMessage.sendNBT(windowId, textFieldNBT);
    }

    public String toString() {
        return this.fieldName;
    }
}

