/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.config;

import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.bugfixes.blockoverlay.UTBlockOverlayLists;
import mod.acgaming.universaltweaks.tweaks.UTLoadSound;
import mod.acgaming.universaltweaks.util.UTObsoleteModsScreenHandler;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="universaltweaks", name="UniversalTweaks")
public class UTConfig {
    @Config.Name(value="Bugfixes")
    @Config.Comment(value={"Bugfixes Category"})
    public static BugfixesCategory bugfixes = new BugfixesCategory();
    @Config.Name(value="Debug")
    @Config.Comment(value={"Debug Category"})
    public static DebugCategory debug = new DebugCategory();
    @Config.Name(value="Mods")
    @Config.Comment(value={"Mods Category"})
    public static ModsCategory mods = new ModsCategory();
    @Config.Name(value="Tweaks")
    @Config.Comment(value={"Tweaks Category"})
    public static TweaksCategory tweaks = new TweaksCategory();

    @Mod.EventBusSubscriber(modid="universaltweaks")
    public static class EventHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("universaltweaks")) {
                ConfigManager.sync((String)"universaltweaks", (Config.Type)Config.Type.INSTANCE);
                if (UTConfig.bugfixes.utBlockOverlayToggle) {
                    UTBlockOverlayLists.initLists();
                }
                if (UTConfig.tweaks.utLoadSoundMode != 0) {
                    UTLoadSound.initLists();
                }
                UTObsoleteModsScreenHandler.shouldDisplay = true;
                UniversalTweaks.LOGGER.info("Universal Tweaks config reloaded");
            }
        }
    }

    public static class TweaksCategory {
        @Config.Name(value="AI Replacement")
        @Config.Comment(value={"Replaces entity AI for improved server performance"})
        public boolean utAIReplacementToggle = true;
        @Config.Name(value="AI Removal")
        @Config.Comment(value={"Removes entity AI for improved server performance"})
        public boolean utAIRemovalToggle = false;
        @Config.Name(value="Attributes Uncap")
        @Config.Comment(value={"Virtually uncaps entity attributes"})
        public boolean utAttributesToggle = true;
        @Config.Name(value="Auto Jump Replacement")
        @Config.Comment(value={"Replaces auto jump with an increased step height"})
        public boolean utAutoJumpToggle = true;
        @Config.Name(value="Auto Switch Tools")
        @Config.Comment(value={"Switches the selected hotbar slot to a proper tool if required"})
        public boolean utAutoSwitchToggle = false;
        @Config.Name(value="No Attack Cooldown")
        @Config.Comment(value={"Disables the 1.9 combat update attack cooldown"})
        public boolean utAttackCooldownToggle = false;
        @Config.Name(value="Bed Obstruction Replacement")
        @Config.Comment(value={"Replaces bed obstruction checks with an improved version"})
        public boolean utBedObstructionToggle = true;
        @Config.Name(value="Better Burning")
        @Config.Comment(value={"Fixes some edge cases where fire damage sources won't cause mobs to drop their cooked items", "Allows skeletons to shoot flaming arrows when on fire (70% chance)", "If entities have fire resistance, they get extinguished right away when on fire", "Allows fire to spread from entity to entity (30% chance)"})
        public boolean utBetterBurningToggle = true;
        @Config.Name(value="Better Harvest")
        @Config.Comment(value={"Prevents breaking lower parts of sugar cane and cacti as well as unripe crops, unless sneaking"})
        public boolean utBetterHarvestToggle = false;
        @Config.Name(value="Better Ignition")
        @Config.Comment(value={"Enables ignition of entities by right-clicking instead of awkwardly lighting the block under them"})
        public boolean utBetterIgnitionToggle = true;
        @Config.Name(value="Bow Infinity Remedy")
        @Config.Comment(value={"Bows enchanted with Infinity no longer require arrows"})
        public boolean utBowInfinityToggle = true;
        @Config.Name(value="Block Placement Click Delay")
        @Config.Comment(value={"Sets the delay in ticks between placing blocks"})
        public int utBPClickDelay = 4;
        @Config.Name(value="Cactus Size")
        @Config.Comment(value={"Determines how tall cacti can grow"})
        public int utCactusSize = 3;
        @Config.Name(value="Chunk Gen Limit")
        @Config.Comment(value={"Limits maximum chunk generation per tick for improved server performance"})
        public boolean utChunkGenLimitToggle = false;
        @Config.Name(value="Chunk Gen Limit Ticks")
        @Config.Comment(value={"Maximum chunks to generate per tick per dimension"})
        public int utChunkGenLimitTicks = 2;
        @Config.Name(value="Chunk Gen Limit Time")
        @Config.Comment(value={"Maximum time in ms to spend generating chunks per tick per dimension"})
        public int utChunkGenLimitTime = 5;
        @Config.Name(value="Creeper Confetti")
        @Config.Comment(value={"Replaces deadly creeper explosions with delightful confetti"})
        public boolean utCreeperConfettiToggle = false;
        @Config.Name(value="Damage Tilt")
        @Config.Comment(value={"Restores feature to tilt the camera when damaged"})
        public boolean utDamageTiltToggle = true;
        @Config.Name(value="Dimension Unload")
        @Config.Comment(value={"Unloads dimensions not in use to free up resources"})
        public boolean utUnloaderToggle = true;
        @Config.Name(value="Dimension Unload Interval")
        @Config.Comment(value={"Time (in ticks) to wait before checking dimensions"})
        public int utUnloaderInterval = 600;
        @Config.Name(value="Dimension Unload Blacklist")
        @Config.Comment(value={"List of dimensions which should not be unloaded", "Can be dimension name or ID", "Uses regular expressions"})
        public String[] utUnloaderBlacklist = new String[]{"0", "overworld"};
        @Config.Name(value="Disable Animated Models")
        @Config.Comment(value={"Improves model load times by removing Forge's animated models"})
        public boolean utDisableAnimatedModelsToggle = false;
        @Config.Name(value="Disable Audio Debug")
        @Config.Comment(value={"Improves loading times by removing debug code for missing sounds and subtitles"})
        public boolean utDisableAudioDebugToggle = true;
        @Config.Name(value="Easy Breeding")
        @Config.Comment(value={"Enables easy breeding of animals by tossing food on the ground"})
        public boolean utEasyBreedingToggle = false;
        @Config.Name(value="Easy Breeding Search Distance")
        @Config.Comment(value={"Determines the distance for animals to search for food"})
        public double utEasyBreedingDistance = 10.0;
        @Config.Name(value="Fast Dye Blending")
        @Config.Comment(value={"Replaces color lookup for sheep to check a predefined table rather than querying the recipe registry"})
        public boolean utDyeBlendingToggle = true;
        @Config.Name(value="Fast Leaf Decay")
        @Config.Comment(value={"Makes leaves decay faster when trees are chopped"})
        public boolean utLeafDecayToggle = true;
        @Config.Name(value="Fast Prefix Checking")
        @Config.Comment(value={"Optimizes Forge's ID prefix checking and removes prefix warnings impacting load time"})
        public boolean utPrefixCheckToggle = true;
        @Config.Name(value="Fence/Wall Jump")
        @Config.Comment(value={"Allows the player to jump over fences and walls"})
        public boolean utFenceWallJumpToggle = true;
        @Config.Name(value="Finite Water")
        @Config.Comment(value={"Prevents creation of infinite water sources outside of ocean and river biomes"})
        public boolean utFiniteWaterToggle = false;
        @Config.Name(value="Horizontal Collision Damage")
        @Config.Comment(value={"Applies horizontal collision damage to the player akin to elytra collision"})
        public boolean utCollisionDamageToggle = false;
        @Config.Name(value="Horizontal Collision Damage Factor")
        @Config.Comment(value={"The damage factor that gets multiplied with the player speed", "Vanilla default for elytra damage is 10"})
        public int utCollisionDamageFactor = 10;
        @Config.Name(value="Husk & Stray Spawning")
        @Config.Comment(value={"Lets husks and strays spawn underground like regular zombies and skeletons"})
        public boolean utHuskStraySpawningToggle = true;
        @Config.Name(value="Infinite Music")
        @Config.Comment(value={"Lets background music play continuously without delays"})
        public boolean utInfiniteMusicToggle = false;
        @Config.Name(value="Item Entity Combination")
        @Config.Comment(value={"Stops combination of item entities if their maximum stack size is reached"})
        public boolean utCombineItemEntityToggle = true;
        @Config.Name(value="Load Sounds Mode")
        @Config.RangeInt(min=0, max=3)
        @Config.Comment(value={"Play sound on...", "0 = Nothing", "1 = Minecraft load", "2 = World load", "3 = Minecraft and world load"})
        public int utLoadSoundMode = 0;
        @Config.Name(value="Load Sounds Minecraft")
        @Config.Comment(value={"Sounds to play when Minecraft is loaded", "Syntax: eventname;pitch"})
        public String[] utLoadSoundMC = new String[]{"entity.experience_orb.pickup;1.0", "entity.player.levelup;1.0"};
        @Config.Name(value="Load Sounds World")
        @Config.Comment(value={"Sounds to play when the world is loaded", "Syntax: eventname;pitch"})
        public String[] utLoadSoundWorld = new String[]{"entity.experience_orb.pickup;1.0", "entity.player.levelup;1.0"};
        @Config.Name(value="Mending Fix")
        @Config.Comment(value={"Only repairs damaged equipment with XP"})
        public boolean utMendingToggle = true;
        @Config.Name(value="Mending Fix Ratio")
        @Config.Comment(value={"Determines the amount of durability mending will repair, on average, per point of experience"})
        public float utMendingRatio = 2.0f;
        @Config.Name(value="Mending Fix Overpowered")
        @Config.Comment(value={"If mending fix is enabled, repairs entire damaged inventory with XP"})
        public boolean utMendingOPToggle = false;
        @Config.Name(value="Mob Despawn Improvement")
        @Config.Comment(value={"Mobs carrying picked up items will drop their equipment and despawn properly"})
        public boolean utMobDespawnToggle = true;
        @Config.Name(value="No Lightning Flash")
        @Config.Comment(value={"Disables the flashing of skybox and ground brightness on lightning strikes"})
        public boolean utLightningFlashToggle = false;
        @Config.Name(value="No Night Vision Flash")
        @Config.Comment(value={"Disables the flashing effect when the night vision potion effect is about to run out"})
        public boolean utNightVisionFlashToggle = false;
        @Config.Name(value="No Potion Shift")
        @Config.Comment(value={"Disables the inventory shift when potion effects are active"})
        public boolean utPotionShiftToggle = true;
        @Config.Name(value="No Redstone Lighting")
        @Config.Comment(value={"Disables lighting of active redstone, repeaters, and comparators to improve performance"})
        public boolean utRedstoneLightingToggle = false;
        @Config.Name(value="No Saddled Wandering")
        @Config.Comment(value={"Stops horses wandering around when saddled"})
        public boolean utSaddledWanderingToggle = true;
        @Config.Name(value="Offhand Improvement")
        @Config.Comment(value={"Prevents placing offhand blocks when blocks or food are held in the mainhand"})
        public boolean utOffhandToggle = true;
        @Config.Name(value="Player Fly Speed")
        @Config.Comment(value={"Determines the player's base fly speed"})
        public double utPlayerFlySpeed = 0.05;
        @Config.Name(value="Player Walk Speed")
        @Config.Comment(value={"Determines the player's base walk speed"})
        public double utPlayerWalkSpeed = 0.1;
        @Config.Name(value="Remove Realms Button")
        @Config.Comment(value={"Removes the redundant Minecraft Realms button from the main menu"})
        public boolean utRealmsButtonToggle = true;
        @Config.Name(value="Remove Recipe Book")
        @Config.Comment(value={"Removes the recipe book button from GUIs"})
        public boolean utRecipeBookToggle = false;
        @Config.Name(value="Smooth Scrolling")
        @Config.Comment(value={"Adds smooth scrolling to every in-game list"})
        public boolean utSmoothScrollingToggle = true;
        @Config.Name(value="Smooth Scrolling Bounce Back Multiplier")
        public double utSmoothScrollingBounce = 0.24;
        @Config.Name(value="Smooth Scrolling Scroll Duration")
        public int utSmoothScrollingDuration = 600;
        @Config.Name(value="Smooth Scrolling Scroll Step")
        public double utSmoothScrollingStep = 19.0;
        @Config.Name(value="Stronghold Replacement")
        @Config.Comment(value={"Replaces stronghold generation with a safer variant"})
        public boolean utStrongholdToggle = true;
        @Config.Name(value="Sugar Cane Size")
        @Config.Comment(value={"Determines how tall sugar cane can grow"})
        public int utSugarCaneSize = 3;
        @Config.Name(value="Super Hot Torch")
        @Config.Comment(value={"Enables one-time ignition of entities by hitting them with a torch"})
        public boolean utSuperHotTorchToggle = false;
        @Config.Name(value="Swing Through Grass")
        @Config.Comment(value={"Allows hitting entities through grass instead of breaking it"})
        public boolean utSwingThroughGrassToggle = true;
        @Config.Name(value="Tidy Chunk")
        @Config.Comment(value={"Tidies newly generated chunks by removing scattered item entities"})
        public boolean utTidyChunkToggle = false;
        @Config.Name(value="Toggle Cheats Button")
        @Config.Comment(value={"Adds a button to the pause menu to toggle cheats"})
        public boolean utToggleCheatsToggle = true;
        @Config.Name(value="Uncap FPS")
        @Config.Comment(value={"Removes the hardcoded 30 FPS limit in screens like the main menu"})
        public boolean utUncapFPSToggle = true;
        @Config.Name(value="Water Fall Damage")
        @Config.Comment(value={"Re-implements an improved version of pre-1.4 fall damage in water"})
        public boolean utFallDamageToggle = false;
        @Config.Name(value="Water Fall Damage Reduction")
        @Config.Comment(value={"How much fall damage gets reduced by water per tick"})
        public float utFallDamageValue = 2.0f;
    }

    public static class ModsCategory {
        @Config.Name(value="[Biomes O' Plenty] Hot Spring Water")
        @Config.Comment(value={"Fixes rapid inflection of regeneration effects in hot spring water"})
        public boolean utBoPHotSpringWaterToggle = true;
        @Config.Name(value="[Epic Siege Mod] Disable Digger AI Debug")
        @Config.Comment(value={"Disables leftover debug logging inside the digger AI of the beta builds"})
        public boolean utESMDiggerDebugToggle = true;
        @Config.Name(value="[Storage Drawers] Render Range")
        @Config.Comment(value={"Approximate range in blocks at which drawers render contained items", "0 for default unlimited range"})
        public int utSDRenderRange = 0;
        @Config.Name(value="[Thaumcraft] Firebat Particles")
        @Config.Comment(value={"Adds particles to firebats similar to legacy versions"})
        public boolean utTCFirebatParticlesToggle = true;
        @Config.Name(value="[Thaumcraft] Stable Thaumometer")
        @Config.Comment(value={"Stops the thaumometer from bobbing rapidly when using it to scan objects"})
        public boolean utTCStableThaumometerToggle = true;
        @Config.Name(value="[Thaumcraft] Wisp Particles")
        @Config.Comment(value={"Increases particle size of wisps similar to legacy versions"})
        public boolean utTCWispParticlesToggle = true;
        @Config.Name(value="[Tinkers' Construct] Gaseous Fluids")
        @Config.Comment(value={"Excludes gaseous fluids from being transferable via faucets"})
        public boolean utTConGaseousFluidsToggle = false;
        @Config.Name(value="[Tinkers' Construct] Projectile Despawning")
        @Config.Comment(value={"Despawns unbreakable projectiles faster to improve framerates"})
        public boolean utTConProjectileToggle = true;
        @Config.Name(value="[Tinkers' Construct] Offhand Shuriken")
        @Config.Comment(value={"Suppresses special abilities of long swords and rapiers when shurikens are wielded in the offhand"})
        public boolean utTConShurikenToggle = true;
        @Config.Name(value="[Mo' Creatures] Custom Modded Biomes")
        @Config.Comment(value={"Adds support for modded biome spawns", "Syntax: modid;name;key;tag;filename", "modid    Mod ID required for this to be added", "name     Mod name", "key      Used for class lookups, needs to be a unique part of the modded package, e.g. mod.acgaming.*universaltweaks*.mods", "tag      Short tag for logs", "filename Filename to use for the generated config"})
        public String[] utMoCBiomeMods = new String[]{"pvj;vibrantjourneys;vibrantjourneys;PVJ;ProjectVibrantJourneys.cfg", "traverse;traverse;traverse;TRAV;Traverse.cfg", "dimdoors;dimdoors;dimdoors;DD;DimDoors.cfg"};
    }

    public static class DebugCategory {
        @Config.Name(value="Debug Logging")
        @Config.Comment(value={"Enables debug logging"})
        public boolean utDebugToggle = false;
        @Config.Name(value="Obsolete Mods Screen")
        @Config.Comment(value={"Enables a screen displaying incompatible mods on game load"})
        public boolean utObsoleteModsToggle = true;
        @Config.Name(value="Bypass Incompatibility Warnings")
        @Config.Comment(value={"For those who live life on the edge, may or may not include Jons"})
        public boolean utBypassIncompatibilityToggle = false;
        @Config.Name(value="Show Loading Time")
        @Config.Comment(value={"Prints the time the game needed to launch to the log"})
        public boolean utLoadingTimeToggle = true;
    }

    public static class BugfixesCategory {
        @Config.Name(value="Block Fire Fix")
        @Config.Comment(value={"Prevents fire projectiles burning entities when blocking with shields"})
        public boolean utBlockFireToggle = true;
        @Config.Name(value="Block Overlay Fix")
        @Config.Comment(value={"Fixes x-ray when standing in non-suffocating blocks"})
        public boolean utBlockOverlayToggle = true;
        @Config.Name(value="Block Overlay Fix Blacklist")
        @Config.Comment(value={"Excludes blocks from the block overlay fix", "Syntax: modid:block"})
        public String[] utBlockOverlayBlacklist = new String[0];
        @Config.Name(value="Block Overlay Fix Whitelist")
        @Config.Comment(value={"Includes blocks in the block overlay fix", "Syntax: modid:block"})
        public String[] utBlockOverlayWhitelist = new String[0];
        @Config.Name(value="Boat Riding Offset Fix")
        @Config.Comment(value={"Fixes entities glitching through the bottom of boats"})
        public boolean utBoatOffsetToggle = true;
        @Config.Name(value="Comparator Timing Fix")
        @Config.Comment(value={"Fixes inconsistent delays of comparators to prevent redstone timing issues"})
        public boolean utComparatorTimingToggle = true;
        @Config.Name(value="Death Time Fix")
        @Config.Comment(value={"Fixes corrupted entities exceeding the allowed death time"})
        public boolean utDeathTimeToggle = true;
        @Config.Name(value="Destroy Entity Packets Fix")
        @Config.Comment(value={"Fixes lag caused by dead entities by sending additional packets when the player is not alive"})
        public boolean utDestroyPacketToggle = true;
        @Config.Name(value="Disconnect Dupe Fix")
        @Config.Comment(value={"Fixes item dupes when players are dropping items and disconnecting"})
        public boolean utDisconnectDupeToggle = true;
        @Config.Name(value="Hopper Bounding Box Fix")
        @Config.Comment(value={"Slims down the hopper bounding box for easier access of nearby blocks"})
        public boolean utDietHopperToggle = true;
        @Config.Name(value="Dimension Change Player States Fix")
        @Config.Comment(value={"Fixes missing player states when changing dimensions by sending additional packets"})
        public boolean utDimensionChangeToggle = true;
        @Config.Name(value="Entity Bounding Box Fix")
        @Config.Comment(value={"Saves entity bounding boxes to tags to prevent breakouts and suffocation"})
        public boolean utEntityAABBToggle = true;
        @Config.Name(value="Entity Desync Fix")
        @Config.Comment(value={"Fixes entity motion desyncs most notable with arrows and thrown items"})
        public boolean utEntityDesyncToggle = true;
        @Config.Name(value="Entity NaN Fix")
        @Config.Comment(value={"Prevents corruption of entities caused by invalid health or damage values"})
        public boolean utEntityNaNToggle = true;
        @Config.Name(value="Entity Suffocation Fix")
        @Config.Comment(value={"Pushes entities out of blocks when growing up to prevent suffocation"})
        public boolean utEntitySuffocationToggle = true;
        @Config.Name(value="Entity Tracker Fix")
        @Config.Comment(value={"Fixes entity tracker to prevent client-sided desyncs when teleporting or changing dimensions"})
        public boolean utEntityTrackerToggle = true;
        @Config.Name(value="Entity UUID Fix")
        @Config.Comment(value={"Changes UUIDs of loaded entities in case their UUIDs are already assigned (and removes log spam)"})
        public boolean utEntityUUIDToggle = true;
        @Config.Name(value="Exhaustion Fix")
        @Config.Comment(value={"Fixes saturation depleting in peaceful mode"})
        public boolean utExhaustionToggle = true;
        @Config.Name(value="Frustum Culling Fix")
        @Config.Comment(value={"Fixes invisible chunks in edge cases (small enclosed rooms at chunk borders)"})
        public boolean utFrustumCullingToggle = true;
        @Config.Name(value="Help Fix")
        @Config.Comment(value={"Replaces the help command, sorts and reports broken commands"})
        public boolean utHelpToggle = true;
        @Config.Name(value="Item Frame Void Fix")
        @Config.Comment(value={"Prevents voiding held items when right + left clicking on an item frame simultaneously"})
        public boolean utItemFrameVoidToggle = true;
        @Config.Name(value="Ladder Flying Slowdown Fix")
        @Config.Comment(value={"Disables climbing movement when flying"})
        public boolean utLadderFlyingToggle = true;
        @Config.Name(value="Locale Fix")
        @Config.Comment(value={"Prevents various crashes with Turkish locale"})
        public boolean utLocaleToggle = true;
        @Config.Name(value="Max Health Fix")
        @Config.Comment(value={"Saves increased player health to tags"})
        public boolean utMaxHealthToggle = true;
        @Config.Name(value="Mining Glitch Fix")
        @Config.Comment(value={"Avoids the need for multiple mining attempts by sending additional movement packets"})
        public boolean utMiningGlitchToggle = true;
        @Config.Name(value="Piston Progress Fix")
        @Config.Comment(value={"Properly saves the last state of pistons to tags"})
        public boolean utPistonTileToggle = true;
        @Config.Name(value="Skeleton Aim Fix")
        @Config.Comment(value={"Fixes skeletons not looking at their targets when strafing"})
        public boolean utSkeletonAimToggle = true;
        @Config.Name(value="Tile Entity Update Order Fix")
        @Config.Comment(value={"Keeps the order of tile entities on chunk load"})
        public boolean utTELoadOrderToggle = true;
        @Config.Name(value="Villager Mantle Fix")
        @Config.Comment(value={"Returns missing hoods to villager mantles"})
        public boolean utVillagerMantleToggle = true;
    }
}

