/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.events;

import com.bloodnbonesgaming.triumph.advancements.RepeatableHandler;
import com.bloodnbonesgaming.triumph.advancements.criterion.CountHandler;
import com.bloodnbonesgaming.triumph.advancements.criterion.trigger.CompletedAdvancementTrigger;
import com.bloodnbonesgaming.triumph.advancements.criterion.trigger.CustomCriteriaTriggers;
import com.bloodnbonesgaming.triumph.events.InventoryUpdateListener;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class TEventHandler {
    private int tickCounter = 0;
    private InventoryUpdateListener listener = new InventoryUpdateListener();

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
    }

    @SubscribeEvent
    public void onCraftItem(PlayerEvent.ItemCraftedEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && !(event.player instanceof FakePlayer)) {
            CustomCriteriaTriggers.CRAFT_ITEM.trigger((EntityPlayerMP)event.player, event.crafting);
        }
    }

    @SubscribeEvent
    public void onPlayerBlockBreak(BlockEvent.BreakEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K && !(event.getPlayer() instanceof FakePlayer)) {
            if (event.getState().func_177230_c().canHarvestBlock((IBlockAccess)event.getWorld(), event.getPos(), event.getPlayer())) {
                CustomCriteriaTriggers.HARVEST_BLOCK.trigger((EntityPlayerMP)event.getPlayer(), event.getPos(), event.getPlayer().func_184614_ca());
            } else {
                CustomCriteriaTriggers.DESTROY_BLOCK.trigger((EntityPlayerMP)event.getPlayer(), event.getPos(), event.getPlayer().func_184614_ca());
            }
            CustomCriteriaTriggers.BREAK_BLOCK.trigger((EntityPlayerMP)event.getPlayer(), event.getPos(), event.getPlayer().func_184614_ca());
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player instanceof EntityPlayerMP) {
            PlayerAdvancements playerAdvancements;
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            AdvancementManager manager = FMLCommonHandler.instance().getMinecraftServerInstance().func_184102_h().func_191949_aK();
            for (Advancement advancement : manager.func_192780_b()) {
                playerAdvancements = player.func_192039_O();
                for (Map.Entry criteria : advancement.func_192073_f().entrySet()) {
                    Advancement triggerAdvancement;
                    if (!(((Criterion)criteria.getValue()).func_192143_a() instanceof CompletedAdvancementTrigger.Instance)) continue;
                    CompletedAdvancementTrigger.Instance trigger = (CompletedAdvancementTrigger.Instance)((Criterion)criteria.getValue()).func_192143_a();
                    if (trigger.advancement == null || (triggerAdvancement = manager.func_192778_a(new ResourceLocation(trigger.advancement))) == null || !playerAdvancements.func_192747_a(triggerAdvancement).func_192105_a()) continue;
                    playerAdvancements.func_192750_a(advancement, (String)criteria.getKey());
                }
            }
            for (Advancement advancement : manager.func_192780_b()) {
                playerAdvancements = player.func_192039_O();
                boolean flag = playerAdvancements.func_192738_c(advancement);
                boolean flag1 = playerAdvancements.field_192759_g.contains(advancement);
                if (flag && !flag1) {
                    playerAdvancements.field_192759_g.add(advancement);
                    playerAdvancements.field_192760_h.add(advancement);
                    continue;
                }
                if (flag || !flag1) continue;
                playerAdvancements.field_192759_g.remove(advancement);
                playerAdvancements.field_192760_h.add(advancement);
            }
        }
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (!event.getWorld().field_72995_K && !(event.getEntityPlayer() instanceof FakePlayer)) {
            CustomCriteriaTriggers.LEFT_CLICK_BLOCK.trigger((EntityPlayerMP)event.getEntityPlayer(), event.getPos(), event.getItemStack(), event.getFace(), event.getHitVec());
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getWorld().field_72995_K && !(event.getEntityPlayer() instanceof FakePlayer) && event.getHand() == EnumHand.MAIN_HAND) {
            CustomCriteriaTriggers.RIGHT_CLICK_BLOCK.trigger((EntityPlayerMP)event.getEntityPlayer(), event.getPos(), event.getItemStack(), event.getFace(), event.getHitVec());
            CustomCriteriaTriggers.RIGHT_CLICK_ITEM.trigger((EntityPlayerMP)event.getEntityPlayer(), event.getPos(), event.getItemStack());
        }
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (!event.getWorld().field_72995_K && !(event.getEntityPlayer() instanceof FakePlayer)) {
            CustomCriteriaTriggers.RIGHT_CLICK_ITEM.trigger((EntityPlayerMP)event.getEntityPlayer(), event.getPos(), event.getItemStack());
        }
    }

    @SubscribeEvent
    public void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        if (!event.getWorld().field_72995_K && !(event.getEntityPlayer() instanceof FakePlayer)) {
            CustomCriteriaTriggers.RIGHT_CLICK_ITEM.trigger((EntityPlayerMP)event.getEntityPlayer(), event.getPos(), event.getItemStack());
        }
    }

    @SubscribeEvent
    public void onPlayerSave(PlayerEvent.SaveToFile event) {
        if (!event.getEntity().field_70170_p.field_72995_K) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
            CountHandler.savePlayer(player.func_184102_h(), player.func_110124_au().toString());
        }
    }

    @SubscribeEvent
    public void onPlayerLoad(PlayerEvent.LoadFromFile event) {
        if (!event.getEntity().field_70170_p.field_72995_K) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
            CountHandler.loadPlayer(player.func_184102_h(), player.func_110124_au().toString());
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ++this.tickCounter;
            if (this.tickCounter % 20 == 5) {
                RepeatableHandler.tick();
            }
        }
    }

    @SubscribeEvent
    public void onAdvancementCompleted(AdvancementEvent event) {
        if (!event.getEntityPlayer().field_70170_p.field_72995_K) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
            AdvancementManager manager = FMLCommonHandler.instance().getMinecraftServerInstance().func_184102_h().func_191949_aK();
            for (Advancement advancement : manager.func_192780_b()) {
                PlayerAdvancements playerAdvancements = player.func_192039_O();
                boolean flag = playerAdvancements.func_192738_c(advancement);
                boolean flag1 = playerAdvancements.field_192759_g.contains(advancement);
                if (flag && !flag1) {
                    playerAdvancements.field_192759_g.add(advancement);
                    playerAdvancements.field_192760_h.add(advancement);
                    continue;
                }
                if (flag || !flag1) continue;
                playerAdvancements.field_192759_g.remove(advancement);
                playerAdvancements.field_192760_h.add(advancement);
            }
            RepeatableHandler.advancementCompleted((EntityPlayerMP)event.getEntityPlayer(), event.getAdvancement());
        }
    }

    @SubscribeEvent
    public void onInventoryOpen(PlayerContainerEvent.Open event) {
        event.getContainer().func_75132_a((IContainerListener)this.listener);
    }

    @SubscribeEvent
    public void onInventoryClose(PlayerContainerEvent.Close event) {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDeath(LivingDeathEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof EntityPlayerMP && !event.isCanceled() && !(event.getEntityLiving() instanceof FakePlayer)) {
            CustomCriteriaTriggers.PLAYER_DEATH.trigger((EntityPlayerMP)event.getEntityLiving(), event.getSource());
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.field_70170_p.field_72995_K && event.player instanceof EntityPlayerMP && !(event.player instanceof FakePlayer)) {
            CustomCriteriaTriggers.TICK.trigger((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        CustomCriteriaTriggers.DIMENSION_CHANGE.trigger((EntityPlayerMP)event.player, event.fromDim, event.toDim);
    }
}

