/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.criterion.data;

import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.CriterionTriggerData;
import com.bloodnbonesgaming.triumph.config.data.DistanceData;
import com.bloodnbonesgaming.triumph.config.data.MinMaxBoundsData;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.critereon.LevitationTrigger;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/criteria/triggers/minecraft/levitation", classExplaination="These are the functions which can be called on a minecraft:levitation criteria trigger.")
public class LevitationTriggerData
extends CriterionTriggerData {
    private MinMaxBoundsData duration = new MinMaxBoundsData();
    private final DistanceData distance = new DistanceData();

    public LevitationTriggerData(String criterionName, String advancementName) {
        super(criterionName, advancementName);
    }

    @Override
    public Criterion buildCriterion() {
        return new Criterion((ICriterionInstance)new LevitationTrigger.Instance(this.distance.buildDistancePredicate(), this.duration.buildBounds()));
    }

    @ScriptMethodDocumentation(args="float, float", usage="min, max", notes="Sets the min and max duration.")
    public void setDurationMinMax(float min, float max) {
        this.duration.setMinMax(min, max);
    }

    @ScriptMethodDocumentation(args="float", usage="min", notes="Sets the min duration.")
    public void setDurationMin(float min) {
        this.duration.setMin(min);
    }

    @ScriptMethodDocumentation(args="float", usage="max", notes="Sets the max duration.")
    public void setDurationMax(float max) {
        this.duration.setMax(max);
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the DistanceData object so functions can be called on it.")
    public DistanceData getDistanceData() {
        return this.distance;
    }
}

