/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.world;

import java.util.HashMap;
import java.util.Set;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeProvider;

public final class WorldDataCache {
    private static boolean init = false;
    private static final HashMap<Integer, WorldData> PROVIDERS = new HashMap();

    private WorldDataCache() {
    }

    public static void addOrUpdateData(World world) {
        PROVIDERS.put(world.field_73011_w.getDimension(), new WorldData(world.field_73011_w));
    }

    public static WorldData getData(int dim) {
        return PROVIDERS.get(dim);
    }

    public static Set<Integer> listAllDimensions() {
        return PROVIDERS.keySet();
    }

    public static void setInitialized() {
        init = true;
    }

    public static boolean isInitialized() {
        return init;
    }

    public static class WorldData {
        private int id;
        private long seed;
        private BiomeProvider biome;
        private double factor;

        public WorldData(WorldProvider provider) {
            this(provider.getDimension(), provider.getSeed(), provider.func_177499_m(), provider.getMovementFactor());
        }

        public WorldData(int dimID, long worldSeed, BiomeProvider biomeProvider, double moveFactor) {
            this.id = dimID;
            this.seed = worldSeed;
            this.biome = biomeProvider;
            this.factor = moveFactor;
        }

        public int getDimensionID() {
            return this.id;
        }

        public long getWorldSeed() {
            return this.seed;
        }

        public BiomeProvider getBiomeProvider() {
            return this.biome;
        }

        public double getMovementFactor() {
            return this.factor;
        }
    }
}

