/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;
import thaumcraft.common.lib.SoundsTC;
import thecodex6824.thaumicaugmentation.api.TABlocks;
import thecodex6824.thaumicaugmentation.api.TAMaterials;
import thecodex6824.thaumicaugmentation.api.aspect.AspectUtil;
import thecodex6824.thaumicaugmentation.api.block.property.IDirectionalBlock;
import thecodex6824.thaumicaugmentation.api.block.property.ITAStoneType;
import thecodex6824.thaumicaugmentation.common.block.prefab.BlockTABase;
import thecodex6824.thaumicaugmentation.common.block.trait.IItemBlockProvider;
import thecodex6824.thaumicaugmentation.common.block.trait.IStoredBlockstate;

public class BlockStrangeCrystal
extends BlockTABase
implements IDirectionalBlock,
IItemBlockProvider {
    protected static final AxisAlignedBB DOWN_BOX = new AxisAlignedBB(0.125, 0.25, 0.125, 0.875, 1.0, 0.875);
    protected static final AxisAlignedBB EAST_BOX = new AxisAlignedBB(0.0, 0.125, 0.125, 0.75, 0.875, 0.875);
    protected static final AxisAlignedBB NORTH_BOX = new AxisAlignedBB(0.125, 0.125, 0.25, 0.875, 0.875, 1.0);
    protected static final AxisAlignedBB SOUTH_BOX = new AxisAlignedBB(0.125, 0.125, 0.0, 0.875, 0.875, 0.75);
    protected static final AxisAlignedBB UP_BOX = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.75, 0.875);
    protected static final AxisAlignedBB WEST_BOX = new AxisAlignedBB(0.25, 0.125, 0.125, 1.0, 0.875, 0.875);

    public BlockStrangeCrystal() {
        super(Material.field_151592_s);
        this.func_149711_c(0.25f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)IDirectionalBlock.DIRECTION, (Comparable)EnumFacing.UP));
    }

    @Override
    public ItemBlock createItemBlock() {
        return new ItemBlock(this){

            public IRarity getForgeRarity(ItemStack stack) {
                return TAMaterials.RARITY_ARCANE;
            }
        };
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{IDirectionalBlock.DIRECTION}).add(new IUnlistedProperty[]{IStoredBlockstate.BLOCKSTATE}).build();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)IDirectionalBlock.DIRECTION, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)).func_176745_a();
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        BlockPos check = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)).func_176734_d());
        IBlockState toStore = world.func_180495_p(check);
        return ((IExtendedBlockState)state).withProperty(IStoredBlockstate.BLOCKSTATE, (Object)(toStore.func_177230_c().isAir(toStore, world, check) ? TABlocks.STONE.func_176223_P().func_177226_a(ITAStoneType.STONE_TYPE, (Comparable)((Object)ITAStoneType.StoneType.STONE_CRUSTED)) : toStore));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)IDirectionalBlock.DIRECTION, (Comparable)facing);
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        BlockPos test = pos.func_177972_a(side.func_176734_d());
        return world.func_180495_p(test).isSideSolid((IBlockAccess)world, test, side);
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)) {
            case DOWN: {
                return DOWN_BOX;
            }
            case EAST: {
                return EAST_BOX;
            }
            case NORTH: {
                return NORTH_BOX;
            }
            case SOUTH: {
                return SOUTH_BOX;
            }
            case WEST: {
                return WEST_BOX;
            }
        }
        return UP_BOX;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)IDirectionalBlock.DIRECTION, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)));
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 15;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 0;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return SoundsTC.CRYSTAL;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        for (int i = 0; i < rand.nextInt(3) + (fortune > 0 ? rand.nextInt(fortune) : 0) + 1; ++i) {
            drops.add((Object)ThaumcraftApiHelper.makeCrystal((Aspect)AspectUtil.getRandomAspect(rand)));
        }
        int special = 50;
        if (fortune > 0) {
            special /= fortune;
        }
        if (rand.nextInt(Math.max(special, 1)) == 0) {
            drops.add((Object)new ItemStack(ItemsTC.curio, 1, 0));
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing dir = ((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)).func_176734_d();
        if (!world.func_180495_p(pos.func_177972_a(dir)).isSideSolid((IBlockAccess)world, pos.func_177972_a(dir), dir.func_176734_d())) {
            world.func_175698_g(pos);
            this.func_176226_b(world, pos, state, 0);
        } else if (fromPos.equals((Object)pos.func_177972_a(dir))) {
            world.func_175704_b(pos, pos);
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        FXGeneric fx = new FXGeneric(world, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + rand.nextFloat()), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0);
        fx.func_187114_a(40 + rand.nextInt(21));
        fx.func_70538_b(0.8f, 0.8f, 0.8f);
        fx.setAlphaF(new float[]{0.0f, 0.6f, 0.6f, 0.0f});
        fx.setGridSize(64);
        fx.setParticles(512, 16, 1);
        fx.setScale(new float[]{1.0f, 0.5f});
        fx.setLoop(true);
        fx.setNoClip(false);
        fx.setWind(0.001);
        fx.setGravity(0.03f);
        fx.setRandomMovementScale(0.0025f, 0.0f, 0.0025f);
        ParticleEngine.addEffect((World)world, (Particle)fx);
    }
}

