/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.client.gui;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.concurrent.ExecutionException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.init.Biomes;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.client.lib.UtilsFX;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.item.CapabilityBiomeSelector;
import thecodex6824.thaumicaugmentation.api.item.IBiomeSelector;
import thecodex6824.thaumicaugmentation.client.gui.component.ButtonSpinner;
import thecodex6824.thaumicaugmentation.common.container.ContainerArcaneTerraformer;
import thecodex6824.thaumicaugmentation.common.network.PacketInteractGUI;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;
import thecodex6824.thaumicaugmentation.common.tile.TileArcaneTerraformer;
import thecodex6824.thaumicaugmentation.common.world.biome.BiomeUtil;

public class GUIArcaneTerraformer
extends GuiContainer {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("thaumicaugmentation", "textures/gui/arcane_terraformer.png");
    protected static final Cache<ItemStack, Object2IntAVLTreeMap<Aspect>> COSTS = CacheBuilder.newBuilder().maximumSize(25L).concurrencyLevel(1).build();
    protected boolean buttonsDisabled;

    public GUIArcaneTerraformer(ContainerArcaneTerraformer c) {
        super((Container)c);
        this.field_147000_g = 176;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        final ContainerArcaneTerraformer c = (ContainerArcaneTerraformer)this.field_147002_h;
        this.field_146292_n.add(new ButtonSpinner(0, this.field_147003_i + this.field_146999_f - 64, (this.field_146295_m - this.field_147000_g) / 2 + 27, 48){

            @Override
            public String getLabel() {
                return new TextComponentTranslation("thaumicaugmentation.text.terraformer_radius", new Object[0]).func_150254_d();
            }

            @Override
            public String getDisplayedValue() {
                return Integer.toString(c.getTile().getRadius());
            }

            @Override
            public void onDecrement() {
                c.getTile().setRadius(c.getTile().getRadius() - 1);
                this.sync();
                COSTS.invalidateAll();
            }

            @Override
            public void onIncrement() {
                c.getTile().setRadius(c.getTile().getRadius() + 1);
                this.sync();
                COSTS.invalidateAll();
            }

            protected void sync() {
                TANetwork.INSTANCE.sendToServer((IMessage)new PacketInteractGUI(this.field_146127_k, c.getTile().getRadius()));
            }
        });
        this.field_146292_n.add(new ButtonSpinner(1, this.field_147003_i + this.field_146999_f - 64, (this.field_146295_m - this.field_147000_g) / 2 + 57, 48){

            @Override
            public String getLabel() {
                return new TextComponentTranslation("thaumicaugmentation.text.terraformer_circle_mode", new Object[0]).func_150254_d();
            }

            @Override
            public String getDisplayedValue() {
                return c.getTile().isCircle() ? new TextComponentTranslation("thaumicaugmentation.text.terraformer_circle", new Object[0]).func_150254_d() : new TextComponentTranslation("thaumicaugmentation.text.terraformer_square", new Object[0]).func_150254_d();
            }

            @Override
            public void onDecrement() {
                c.getTile().setCircle(!c.getTile().isCircle());
                this.sync();
                COSTS.invalidateAll();
            }

            @Override
            public void onIncrement() {
                c.getTile().setCircle(!c.getTile().isCircle());
                this.sync();
                COSTS.invalidateAll();
            }

            protected void sync() {
                TANetwork.INSTANCE.sendToServer((IMessage)new PacketInteractGUI(this.field_146127_k, c.getTile().isCircle() ? 1 : 0));
            }
        });
    }

    public void func_73876_c() {
        ContainerArcaneTerraformer c = (ContainerArcaneTerraformer)this.field_147002_h;
        if (c.getTile().isRunning() != this.buttonsDisabled) {
            this.buttonsDisabled = c.getTile().isRunning();
            for (GuiButton button : this.field_146292_n) {
                button.field_146124_l = !this.buttonsDisabled;
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int width = (this.field_146294_l - this.field_146999_f) / 2;
        int height = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(width, height, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        ItemStack stack;
        IBiomeSelector selected;
        RenderHelper.func_74518_a();
        ContainerArcaneTerraformer container = (ContainerArcaneTerraformer)this.field_147002_h;
        TileArcaneTerraformer tile = container.getTile();
        if (container.func_75139_a(0).func_75216_d() && (selected = (IBiomeSelector)(stack = this.field_147002_h.func_75139_a(0).func_75211_c()).getCapability(CapabilityBiomeSelector.BIOME_SELECTOR, null)) != null && !selected.getBiomeID().equals((Object)IBiomeSelector.EMPTY)) {
            Object2IntAVLTreeMap costs = null;
            try {
                costs = (Object2IntAVLTreeMap)COSTS.get((Object)stack, () -> {
                    boolean reset = selected.getBiomeID().equals((Object)IBiomeSelector.RESET);
                    Biome changeTo = reset ? BiomeUtil.getNaturalBiome(tile.func_145831_w(), tile.func_174877_v(), Biomes.field_76772_c) : (Biome)Biome.field_185377_q.func_82594_a((Object)selected.getBiomeID());
                    Object2IntAVLTreeMap map = new Object2IntAVLTreeMap((a1, a2) -> a1.getName().compareTo(a2.getName()));
                    BlockPos.MutableBlockPos check = new BlockPos.MutableBlockPos(0, 0, 0);
                    int extra = 0;
                    for (int x = -tile.getRadius(); x < tile.getRadius(); ++x) {
                        for (int z = -tile.getRadius(); z < tile.getRadius(); ++z) {
                            if (tile.isCircle() && x * x + z * z >= tile.getRadius() * tile.getRadius()) continue;
                            check.func_181079_c(tile.func_174877_v().func_177958_n() + x, tile.func_174877_v().func_177956_o(), tile.func_174877_v().func_177952_p() + z);
                            if (reset) {
                                changeTo = BiomeUtil.getNaturalBiome(tile.func_145831_w(), (BlockPos)check, Biomes.field_76772_c);
                            }
                            if (BiomeUtil.areBiomesSame(tile.func_145831_w(), (BlockPos)check, changeTo)) continue;
                            for (BiomeDictionary.Type type : BiomeDictionary.getTypes((Biome)changeTo)) {
                                Aspect aspect = BiomeUtil.getAspectForType(type, Aspect.EXCHANGE);
                                if (aspect == null) continue;
                                if (aspect == Aspect.ORDER || aspect == Aspect.ENTROPY) {
                                    map.addTo((Object)Aspect.EXCHANGE, 1);
                                    continue;
                                }
                                if (!aspect.isPrimal() && aspect != Aspect.EXCHANGE) continue;
                                map.addTo((Object)aspect, 1);
                            }
                            ++extra;
                        }
                    }
                    if (extra > 0) {
                        map.addTo((Object)Aspect.EXCHANGE, extra);
                    }
                    return map;
                });
            }
            catch (ExecutionException ex) {
                ThaumicAugmentation.getLogger().error("Something threw an exception when it really should not have!");
                throw new RuntimeException(ex);
            }
            if (!costs.isEmpty()) {
                GlStateManager.func_179147_l();
                int drawX = 14;
                int drawY = 14;
                for (Object2IntMap.Entry entry : costs.object2IntEntrySet()) {
                    UtilsFX.drawTag((int)drawX, (int)drawY, (Aspect)((Aspect)entry.getKey()), (float)entry.getIntValue(), (int)0, (double)0.0);
                    if ((drawX += 17) <= 31) continue;
                    drawX = 14;
                    drawY += 17;
                }
                GlStateManager.func_179084_k();
            }
        }
        for (GuiButton button : this.field_146292_n) {
            if (!button.func_146115_a()) continue;
            button.func_146111_b(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            break;
        }
        RenderHelper.func_74519_b();
    }
}

