/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.util;

import com.google.common.base.MoreObjects;
import net.minecraft.util.math.BlockPos;

public class DimensionalBlockPos {
    public static final DimensionalBlockPos INVALID = new DimensionalBlockPos(0, 0, 0, 0){

        @Override
        public BlockPos getPos() {
            throw new UnsupportedOperationException("Attempted to get position of invalid DimensionalBlockPos");
        }

        @Override
        public int getDimension() {
            throw new UnsupportedOperationException("Attempted to get dimension of invalid DimensionalBlockPos");
        }

        @Override
        public int[] toArray() {
            throw new UnsupportedOperationException("Attempted to convert invalid DimensionalBlockPos to an array");
        }

        @Override
        public boolean isInvalid() {
            return true;
        }

        @Override
        public String toString() {
            return "InvalidDimensionalBlockPos{}";
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }
    };
    protected BlockPos pos;
    protected int dim;

    public DimensionalBlockPos(int x, int y, int z, int dimension) {
        this(new BlockPos(x, y, z), dimension);
    }

    public DimensionalBlockPos(BlockPos position, int dimension) {
        this.pos = position;
        this.dim = dimension;
    }

    public DimensionalBlockPos(DimensionalBlockPos toCopy) {
        this.pos = toCopy.getPos().func_185334_h();
        this.dim = toCopy.getDimension();
    }

    public DimensionalBlockPos(int[] components) {
        if (components.length != 4) {
            throw new ArrayIndexOutOfBoundsException("DimensionalBlockPos component array has wrong size");
        }
        this.pos = new BlockPos(components[0], components[1], components[2]);
        this.dim = components[3];
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getDimension() {
        return this.dim;
    }

    public int[] toArray() {
        return new int[]{this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p(), this.dim};
    }

    public boolean isInvalid() {
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("x", this.pos.func_177958_n()).add("y", this.pos.func_177956_o()).add("z", this.pos.func_177952_p()).add("dim", this.dim).toString();
    }

    public boolean equals(Object obj) {
        if (obj.getClass() == DimensionalBlockPos.class) {
            return ((DimensionalBlockPos)obj).getPos().equals((Object)this.pos) && ((DimensionalBlockPos)obj).getDimension() == this.dim;
        }
        return false;
    }

    public int hashCode() {
        return this.pos.hashCode() * 31 + this.dim;
    }
}

