/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.roots.entity.spell.EntityFireJet;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.modifiers.Cost;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.properties.Property;
import epicsquid.roots.spell.SpellBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreIngredient;

public class SpellWildfire
extends SpellBase {
    public static Property.PropertyCooldown PROP_COOLDOWN = new Property.PropertyCooldown(24);
    public static Property.PropertyCastType PROP_CAST_TYPE = new Property.PropertyCastType(SpellBase.EnumCastType.INSTANTANEOUS);
    public static Property.PropertyCost PROP_COST_1 = new Property.PropertyCost(new SpellBase.SpellCost("infernal_bulb", 0.225));
    public static Property.PropertyDamage PROP_DAMAGE = new Property.PropertyDamage(Float.valueOf(4.5f));
    public static Property<Integer> PROP_FIRE_DURATION = new Property<Integer>("fire_duration", 4).setDescription("how long entities should be set on fire for");
    public static Property<Integer> PROP_SLOW_DURATION = new Property<Integer>("slow_duration", 120).setDescription("how long an entity should be slowed for");
    public static Property<Integer> PROP_SLOW_AMPLIFIER = new Property<Integer>("slow_amplifier", 0).setDescription("the amplifier that should be applied to the slow effect");
    public static Property<Integer> PROP_POISON_DURATION = new Property<Integer>("poison_duration", 120).setDescription("how long an entity should be poisoned for");
    public static Property<Integer> PROP_POISON_AMPLIFIER = new Property<Integer>("poison_amplifier", 0).setDescription("the amplifier that should be applied to the poison effect");
    public static Property<Integer> PROP_LEVITATE_DURATION = new Property<Integer>("levitate_duration", 120).setDescription("how long an entity should be levitated for");
    public static Property<Integer> PROP_FIRE_RADIUS = new Property<Integer>("fire_radius", 2).setDescription("the radius that wildfire should be created");
    public static Property<Float> PROP_ICE_DAMAGE = new Property<Float>("icicle_damage", Float.valueOf(1.0f)).setDescription("how much damage icicles should deal when they strike a creature");
    public static Property<Integer> PROP_ICICLE_COUNT = new Property<Integer>("icicle_count", 3).setDescription("how many icicles should spawn");
    public static Property<Integer> PROP_LIFETIME = new Property<Integer>("lifetime", 12).setDescription("how long the fire projectile should exist for (which determines how far it will travel");
    public static Property<Integer> PROP_WEAKNESS_DURATION = new Property<Integer>("weakness_duration", 80).setDescription("how long enemies should be weakened in place for");
    public static Property<Integer> PROP_WEAKNESS_AMPLIFIER = new Property<Integer>("weakness_amplifier", 0).setDescription("the amplifier to be applied to the weakness effect");
    public static Modifier PURPLE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "purple_flame"), ModifierCores.PERESKIA, Cost.of(Cost.cost(CostType.ADDITIONAL_COST, ModifierCores.PERESKIA, 0.05), Cost.cost(CostType.ALL_COST_MULTIPLIER, -0.15))));
    public static Modifier PEACEFUL = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "peaceful_flame"), ModifierCores.WILDEWHEET, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDEWHEET, 0.125)));
    public static Modifier WEAKNESS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "weakening_thorns"), ModifierCores.WILDROOT, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDROOT, 0.35)));
    public static Modifier SLOW = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "slow_fire"), ModifierCores.MOONGLOW_LEAF, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.MOONGLOW_LEAF, 0.325)));
    public static Modifier GREEN = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "green_flame"), ModifierCores.TERRA_MOSS, Cost.of(Cost.cost(CostType.ADDITIONAL_COST, ModifierCores.TERRA_MOSS, 0.05), Cost.cost(CostType.ALL_COST_MULTIPLIER, -0.15))));
    public static Modifier DUALITY = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "spiritual_duality"), ModifierCores.SPIRIT_HERB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.SPIRIT_HERB, 0.925)));
    public static Modifier POISON = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "poisoned_fire"), ModifierCores.BAFFLE_CAP, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.BAFFLE_CAP, 0.325)));
    public static Modifier LEVITATE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "floating_cinders"), ModifierCores.CLOUD_BERRY, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.CLOUD_BERRY, 0.6)));
    public static Modifier WILDFIRE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "pyroclastic_cloud"), ModifierCores.STALICRIPE, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.STALICRIPE, 0.45)));
    public static Modifier ICICLES = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "fire_and_ice"), ModifierCores.DEWGONIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.DEWGONIA, 0.375)));
    public static ResourceLocation spellName;
    public static SpellWildfire instance;
    public float damage;
    public float ice_damage;
    public int fire_duration;
    public int fire_radius;
    public int slow_duration;
    public int slow_amplifier;
    public int poison_duration;
    public int poison_amplifier;
    public int levitate_duration;
    public int icicle_count;
    public int lifetime;
    public int weakness_amplifier;
    public int weakness_duration;

    public SpellWildfire(ResourceLocation name) {
        super(name, TextFormatting.GOLD, 1.0f, 0.5019608f, 0.1254902f, 1.0f, 0.2509804f, 0.1254902f);
        this.properties.add(PROP_COOLDOWN, PROP_CAST_TYPE, PROP_COST_1, PROP_DAMAGE, PROP_FIRE_DURATION, PROP_SLOW_AMPLIFIER, PROP_SLOW_DURATION, PROP_POISON_AMPLIFIER, PROP_POISON_DURATION, PROP_LEVITATE_DURATION, PROP_FIRE_RADIUS, PROP_ICE_DAMAGE, PROP_ICICLE_COUNT, PROP_LIFETIME, PROP_WEAKNESS_AMPLIFIER, PROP_WEAKNESS_DURATION);
        this.acceptModifiers(PURPLE, PEACEFUL, WEAKNESS, SLOW, GREEN, DUALITY, POISON, LEVITATE, WILDFIRE, ICICLES);
    }

    @Override
    public void init() {
        this.addIngredients(new OreIngredient("dyeOrange"), new ItemStack(Items.field_151044_h, 1, 1), new OreIngredient("gunpowder"), new ItemStack(ModItems.infernal_bulb), new OreIngredient("dustRedstone"));
        this.setCastSound(ModSounds.Spells.WILDFIRE);
    }

    private void createJet(EntityPlayer player, StaffModifierInstanceList info, int ticks) {
        EntityFireJet fireJet = new EntityFireJet(player.field_70170_p);
        fireJet.setPlayer(player.func_110124_au());
        fireJet.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        fireJet.setModifiers(info);
        player.field_70170_p.func_72838_d((Entity)fireJet);
    }

    @Override
    public boolean cast(EntityPlayer player, StaffModifierInstanceList info, int ticks) {
        if (!player.field_70170_p.field_72995_K) {
            this.createJet(player, info, ticks);
            if (info.has(DUALITY)) {
                this.createJet(player, info, ticks);
            }
        }
        return true;
    }

    @Override
    public void doFinalise() {
        this.castType = this.properties.get(PROP_CAST_TYPE);
        this.cooldown = this.properties.get(PROP_COOLDOWN);
        this.damage = this.properties.get(PROP_DAMAGE).floatValue();
        this.fire_duration = this.properties.get(PROP_FIRE_DURATION);
        this.slow_duration = this.properties.get(PROP_SLOW_DURATION);
        this.slow_amplifier = this.properties.get(PROP_SLOW_AMPLIFIER);
        this.poison_amplifier = this.properties.get(PROP_POISON_AMPLIFIER);
        this.poison_duration = this.properties.get(PROP_POISON_DURATION);
        this.levitate_duration = this.properties.get(PROP_LEVITATE_DURATION);
        this.fire_radius = this.properties.get(PROP_FIRE_RADIUS);
        this.ice_damage = this.properties.get(PROP_ICE_DAMAGE).floatValue();
        this.icicle_count = this.properties.get(PROP_ICICLE_COUNT);
        this.lifetime = this.properties.get(PROP_LIFETIME);
        this.weakness_duration = this.properties.get(PROP_WEAKNESS_DURATION);
        this.weakness_amplifier = this.properties.get(PROP_WEAKNESS_AMPLIFIER);
    }

    static {
        GREEN.addConflicts(PURPLE);
        spellName = new ResourceLocation("roots", "spell_wild_fire");
        instance = new SpellWildfire(spellName);
    }
}

