/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.roots.entity.spell.EntityBoost;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.modifiers.Cost;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.properties.Property;
import epicsquid.roots.spell.SpellBase;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;

public class SpellSkySoarer
extends SpellBase {
    public static Property.PropertyCooldown PROP_COOLDOWN = new Property.PropertyCooldown(39);
    public static Property.PropertyCastType PROP_CAST_TYPE = new Property.PropertyCastType(SpellBase.EnumCastType.INSTANTANEOUS);
    public static Property.PropertyCost PROP_COST_1 = new Property.PropertyCost(new SpellBase.SpellCost("cloud_berry", 0.25));
    public static Property<Integer> PROP_SLOW_FALL_DURATION = new Property<Integer>("slow_fall_duration", 400).setDescription("the duration of the slow fall effect that should be applied after the boost effect ends");
    public static Property<Integer> PROP_JAUNT_DISTANCE = new Property<Integer>("jaunt_distance", 5).setDescription("the number of blocks forward to jaunt");
    public static Property<Integer> PROP_REGEN_DURATION = new Property<Integer>("regen_duration", 400).setDescription("how long regeneration should be applied for");
    public static Property<Integer> PROP_REGEN_AMPLIFIER = new Property<Integer>("regen_amplifier", 0).setDescription("the amplifier to use for the regeneration effect");
    public static Property<Float> PROP_AMPLIFIER = new Property<Float>("amplifier", Float.valueOf(0.8f)).setDescription("the amplifier to the default motion");
    public static Property<Float> PROP_EXTENDED_AMPLIFIER = new Property<Float>("extended_amplifier", Float.valueOf(0.6f)).setDescription("how much should be added to the default amplifier when the faster modifier is enabled");
    public static Property<Integer> PROP_FALL_DURATION = new Property<Integer>("fall_duration", 300).setDescription("the duration for which fall damage should be suppressed after a boost ends");
    public static Property<Integer> PROP_LIFETIME = new Property<Integer>("lifetime", 28).setDescription("how long the boost entity should exist for (in ticks)");
    public static Property<Integer> PROP_EXTENDED_LIFETIME = new Property<Integer>("extended_lifetime", 28).setDescription("a value that should be added to the lifetime when the eternal flame modifier is used (in ticks)");
    public static Modifier SLOW_FALL = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "slow_fall"), ModifierCores.PERESKIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.PERESKIA, 0.275)));
    public static Modifier NO_COLLIDE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "arboreal_bypass"), ModifierCores.WILDEWHEET, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDEWHEET, 0.125)));
    public static Modifier FASTER = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "momentum"), ModifierCores.WILDROOT, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDROOT, 0.345)));
    public static Modifier VERTICAL = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "verticality"), ModifierCores.MOONGLOW_LEAF, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.MOONGLOW_LEAF, 0.345)));
    public static Modifier JAUNT = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "jaunt"), ModifierCores.SPIRIT_HERB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.SPIRIT_HERB, 0.345)));
    public static Modifier REGENERATION = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "regenerative_sky"), ModifierCores.TERRA_MOSS, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.TERRA_MOSS, 0.275)));
    public static Modifier CHEM_TRAILS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "chem_trails"), ModifierCores.BAFFLE_CAP, Cost.of(Cost.cost(CostType.ADDITIONAL_COST, ModifierCores.BAFFLE_CAP, 0.05), Cost.cost(CostType.ALL_COST_MULTIPLIER, -0.15))));
    public static Modifier ETERNAL = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "eternal_flame"), ModifierCores.INFERNAL_BULB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.INFERNAL_BULB, 0.45)));
    public static Modifier NO_FALL_DAMAGE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "friendly_earth"), ModifierCores.STALICRIPE, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.STALICRIPE, 0.275)));
    public static Modifier HORIZONTAL = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "aquaplane"), ModifierCores.DEWGONIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.DEWGONIA, 0.345)));
    public static ResourceLocation spellName;
    public static SpellSkySoarer instance;
    public float amplifier;
    public float extended_amplifier;
    public int slow_duration;
    public int jaunt_distance;
    public int regen_duration;
    public int regen_amplifier;
    public int fall_duration;
    public int lifetime;
    public int extended_liftime;

    public SpellSkySoarer(ResourceLocation name) {
        super(name, TextFormatting.BLUE, 0.1254902f, 0.78431374f, 1.0f, 0.1254902f, 0.2509804f, 1.0f);
        this.properties.add(PROP_COOLDOWN, PROP_CAST_TYPE, PROP_COST_1, PROP_SLOW_FALL_DURATION, PROP_JAUNT_DISTANCE, PROP_REGEN_AMPLIFIER, PROP_REGEN_DURATION, PROP_AMPLIFIER, PROP_FALL_DURATION, PROP_LIFETIME, PROP_EXTENDED_LIFETIME, PROP_EXTENDED_AMPLIFIER);
        this.acceptModifiers(SLOW_FALL, NO_COLLIDE, FASTER, VERTICAL, JAUNT, REGENERATION, CHEM_TRAILS, ETERNAL, NO_FALL_DAMAGE, HORIZONTAL);
    }

    @Override
    public void init() {
        this.addIngredients(new ItemStack(Item.func_150898_a((Block)Blocks.field_150468_ap)), new ItemStack(ModItems.petals), new ItemStack((Item)Items.field_151031_f), new ItemStack(epicsquid.mysticalworld.init.ModItems.aubergine_seed), new ItemStack(ModItems.cloud_berry));
        this.setCastSound(ModSounds.Spells.SKY_SOARER);
    }

    private boolean playerSafe(EntityPlayer player, BlockPos.MutableBlockPos position, EnumFacing direction) {
        int safe_count = 0;
        int start_y = position.func_177956_o();
        position.func_185336_p(start_y - (direction == EnumFacing.DOWN ? 2 : 1));
        IBlockState state = player.field_70170_p.func_180495_p((BlockPos)position);
        if (!state.isSideSolid((IBlockAccess)player.field_70170_p, (BlockPos)position, EnumFacing.UP)) {
            return false;
        }
        position.func_185336_p(start_y);
        state = player.field_70170_p.func_180495_p((BlockPos)position);
        if (state.func_177230_c().func_176205_b((IBlockAccess)player.field_70170_p, (BlockPos)position)) {
            ++safe_count;
        }
        position.func_189534_c(direction, 1);
        state = player.field_70170_p.func_180495_p((BlockPos)position);
        if (state.func_177230_c().func_176205_b((IBlockAccess)player.field_70170_p, (BlockPos)position)) {
            ++safe_count;
        }
        return safe_count == 2;
    }

    @Nullable
    private Vec3d findSafePosition(EntityPlayer player) {
        int height;
        Vec3d realPos = new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v).func_178787_e(Vec3d.func_189986_a((float)0.0f, (float)player.field_70177_z).func_186678_a((double)this.jaunt_distance));
        BlockPos real = new BlockPos(realPos);
        BlockPos pos = player.field_70170_p.func_175645_m(real);
        int n = height = player.field_70170_p.field_73011_w.func_177495_o() ? 128 : 256;
        if (height == 128) {
            int i;
            BlockPos.MutableBlockPos dest = new BlockPos.MutableBlockPos(real);
            int safe_y = -1;
            for (i = height - 1; i > real.func_177956_o(); --i) {
                dest.func_185336_p(i);
                if (!this.playerSafe(player, dest, EnumFacing.UP)) continue;
                safe_y = i;
                break;
            }
            if (safe_y == -1) {
                for (i = 0; i < real.func_177956_o(); ++i) {
                    dest.func_185336_p(i);
                    if (!this.playerSafe(player, dest, EnumFacing.DOWN)) continue;
                    safe_y = i;
                    break;
                }
            }
            if (safe_y == -1 || safe_y >= height) {
                return null;
            }
            return new Vec3d(realPos.field_72450_a, (double)safe_y + 0.01, realPos.field_72449_c);
        }
        IBlockState state = player.field_70170_p.func_180495_p(pos);
        IBlockState state2 = player.field_70170_p.func_180495_p(pos.func_177984_a());
        IBlockState state3 = player.field_70170_p.func_180495_p(pos.func_177977_b());
        if (state.func_177230_c().func_176205_b((IBlockAccess)player.field_70170_p, pos) && state2.func_177230_c().func_176205_b((IBlockAccess)player.field_70170_p, pos.func_177984_a()) && state3.isSideSolid((IBlockAccess)player.field_70170_p, pos.func_177977_b(), EnumFacing.UP)) {
            return new Vec3d(realPos.field_72450_a, (double)pos.func_177956_o() + 0.01, realPos.field_72449_c);
        }
        return null;
    }

    @Override
    public boolean cast(EntityPlayer player, StaffModifierInstanceList info, int ticks) {
        if (!player.field_70170_p.field_72995_K) {
            if (info.has(JAUNT)) {
                Vec3d dest = this.findSafePosition(player);
                if (dest == null) {
                    return false;
                }
                if (dest.field_72448_b >= 128.0) {
                    // empty if block
                }
                if (!player.field_70170_p.field_72995_K) {
                    player.func_70634_a(dest.field_72450_a, dest.field_72448_b, dest.field_72449_c);
                    player.field_70143_R = 0.0f;
                }
            } else {
                int life = this.lifetime;
                if (info.has(ETERNAL)) {
                    life += this.extended_liftime;
                }
                EntityBoost boost = new EntityBoost(player.field_70170_p, life);
                boost.setModifiers(info);
                boost.setPlayer(player.func_110124_au());
                boost.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                player.field_70170_p.func_72838_d((Entity)boost);
            }
            if (info.has(REGENERATION)) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, this.regen_duration, this.regen_amplifier, false, false));
            }
        }
        return true;
    }

    @Override
    public void doFinalise() {
        this.castType = this.properties.get(PROP_CAST_TYPE);
        this.cooldown = this.properties.get(PROP_COOLDOWN);
        this.slow_duration = this.properties.get(PROP_SLOW_FALL_DURATION);
        this.jaunt_distance = this.properties.get(PROP_JAUNT_DISTANCE);
        this.regen_amplifier = this.properties.get(PROP_REGEN_AMPLIFIER);
        this.regen_duration = this.properties.get(PROP_REGEN_DURATION);
        this.amplifier = this.properties.get(PROP_AMPLIFIER).floatValue();
        this.fall_duration = this.properties.get(PROP_FALL_DURATION);
        this.lifetime = this.properties.get(PROP_LIFETIME);
        this.extended_liftime = this.properties.get(PROP_EXTENDED_LIFETIME);
        this.extended_amplifier = this.properties.get(PROP_EXTENDED_AMPLIFIER).floatValue();
    }

    static {
        JAUNT.addConflicts(NO_FALL_DAMAGE, CHEM_TRAILS, ETERNAL, VERTICAL, FASTER, NO_COLLIDE, SLOW_FALL);
        VERTICAL.addConflict(HORIZONTAL);
        spellName = new ResourceLocation("roots", "spell_sky_soarer");
        instance = new SpellSkySoarer(spellName);
    }
}

