/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.ritual;

import epicsquid.roots.entity.ritual.EntityRitualWardingProtection;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.properties.Property;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.ritual.conditions.ConditionStandingStones;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreIngredient;

public class RitualWardingProtection
extends RitualBase {
    public static Property.PropertyDuration PROP_DURATION = new Property.PropertyDuration(1200);
    public static Property<Integer> PROP_RADIUS_X = new Property<Integer>("radius_x", 15).setDescription("Radius on the X Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_RADIUS_Y = new Property<Integer>("radius_y", 15).setDescription("Radius on the Y Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_RADIUS_Z = new Property<Integer>("radius_z", 15).setDescription("Radius on the Z Axis of the cube in which the ritual takes place");
    public static Property.PropertyInterval PROP_INTERVAL = new Property.PropertyInterval(20).setDescription("interval in ticks between each time you get provided the invulnerability effect");
    public static Property<Integer> PROP_INVULN_DURATION = new Property<Integer>("invuln_duration", 22).setDescription("duration in ticks of the invulnerability effect");
    public double radius_x;
    public double radius_y;
    public double radius_z;
    public int interval;
    public int invuln_duration;

    public RitualWardingProtection(String name, boolean disabled) {
        super(name, disabled);
        this.properties.add(PROP_DURATION, PROP_RADIUS_X, PROP_RADIUS_Y, PROP_RADIUS_Z, PROP_INTERVAL, PROP_INVULN_DURATION);
        this.setEntityClass(EntityRitualWardingProtection.class);
    }

    @Override
    public void init() {
        this.recipe = new RitualBase.RitualRecipe((RitualBase)this, new ItemStack(Items.field_151060_bw), new ItemStack(ModItems.stalicripe), new OreIngredient("wildroot"), new OreIngredient("rootsBark"), new ItemStack(Items.field_185159_cQ));
        this.addCondition(new ConditionStandingStones(3, 2));
        this.addCondition(new ConditionStandingStones(4, 2));
        this.setIcon(ModItems.ritual_warding_protection);
        this.setColor(TextFormatting.DARK_BLUE);
        this.setBold(true);
    }

    @Override
    public void doFinalise() {
        this.duration = this.properties.get(PROP_DURATION);
        int[] radius = this.properties.getRadius();
        this.radius_x = (double)radius[0] + 0.5;
        this.radius_y = (double)radius[1] + 0.5;
        this.radius_z = (double)radius[2] + 0.5;
        this.interval = this.properties.get(PROP_INTERVAL);
        this.invuln_duration = this.properties.get(PROP_INVULN_DURATION);
    }
}

