/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.recipe;

import epicsquid.roots.recipe.transmutation.BlockStatePredicate;
import epicsquid.roots.recipe.transmutation.StatePredicate;
import epicsquid.roots.recipe.transmutation.WorldBlockStatePredicate;
import epicsquid.roots.util.types.RegistryItem;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TransmutationRecipe
extends RegistryItem {
    private BlockStatePredicate start;
    private ItemStack stack = ItemStack.field_190927_a;
    private IBlockState state = null;
    private WorldBlockStatePredicate condition = WorldBlockStatePredicate.TRUE;

    public TransmutationRecipe(IBlockState start) {
        this.start = new StatePredicate(start);
    }

    public TransmutationRecipe(BlockStatePredicate start) {
        this.start = start;
    }

    public BlockStatePredicate getStartPredicate() {
        return this.start;
    }

    public WorldBlockStatePredicate getCondition() {
        return this.condition;
    }

    public TransmutationRecipe item(ItemStack stack) {
        if (this.state != null) {
            throw new IllegalStateException("Can't have both a state and an itemstack result");
        }
        this.stack = stack;
        return this;
    }

    public TransmutationRecipe state(IBlockState state) {
        if (!this.stack.func_190926_b()) {
            throw new IllegalStateException("Can't have both a state and an itemstack result");
        }
        this.state = state;
        return this;
    }

    public TransmutationRecipe condition(@Nullable WorldBlockStatePredicate condition) {
        this.condition = condition == null ? WorldBlockStatePredicate.TRUE : condition;
        return this;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public Optional<IBlockState> getState() {
        if (this.state == null) {
            return Optional.empty();
        }
        return Optional.of(this.state);
    }

    public boolean matches(IBlockState state, World world, BlockPos pos) {
        return this.start.test(state) && this.condition != null && this.condition.test(state, world, pos);
    }

    public boolean matches(World world, BlockPos pos) {
        return this.matches(world.func_180495_p(pos), world, pos);
    }
}

