/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.network;

import epicsquid.roots.integration.IntegrationUtil;
import epicsquid.roots.network.ClientMessageHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessagePatchouliJEI
implements IMessage {
    private boolean isJEI;
    private String category;

    public MessagePatchouliJEI() {
    }

    public MessagePatchouliJEI(boolean isJEI, String category) {
        this.category = category;
        this.isJEI = isJEI;
    }

    public void fromBytes(ByteBuf buf) {
        this.isJEI = buf.readBoolean();
        this.category = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.isJEI);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.category);
    }

    public static class MessageHolder
    extends ClientMessageHandler<MessagePatchouliJEI> {
        @Override
        @SideOnly(value=Side.CLIENT)
        protected void handleMessage(MessagePatchouliJEI message, MessageContext ctx) {
            if (!message.isJEI) {
                ResourceLocation entry = new ResourceLocation("roots", message.category.toLowerCase());
                ResourceLocation bookPath = new ResourceLocation("roots", "roots_guide");
                IntegrationUtil.openCategory(bookPath, entry);
            }
        }
    }
}

