/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.jei.soil;

import epicsquid.roots.integration.jei.soil.SoilRecipe;
import epicsquid.roots.integration.jei.soil.SoilWrapper;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class SoilCategory
implements IRecipeCategory<SoilWrapper> {
    public static IDrawable air;
    public static IDrawable earth;
    public static IDrawable liquid;
    public static IDrawable background;

    public SoilCategory(IGuiHelper helper) {
        air = helper.createDrawable(new ResourceLocation("roots", "textures/gui/jei/elemental_soil_air.png"), 0, 0, 24, 20);
        earth = helper.createDrawable(new ResourceLocation("roots", "textures/gui/jei/elemental_soil_earth.png"), 0, 0, 24, 20);
        liquid = helper.createDrawable(new ResourceLocation("roots", "textures/gui/jei/elemental_soil_liquid.png"), 0, 0, 24, 20);
        background = helper.createDrawable(new ResourceLocation("roots", "textures/gui/jei/elemental_soil.png"), 0, 0, 115, 44);
    }

    public String getUid() {
        return "roots.soil";
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"container.roots.soil.name", (Object[])new Object[0]);
    }

    public String getModName() {
        return "Roots";
    }

    public IDrawable getBackground() {
        return background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, SoilWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup group = recipeLayout.getItemStacks();
        IGuiFluidStackGroup group2 = recipeLayout.getFluidStacks();
        if (recipeWrapper.recipe != null) {
            group.init(0, true, 0, 2);
            group.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
            group.init(1, false, 57, 24);
            group.set(1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
            if (recipeWrapper.recipe.getType() == SoilRecipe.RecipeType.FIRE || recipeWrapper.recipe.getType() == SoilRecipe.RecipeType.WATER) {
                group2.init(0, true, 19, 25);
                if (recipeWrapper.recipe.getType() == SoilRecipe.RecipeType.FIRE) {
                    group2.set(0, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
                } else {
                    group2.set(0, (List)ingredients.getInputs(VanillaTypes.FLUID).get(1));
                }
            }
        }
    }
}

