/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.entity.ritual;

import epicsquid.roots.entity.ritual.EntityRitualBase;
import epicsquid.roots.particle.ParticleUtil;
import epicsquid.roots.ritual.RitualPurity;
import epicsquid.roots.ritual.RitualRegistry;
import epicsquid.roots.util.EntityUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityRitualPurity
extends EntityRitualBase {
    private RitualPurity ritual;

    public EntityRitualPurity(World worldIn) {
        super(worldIn);
        this.func_184212_Q().func_187214_a(lifetime, (Object)(RitualRegistry.ritual_purity.getDuration() + 20));
        this.ritual = (RitualPurity)RitualRegistry.ritual_purity;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        float alpha = (float)Math.min(40, RitualRegistry.ritual_healing_aura.getDuration() + 20 - (Integer)this.func_184212_Q().func_187225_a(lifetime)) / 40.0f;
        if (this.field_70170_p.field_72995_K && (Integer)this.func_184212_Q().func_187225_a(lifetime) > 0) {
            ParticleUtil.spawnParticleStar(this.field_70170_p, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, 0.0f, 0.0f, 0.0f, 100.0f, 255.0f, 100.0f, 0.5f * alpha, 20.0f, 40);
            if (this.field_70146_Z.nextInt(5) == 0) {
                ParticleUtil.spawnParticleSpark(this.field_70170_p, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, 0.125f * (this.field_70146_Z.nextFloat() - 0.5f), 0.0625f * this.field_70146_Z.nextFloat(), 0.125f * (this.field_70146_Z.nextFloat() - 0.5f), 255.0f, 255.0f, 255.0f, 1.0f * alpha, 1.0f + this.field_70146_Z.nextFloat(), 160);
            }
            for (float i = 0.0f; i < 360.0f; i += 72.0f) {
                double ang = this.field_70173_aa % 360;
                float tx = (float)this.field_70165_t + 1.0f * (float)Math.sin(Math.toRadians((double)i + ang));
                float ty = (float)this.field_70163_u;
                float tz = (float)this.field_70161_v + 1.0f * (float)Math.cos(Math.toRadians((double)i + ang));
                ParticleUtil.spawnParticleGlow(this.field_70170_p, tx, ty, tz, 0.0f, 0.0f, 0.0f, 255.0f, 255.0f, 255.0f, 0.5f * alpha, 8.0f, 40);
            }
        }
        List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_70165_t - this.ritual.radius_x, this.field_70163_u - this.ritual.radius_y, this.field_70161_v - this.ritual.radius_z, this.field_70165_t + this.ritual.radius_x, this.field_70163_u + this.ritual.radius_y, this.field_70161_v + this.ritual.radius_z));
        for (EntityLivingBase e : entities) {
            if (EntityUtil.isHostile((Entity)e, RitualRegistry.ritual_purity)) {
                if (!(e instanceof EntityZombieVillager) || !((EntityZombieVillager)e).func_82230_o()) continue;
                ((EntityZombieVillager)e).field_82234_d -= this.ritual.zombie_count;
                e.func_70066_B();
                continue;
            }
            if (this.field_70173_aa % this.ritual.interval != 0) continue;
            ArrayList<Potion> toRemove = new ArrayList<Potion>();
            for (PotionEffect potionEffect : e.func_70651_bq()) {
                if (!potionEffect.func_188419_a().func_76398_f()) continue;
                toRemove.add(potionEffect.func_188419_a());
            }
            if (!toRemove.isEmpty()) {
                Potion removal = (Potion)toRemove.get(this.field_70146_Z.nextInt(toRemove.size()));
                e.func_184589_d(removal);
            }
            e.func_70066_B();
            if (!this.field_70170_p.field_72995_K) continue;
            for (float i = 0.0f; i < 8.0f; i += 1.0f) {
                ParticleUtil.spawnParticleStar(this.field_70170_p, (float)e.field_70165_t + 0.5f * (this.field_70146_Z.nextFloat() - 0.5f), (float)e.field_70163_u + e.field_70131_O / 2.5f + (this.field_70146_Z.nextFloat() - 0.5f), (float)e.field_70161_v + 0.5f * (this.field_70146_Z.nextFloat() - 0.5f), 0.125f * (this.field_70146_Z.nextFloat() - 0.5f), 0.01875f * this.field_70146_Z.nextFloat(), 0.125f * (this.field_70146_Z.nextFloat() - 0.5f), 100.0f, 255.0f, 100.0f, 1.0f * alpha, 1.0f + 2.0f * this.field_70146_Z.nextFloat(), 40);
            }
        }
    }
}

