/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.nbt;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import ivorius.ivtoolkit.lang.IvClasses;
import ivorius.ivtoolkit.tools.NBTCompoundObject;
import ivorius.ivtoolkit.tools.NBTCompoundObjects;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class NBTStringTypeRegistry<B extends NBTCompoundObject> {
    private BiMap<Class<? extends B>, String> classMap = HashBiMap.create();
    private String typeKey;
    private String objectKey;

    public NBTStringTypeRegistry(String objectKey, String typeKey) {
        if (objectKey.equals(typeKey)) {
            throw new IllegalArgumentException("Type key must be different from object key");
        }
        this.objectKey = objectKey;
        this.typeKey = typeKey;
    }

    public NBTStringTypeRegistry() {
        this("object", "type");
    }

    public String getTypeKey() {
        return this.typeKey;
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    public <T extends B> void register(String id, Class<? extends T> clazz) {
        this.classMap.put(clazz, (Object)id);
    }

    public String type(Class<? extends B> aClass) {
        return (String)this.classMap.get(aClass);
    }

    public Class<? extends B> objectClass(String type) {
        return (Class)this.classMap.inverse().get((Object)type);
    }

    public Collection<String> allIDs() {
        return this.classMap.inverse().keySet();
    }

    public B copy(B b) {
        return this.read(this.write(b));
    }

    public NBTTagCompound write(B t) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a(this.getTypeKey(), this.type(t.getClass()));
        compound.func_74782_a(this.getObjectKey(), (NBTBase)NBTCompoundObjects.write(t));
        return compound;
    }

    @Nullable
    public B read(NBTTagCompound compound) {
        Class type = this.objectClass(compound.func_74779_i(this.getTypeKey()));
        return (B)(type != null ? NBTCompoundObjects.read(compound.func_74775_l(this.getObjectKey()), () -> (NBTCompoundObject)IvClasses.instantiate(type)) : null);
    }
}

