/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Biomes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.item.ItemMod;
import vazkii.quark.base.Quark;
import vazkii.quark.base.item.ItemQuarkFood;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.potion.PotionMod;
import vazkii.quark.misc.feature.ExtraPotions;
import vazkii.quark.world.client.render.RenderCrab;
import vazkii.quark.world.entity.EntityCrab;
import vazkii.quark.world.item.ItemCrabShell;
import vazkii.quark.world.world.event.RaveEventListener;

public class Crabs
extends Feature {
    public static int weight;
    public static int min;
    public static int max;
    public static ItemQuarkFood crabLeg;
    public static ItemQuarkFood cookedCrabLeg;
    public static ItemMod crabShell;
    public static PotionMod resilience;

    @Override
    public void setupConfig() {
        weight = this.loadPropInt("Spawn Weight", "The higher, the more will spawn", 40);
        min = this.loadPropInt("Smallest spawn group", "", 1);
        max = this.loadPropInt("Largest spawn group", "", 3);
    }

    @SubscribeEvent
    public void onNewWorld(WorldEvent.Load event) {
        event.getWorld().func_72954_a((IWorldEventListener)new RaveEventListener(event.getWorld()));
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        crabLeg = new ItemQuarkFood("crab_leg", 1, 0.3f, true, new String[0]);
        cookedCrabLeg = new ItemQuarkFood("cooked_crab_leg", 8, 0.8f, true, new String[0]);
        crabShell = new ItemCrabShell();
        resilience = new PotionMod("resilience", false, 5970436, 5);
        resilience.func_111184_a(SharedMonsterAttributes.field_111266_c, "0cb68666-1b17-42b3-82c0-28412d6c0b22", 0.5, 0);
        String crabName = "quark:crab";
        LootTableList.func_186375_a((ResourceLocation)EntityCrab.CRAB_LOOT_TABLE);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(crabName), EntityCrab.class, (String)crabName, (int)22, (Object)Quark.instance, (int)80, (int)3, (boolean)true, (int)8993826, (int)9528648);
    }

    @Override
    public void postPreInit() {
        ExtraPotions.addStandardBlend(resilience, crabShell);
    }

    @Override
    public void init() {
        EntityRegistry.addSpawn(EntityCrab.class, (int)weight, (int)min, (int)max, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])new Biome[]{Biomes.field_76787_r});
    }

    @Override
    public void postInit() {
        FurnaceRecipes.func_77602_a().func_151396_a((Item)crabLeg, new ItemStack((Item)cookedCrabLeg), 0.35f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient() {
        RenderingRegistry.registerEntityRenderingHandler(EntityCrab.class, RenderCrab.FACTORY);
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

