/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.misc.feature;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentKeybind;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.network.NetworkHandler;
import vazkii.quark.api.IRotationLockHandler;
import vazkii.quark.base.client.ModKeybinds;
import vazkii.quark.base.lib.LibMisc;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.network.message.MessageSetLockProfile;

public class LockDirectionHotkey
extends Feature {
    private static final String TAG_LOCKED_ONCE = "quark:locked_once";
    private static final HashMap<String, LockProfile> lockProfiles = new HashMap();
    private LockProfile clientProfile;

    @Override
    public void setupConfig() {
        lockProfiles.clear();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient() {
        ModKeybinds.initLockKey();
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.PlaceEvent event) {
        if (event.isCanceled() || event.getResult() == Event.Result.DENY) {
            return;
        }
        LockDirectionHotkey.fixBlockRotation(event.getWorld(), event.getPlayer(), event.getPos());
    }

    public static void fixBlockRotation(World world, EntityPlayer player, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        String name = player.func_70005_c_();
        if (lockProfiles.containsKey(name)) {
            LockProfile profile = lockProfiles.get(name);
            LockDirectionHotkey.setBlockRotated(world, state, pos, profile.facing.func_176734_d(), true, profile.half);
        }
    }

    public static void setBlockRotated(World world, IBlockState state, BlockPos pos, EnumFacing face) {
        LockDirectionHotkey.setBlockRotated(world, state, pos, face, false, -1);
    }

    public static void setBlockRotated(World world, IBlockState state, BlockPos pos, EnumFacing face, boolean stateCheck, int half) {
        IBlockState setState = state;
        ImmutableMap props = state.func_177228_b();
        Block block = state.func_177230_c();
        if (block instanceof IRotationLockHandler) {
            setState = ((IRotationLockHandler)block).setRotation(world, pos, setState, face, half != -1, half == 1);
        } else if (block == Blocks.field_150324_C && face.func_176740_k() != EnumFacing.Axis.Y) {
            EnumFacing opposite;
            EnumFacing prevFace = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
            if (prevFace != (opposite = face.func_176734_d())) {
                BlockPos prevPos = pos.func_177972_a(prevFace);
                setState = state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)opposite);
                IBlockState inWorld = world.func_180495_p(prevPos);
                if (inWorld.func_177230_c() == Blocks.field_150324_C) {
                    world.func_175698_g(prevPos);
                    world.func_175656_a(pos.func_177972_a(opposite), inWorld.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)opposite));
                }
            }
        } else if (props.containsKey((Object)BlockDirectional.field_176387_N)) {
            setState = state.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)face);
        } else if (props.containsKey((Object)BlockHorizontal.field_185512_D) && face.func_176740_k() != EnumFacing.Axis.Y) {
            setState = block instanceof BlockStairs ? state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)face.func_176734_d()) : state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)face);
        } else if (props.containsKey((Object)BlockRotatedPillar.field_176298_M)) {
            setState = state.func_177226_a((IProperty)BlockRotatedPillar.field_176298_M, (Comparable)face.func_176740_k());
        } else if (props.containsKey((Object)BlockLog.field_176299_a)) {
            setState = state.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)face.func_176740_k()));
        } else if (props.containsKey((Object)BlockQuartz.field_176335_a)) {
            BlockQuartz.EnumType type = (BlockQuartz.EnumType)state.func_177229_b((IProperty)BlockQuartz.field_176335_a);
            if (ImmutableSet.of((Object)BlockQuartz.EnumType.LINES_X, (Object)BlockQuartz.EnumType.LINES_Y, (Object)BlockQuartz.EnumType.LINES_Z).contains((Object)type)) {
                setState = state.func_177226_a((IProperty)BlockQuartz.field_176335_a, (Comparable)BlockQuartz.field_176335_a.func_185929_b("lines_" + face.func_176740_k().func_176610_l()).or((Object)BlockQuartz.EnumType.LINES_Y));
            }
        } else if (props.containsKey((Object)BlockHopper.field_176430_a)) {
            setState = state.func_177226_a((IProperty)BlockHopper.field_176430_a, (Comparable)(face == EnumFacing.DOWN ? face : face.func_176734_d()));
        }
        if (half != -1) {
            if (props.containsKey((Object)BlockStairs.field_176308_b)) {
                setState = setState.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)(half == 1 ? BlockStairs.EnumHalf.TOP : BlockStairs.EnumHalf.BOTTOM));
            } else if (props.containsKey((Object)BlockSlab.field_176554_a)) {
                setState = setState.func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)(half == 1 ? BlockSlab.EnumBlockHalf.TOP : BlockSlab.EnumBlockHalf.BOTTOM));
            }
        }
        if (!stateCheck || setState != state) {
            world.func_175656_a(pos, setState);
            world.func_190524_a(pos, setState.func_177230_c(), pos);
        }
    }

    @SubscribeEvent
    public void onPlayerLogoff(PlayerEvent.PlayerLoggedOutEvent event) {
        lockProfiles.remove(event.player.func_70005_c_());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        boolean down = ModKeybinds.lockKey.func_151470_d();
        if (mc.field_71415_G && down) {
            LockProfile newProfile;
            RayTraceResult result = mc.field_71476_x;
            if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
                int half = (int)((result.field_72307_f.field_72448_b - (double)((int)result.field_72307_f.field_72448_b)) * 2.0);
                if (result.field_178784_b.func_176740_k() == EnumFacing.Axis.Y) {
                    half = -1;
                }
                newProfile = new LockProfile(result.field_178784_b.func_176734_d(), half);
            } else {
                Vec3d look = mc.field_71439_g.func_70040_Z();
                newProfile = new LockProfile(EnumFacing.func_176737_a((float)((float)look.field_72450_a), (float)((float)look.field_72448_b), (float)((float)look.field_72449_c)), -1);
            }
            this.clientProfile = this.clientProfile != null && this.clientProfile.equals(newProfile) ? null : newProfile;
            NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageSetLockProfile(this.clientProfile));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onHUDRender(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && this.clientProfile != null) {
            Minecraft mc = Minecraft.func_71410_x();
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            mc.field_71446_o.func_110577_a(LibMisc.GENERAL_ICONS_RESOURCE);
            int x = event.getResolution().func_78326_a() / 2 + 20;
            int y = event.getResolution().func_78328_b() / 2 - 8;
            GuiScreen.func_146110_a((int)x, (int)y, (float)(this.clientProfile.facing.ordinal() * 16), (float)32.0f, (int)16, (int)16, (float)256.0f, (float)256.0f);
            if (this.clientProfile.half > -1) {
                GuiScreen.func_146110_a((int)(x + 16), (int)y, (float)(this.clientProfile.half * 16), (float)48.0f, (int)16, (int)16, (float)256.0f, (float)256.0f);
            }
            GlStateManager.func_179121_F();
        }
    }

    public static void setProfile(EntityPlayer player, LockProfile profile) {
        String name = player.func_70005_c_();
        if (profile == null) {
            lockProfiles.remove(name);
        } else {
            boolean locked = player.getEntityData().func_74767_n(TAG_LOCKED_ONCE);
            if (!locked) {
                TextComponentTranslation text = new TextComponentTranslation("quarkmisc.rotationLockBefore", new Object[0]);
                TextComponentKeybind keybind = new TextComponentKeybind("quark.keybind.lockBuilding");
                keybind.func_150256_b().func_150238_a(TextFormatting.AQUA);
                text.func_150257_a((ITextComponent)keybind);
                text.func_150257_a((ITextComponent)new TextComponentTranslation("quarkmisc.rotationLockAfter", new Object[0]));
                player.func_145747_a((ITextComponent)text);
                player.getEntityData().func_74757_a(TAG_LOCKED_ONCE, true);
            }
            lockProfiles.put(name, profile);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    public static class LockProfile {
        public final EnumFacing facing;
        public final int half;

        public LockProfile(EnumFacing facing, int half) {
            this.facing = facing;
            this.half = half;
        }

        public static LockProfile readProfile(ByteBuf buf) {
            boolean valid = buf.readBoolean();
            if (!valid) {
                return null;
            }
            int face = buf.readInt();
            int half = buf.readInt();
            return new LockProfile(EnumFacing.func_82600_a((int)face), half);
        }

        public static void writeProfile(LockProfile p, ByteBuf buf) {
            if (p == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                buf.writeInt(p.facing.func_176745_a());
                buf.writeInt(p.half);
            }
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof LockProfile)) {
                return false;
            }
            LockProfile otherProfile = (LockProfile)other;
            return otherProfile.facing == this.facing && otherProfile.half == this.half;
        }
    }
}

