/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.planetprogression.entities;

import com.mjr.planetprogression.client.sounds.SoundUpdaterSatelliteRocket;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.ICargoEntity;
import micdoodle8.mods.galacticraft.api.entity.IDockable;
import micdoodle8.mods.galacticraft.api.entity.IEntityNoisy;
import micdoodle8.mods.galacticraft.api.entity.ILandable;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockLandingPadFull;
import micdoodle8.mods.galacticraft.core.client.sounds.SoundUpdaterRocket;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.event.EventLandingPadRemoval;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketDynamic;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntitySatelliteAutoRocket
extends EntitySpaceshipBase
implements ILandable,
IInventoryDefaults,
IEntityNoisy,
IRocketType,
IInventory,
IDockable {
    private static Class<?> controllerClass = null;
    protected NonNullList<ItemStack> stacks;
    private IFuelDock landingPad;
    public EnumAutoLaunch autoLaunchSetting;
    public int autoLaunchCountdown;
    private BlockVec3 activeLaunchController;
    public String placedPlayerUUID;
    public String statusMessage;
    public String statusColour;
    public int statusMessageCooldown;
    public int lastStatusMessageCooldown;
    public boolean statusValid;
    protected double lastMotionY;
    protected double lastLastMotionY;
    private boolean waitForPlayer;
    protected ITickable rocketSoundUpdater;
    private boolean rocketSoundToStop = false;

    public EntitySatelliteAutoRocket(World world) {
        super(world);
        if (world != null && world.field_72995_K) {
            GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketDynamic((Entity)this));
        }
    }

    public EntitySatelliteAutoRocket(World world, double posX, double posY, double posZ) {
        this(world);
        this.func_70105_a(0.98f, 2.0f);
        this.func_70107_b(posX, posY, posZ);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = posX;
        this.field_70167_r = posY;
        this.field_70166_s = posZ;
    }

    public ICargoEntity.EnumCargoLoadingState addCargo(ItemStack stack, boolean doAdd) {
        ItemStack stackAt;
        int count = 0;
        for (count = 0; count < this.stacks.size() - 2; ++count) {
            stackAt = (ItemStack)this.stacks.get(count);
            if (stackAt.func_190926_b() || stackAt.func_77973_b() != stack.func_77973_b() || stackAt.func_77952_i() != stack.func_77952_i() || stackAt.func_190916_E() >= stackAt.func_77976_d()) continue;
            if (stackAt.func_190916_E() + stack.func_190916_E() <= stackAt.func_77976_d()) {
                if (doAdd) {
                    stackAt.func_190917_f(stack.func_190916_E());
                    this.func_70296_d();
                }
                return ICargoEntity.EnumCargoLoadingState.SUCCESS;
            }
            int origSize = stackAt.func_190916_E();
            int surplus = origSize + stack.func_190916_E() - stackAt.func_77976_d();
            if (doAdd) {
                stackAt.func_190920_e(stackAt.func_77976_d());
                this.func_70296_d();
            }
            stack.func_190920_e(surplus);
            if (this.addCargo(stack, doAdd) == ICargoEntity.EnumCargoLoadingState.SUCCESS) {
                return ICargoEntity.EnumCargoLoadingState.SUCCESS;
            }
            stackAt.func_190920_e(origSize);
            return ICargoEntity.EnumCargoLoadingState.FULL;
        }
        for (count = 0; count < this.stacks.size() - 2; ++count) {
            stackAt = (ItemStack)this.stacks.get(count);
            if (!stackAt.func_190926_b()) continue;
            if (doAdd) {
                this.stacks.set(count, (Object)stack);
                this.func_70296_d();
            }
            return ICargoEntity.EnumCargoLoadingState.SUCCESS;
        }
        return ICargoEntity.EnumCargoLoadingState.FULL;
    }

    public int addFuel(FluidStack liquid, boolean doFill) {
        return FluidUtil.fillWithGCFuel((FluidTank)this.fuelTank, (FluidStack)liquid, (boolean)doFill);
    }

    private void autoLaunch() {
        if (this.autoLaunchSetting != null) {
            TileEntity tile;
            if (this.activeLaunchController != null && controllerClass.isInstance(tile = this.activeLaunchController.getTileEntity((IBlockAccess)this.field_70170_p))) {
                Boolean autoLaunchEnabled = null;
                try {
                    autoLaunchEnabled = controllerClass.getField("launchEnabled").getBoolean(tile);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (autoLaunchEnabled != null && autoLaunchEnabled.booleanValue()) {
                    if (this.fuelTank.getFluidAmount() > this.fuelTank.getCapacity() * 2 / 5) {
                        this.ignite();
                    } else {
                        this.failMessageInsufficientFuel();
                    }
                } else {
                    this.failMessageLaunchController();
                }
            }
            this.autoLaunchSetting = null;
            return;
        }
        this.ignite();
    }

    public void cancelLaunch() {
        this.setLaunchPhase(EntitySpaceshipBase.EnumLaunchPhase.UNIGNITED);
        this.timeUntilLaunch = 0;
        if (!this.field_70170_p.field_72995_K && !this.func_184188_bt().isEmpty() && this.func_184188_bt().get(0) instanceof EntityPlayerMP) {
            ((Entity)this.func_184188_bt().get(0)).func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translate((String)"gui.rocket.warning.nogyroscope")));
        }
    }

    public boolean checkLaunchValidity() {
        this.statusMessageCooldown = 40;
        if (this.hasValidFuel()) {
            if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.UNIGNITED.ordinal() && !this.field_70170_p.field_72995_K) {
                this.statusMessage = I18n.func_74838_a((String)"gui.message.success.name");
                this.statusColour = "\u00a7a";
                return true;
            }
        } else {
            this.statusMessage = I18n.func_74838_a((String)"gui.message.not_enough.name") + "#" + I18n.func_74838_a((String)"gui.message.fuel.name");
            this.statusColour = "\u00a7c";
            return false;
        }
        return false;
    }

    public void decodePacketdata(ByteBuf buffer) {
        if (!this.field_70170_p.field_72995_K) {
            double clientPosY = buffer.readDouble();
            if (clientPosY != Double.NaN && this.hasValidFuel()) {
                if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
                    if (clientPosY > this.field_70163_u) {
                        this.field_70181_x += (clientPosY - this.field_70163_u) / 40.0;
                    }
                } else if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal() && clientPosY < this.field_70163_u) {
                    this.field_70181_x += (clientPosY - this.field_70163_u) / 40.0;
                }
            }
            return;
        }
        int launchPhaseLast = this.launchPhase;
        super.decodePacketdata(buffer);
        this.fuelTank.setFluid(new FluidStack(GCFluids.fluidFuel, buffer.readInt()));
        boolean landingNew = buffer.readBoolean();
        if (landingNew && launchPhaseLast != EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal()) {
            this.rocketSoundUpdater = null;
        }
        double motX = buffer.readDouble() / 8000.0;
        double motY = buffer.readDouble() / 8000.0;
        double motZ = buffer.readDouble() / 8000.0;
        double lastMotY = buffer.readDouble() / 8000.0;
        double lastLastMotY = buffer.readDouble() / 8000.0;
        if (!this.hasValidFuel()) {
            this.field_70159_w = motX;
            this.field_70181_x = motY;
            this.field_70179_y = motZ;
            this.lastMotionY = lastMotY;
            this.lastLastMotionY = lastLastMotY;
        }
        if (this.stacks == null) {
            this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        }
        this.setWaitForPlayer(buffer.readBoolean());
        this.statusMessage = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.statusMessage = this.statusMessage.equals("") ? null : this.statusMessage;
        this.statusMessageCooldown = buffer.readInt();
        this.lastStatusMessageCooldown = buffer.readInt();
        this.statusValid = buffer.readBoolean();
        if (this.field_70170_p.field_72995_K) {
            int shouldBeMountedId = buffer.readInt();
            if (this.func_184188_bt().isEmpty()) {
                Entity e;
                if (shouldBeMountedId > -1 && (e = FMLClientHandler.instance().getWorldClient().func_73045_a(shouldBeMountedId)) != null) {
                    if (e.field_71093_bK != this.field_71093_bK) {
                        if (e instanceof EntityPlayer) {
                            e = WorldUtil.forceRespawnClient((int)this.field_71093_bK, (int)e.field_70170_p.func_175659_aa().func_151525_a(), (String)e.field_70170_p.func_72912_H().func_76067_t().func_77127_a(), (int)((EntityPlayerMP)e).field_71134_c.func_73081_b().func_77148_a());
                            e.func_184220_m((Entity)this);
                        }
                    } else {
                        e.func_184220_m((Entity)this);
                    }
                }
            } else if (((Entity)this.func_184188_bt().get(0)).func_145782_y() != shouldBeMountedId) {
                if (shouldBeMountedId == -1) {
                    this.func_184226_ay();
                } else {
                    Entity e = FMLClientHandler.instance().getWorldClient().func_73045_a(shouldBeMountedId);
                    if (e != null) {
                        if (e.field_71093_bK != this.field_71093_bK) {
                            if (e instanceof EntityPlayer) {
                                e = WorldUtil.forceRespawnClient((int)this.field_71093_bK, (int)e.field_70170_p.func_175659_aa().func_151525_a(), (String)e.field_70170_p.func_72912_H().func_76067_t().func_77127_a(), (int)((EntityPlayerMP)e).field_71134_c.func_73081_b().func_77148_a());
                                e.func_184220_m((Entity)this);
                            }
                        } else {
                            e.func_184220_m((Entity)this);
                        }
                    }
                }
            }
        }
        this.statusColour = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        if (this.statusColour.equals("")) {
            this.statusColour = null;
        }
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.stacks, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public void failMessageInsufficientFuel() {
        if (!this.field_70170_p.field_72995_K && !this.func_184188_bt().isEmpty() && this.func_184188_bt().get(0) instanceof EntityPlayerMP) {
            ((EntityPlayerMP)this.func_184188_bt().get(0)).func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translate((String)"gui.rocket.warning.fuelinsufficient")));
        }
    }

    public void failMessageLaunchController() {
        if (!this.field_70170_p.field_72995_K && !this.func_184188_bt().isEmpty() && this.func_184188_bt().get(0) instanceof EntityPlayerMP) {
            ((EntityPlayerMP)this.func_184188_bt().get(0)).func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translate((String)"gui.rocket.warning.launchcontroller")));
        }
    }

    protected void failRocket() {
        this.stopRocketSound();
        if (this.shouldCancelExplosion()) {
            for (int i = -3; i <= 3; ++i) {
                BlockPos pos = new BlockPos((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u + (double)i), (int)Math.floor(this.field_70161_v));
                if (this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal() || !(this.field_70170_p.func_175625_s(pos) instanceof IFuelDock) || !(this.field_70163_u < 5.0)) continue;
                for (int x = MathHelper.func_76128_c((double)this.field_70165_t) - 1; x <= MathHelper.func_76128_c((double)this.field_70165_t) + 1; ++x) {
                    for (int y = MathHelper.func_76128_c((double)(this.field_70163_u - 3.0)); y <= MathHelper.func_76128_c((double)this.field_70163_u) + 1; ++y) {
                        for (int z = MathHelper.func_76128_c((double)this.field_70161_v) - 1; z <= MathHelper.func_76128_c((double)this.field_70161_v) + 1; ++z) {
                            BlockPos pos1 = new BlockPos(x, y, z);
                            TileEntity tile = this.field_70170_p.func_175625_s(pos1);
                            if (!(tile instanceof IFuelDock)) continue;
                            this.landEntity(pos1);
                            return;
                        }
                    }
                }
            }
        }
        if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
            super.failRocket();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public List<ItemStack> getItemsDropped(List<ItemStack> droppedItemList) {
        if (this.stacks != null) {
            for (ItemStack item : this.stacks) {
                if (item == null || item.func_190926_b()) continue;
                droppedItemList.add(item);
            }
        }
        return droppedItemList;
    }

    public IFuelDock getLandingPad() {
        return this.landingPad;
    }

    public int getMaxFuel() {
        return this.fuelTank.getCapacity();
    }

    public void getNetworkedData(ArrayList<Object> list) {
        if (this.field_70170_p.field_72995_K) {
            if (this.func_184188_bt().contains(FMLClientHandler.instance().getClientPlayerEntity()) && this.hasValidFuel()) {
                list.add(this.field_70163_u);
            } else {
                list.add(Double.NaN);
            }
        }
        super.getNetworkedData(list);
        list.add(this.fuelTank.getFluidAmount());
        list.add(this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal());
        list.add(this.field_70159_w * 8000.0);
        list.add(this.field_70181_x * 8000.0);
        list.add(this.field_70179_y * 8000.0);
        list.add(this.lastMotionY * 8000.0);
        list.add(this.lastLastMotionY * 8000.0);
        list.add(this.getWaitForPlayer());
        list.add(this.statusMessage != null ? this.statusMessage : "");
        list.add(this.statusMessageCooldown);
        list.add(this.lastStatusMessageCooldown);
        list.add(this.statusValid);
        if (!this.field_70170_p.field_72995_K) {
            list.add(this.func_184188_bt().isEmpty() ? -1 : ((Entity)this.func_184188_bt().get(0)).func_145782_y());
        }
        list.add(this.statusColour != null ? this.statusColour : "");
    }

    public int getScaledFuelLevel(int scale) {
        if (this.getFuelTankCapacity() <= 0) {
            return 0;
        }
        return this.fuelTank.getFluidAmount() * scale / this.getFuelTankCapacity() / ConfigManagerCore.rocketFuelFactor;
    }

    @SideOnly(value=Side.CLIENT)
    public ITickable getSoundUpdater() {
        return this.rocketSoundUpdater;
    }

    public ItemStack func_70301_a(int index) {
        if (this.stacks == null) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.stacks.get(index);
    }

    public boolean getWaitForPlayer() {
        return this.waitForPlayer;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean hasValidFuel() {
        return this.fuelTank.getFluidAmount() > 0;
    }

    public void ignite() {
        this.igniteWithResult();
    }

    public boolean igniteWithResult() {
        super.ignite();
        this.activeLaunchController = null;
        return true;
    }

    public boolean inFlight() {
        return this.getLaunched();
    }

    public boolean isDockValid(IFuelDock dock) {
        return dock instanceof TileEntityLandingPad;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        double d0 = this.field_70165_t - x;
        double d1 = this.field_70163_u - y;
        double d2 = this.field_70161_v - z;
        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
        return d3 < 262144.0;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public boolean isPlayerRocket() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return !this.field_70128_L && entityplayer.func_70068_e((Entity)this) <= 64.0;
    }

    public void landEntity(BlockPos pos) {
        IFuelDock dock;
        TileEntity tile = this.field_70170_p.func_175625_s(pos);
        if (tile instanceof IFuelDock && this.isDockValid(dock = (IFuelDock)tile)) {
            if (!this.field_70170_p.field_72995_K) {
                if (dock.getDockedEntity() instanceof EntitySpaceshipBase && dock.getDockedEntity() != this) {
                    ((EntitySpaceshipBase)dock.getDockedEntity()).dropShipAsItem();
                    ((EntitySpaceshipBase)dock.getDockedEntity()).func_70106_y();
                }
                this.setPad(dock);
            }
            this.onRocketLand(pos);
        }
    }

    public void func_70296_d() {
    }

    public void onLaunch() {
        if (this.field_70170_p.field_73011_w.getDimension() != GalacticraftCore.planetOverworld.getDimensionID() && !(this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider)) {
            if (ConfigManagerCore.disableRocketLaunchAllNonGC) {
                this.cancelLaunch();
                return;
            }
            for (int i = ConfigManagerCore.disableRocketLaunchDimensions.length - 1; i >= 0; --i) {
                if (ConfigManagerCore.disableRocketLaunchDimensions[i] != this.field_70170_p.field_73011_w.getDimension()) continue;
                this.cancelLaunch();
                return;
            }
        }
        super.onLaunch();
        if (!this.field_70170_p.field_72995_K) {
            GCPlayerStats stats = null;
            if (!this.func_184188_bt().isEmpty()) {
                for (Entity player : this.func_184188_bt()) {
                    if (!(player instanceof EntityPlayerMP)) continue;
                    stats = GCPlayerStats.get((Entity)player);
                    stats.setLaunchpadStack(null);
                    if (this.field_70170_p.field_73011_w instanceof IOrbitDimension) continue;
                    stats.setCoordsTeleportedFromX(player.field_70165_t);
                    stats.setCoordsTeleportedFromZ(player.field_70161_v);
                }
                Entity playerMain = (Entity)this.func_184188_bt().get(0);
                if (playerMain instanceof EntityPlayerMP) {
                    stats = GCPlayerStats.get((Entity)playerMain);
                }
            }
            int amountRemoved = 0;
            block2: for (int x = MathHelper.func_76128_c((double)this.field_70165_t) - 1; x <= MathHelper.func_76128_c((double)this.field_70165_t) + 1; ++x) {
                for (int y = MathHelper.func_76128_c((double)this.field_70163_u) - 3; y <= MathHelper.func_76128_c((double)this.field_70163_u) + 1; ++y) {
                    for (int z = MathHelper.func_76128_c((double)this.field_70161_v) - 1; z <= MathHelper.func_76128_c((double)this.field_70161_v) + 1; ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        Block block = this.field_70170_p.func_180495_p(pos).func_177230_c();
                        if (block == null || !(block instanceof BlockLandingPadFull) || amountRemoved >= 9) continue;
                        EventLandingPadRemoval event = new EventLandingPadRemoval(this.field_70170_p, pos);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (!event.allow) break block2;
                        this.field_70170_p.func_175698_g(pos);
                        amountRemoved = 9;
                        break block2;
                    }
                }
            }
            if (stats != null && amountRemoved == 9) {
                stats.setLaunchpadStack(new ItemStack(GCBlocks.landingPad, 9, 0));
            }
            this.func_184185_a(SoundEvents.field_187638_cR, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
    }

    public void onPadDestroyed() {
        if (!this.field_70128_L && this.launchPhase < EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
            this.dropShipAsItem();
            this.func_70106_y();
        }
    }

    protected void onRocketLand(BlockPos pos) {
        this.func_70080_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.4 + this.getOnPadYOffset(), (double)pos.func_177952_p() + 0.5, this.field_70177_z, 0.0f);
        this.stopRocketSound();
        this.rocketSoundUpdater = null;
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K && this.field_70175_ag && !CompatibilityManager.isCubicChunksLoaded) {
            Chunk chunk = this.field_70170_p.func_72964_e(this.field_70176_ah, this.field_70164_aj);
            int cx = MathHelper.func_76128_c((double)this.field_70165_t) >> 4;
            int cz = MathHelper.func_76128_c((double)this.field_70161_v) >> 4;
            if (chunk.func_177410_o() && this.field_70176_ah == cx && this.field_70164_aj == cz) {
                boolean thisfound = false;
                ClassInheritanceMultiMap mapEntities = chunk.func_177429_s()[this.field_70162_ai];
                for (Entity ent : mapEntities) {
                    if (ent != this) continue;
                    thisfound = true;
                    break;
                }
                if (!thisfound) {
                    chunk.func_76612_a((Entity)this);
                }
            }
        }
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.statusMessageCooldown > 0) {
                --this.statusMessageCooldown;
            }
            if (this.statusMessageCooldown == 0 && this.lastStatusMessageCooldown > 0 && this.statusValid) {
                this.autoLaunch();
            }
            if (this.autoLaunchCountdown > 0 && this.func_184188_bt().isEmpty() && this.fuelTank.getFluidAmount() == this.fuelTank.getCapacity() && --this.autoLaunchCountdown == 0) {
                this.autoLaunch();
            }
            if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
                this.setPad(null);
            } else if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.UNIGNITED.ordinal() && this.landingPad != null && this.ticks % 17L == 0L) {
                this.updateControllerSettings(this.landingPad);
            }
            this.lastStatusMessageCooldown = this.statusMessageCooldown;
        }
        if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal()) {
            if (this.rocketSoundUpdater != null) {
                this.rocketSoundUpdater.func_73660_a();
                this.rocketSoundToStop = true;
            }
        } else if (this.rocketSoundToStop) {
            this.stopRocketSound();
            this.rocketSoundUpdater = null;
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("fuelTank")) {
            this.fuelTank.readFromNBT(nbt.func_74775_l("fuelTank"));
        }
        if (this.func_70302_i_() > 0) {
            this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.stacks);
        }
        this.setWaitForPlayer(nbt.func_74767_n("WaitingForPlayer"));
        int autoLaunchValue = nbt.func_74762_e("AutoLaunchSetting");
        this.autoLaunchSetting = autoLaunchValue == -1 ? null : EnumAutoLaunch.values()[autoLaunchValue];
        this.autoLaunchCountdown = nbt.func_74762_e("TimeUntilAutoLaunch");
        this.activeLaunchController = BlockVec3.readFromNBT((NBTTagCompound)nbt, (String)"ALCat");
    }

    public ICargoEntity.RemovalResult removeCargo(boolean doRemove) {
        for (int i = 0; i < this.stacks.size() - 2; ++i) {
            ItemStack stackAt = (ItemStack)this.stacks.get(i);
            if (stackAt.func_190926_b()) continue;
            ItemStack resultStack = stackAt.func_77946_l();
            resultStack.func_190920_e(1);
            if (doRemove) {
                stackAt.func_190918_g(1);
            }
            if (doRemove) {
                this.func_70296_d();
            }
            return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.SUCCESS, resultStack);
        }
        return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.EMPTY, ItemStack.field_190927_a);
    }

    public FluidStack removeFuel(int amount) {
        return this.fuelTank.drain(amount * ConfigManagerCore.rocketFuelFactor, true);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.stacks, (int)index);
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.rocketSoundUpdater != null) {
            this.rocketSoundUpdater.func_73660_a();
        }
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public void setPad(IFuelDock pad) {
        this.landingPad = pad;
        if (pad != null) {
            pad.dockEntity((IDockable)this);
            if (this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal()) {
                this.setLaunchPhase(EntitySpaceshipBase.EnumLaunchPhase.UNIGNITED);
                this.updateControllerSettings(pad);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ISound setSoundUpdater(EntityPlayerSP player) {
        this.rocketSoundUpdater = new SoundUpdaterSatelliteRocket(player, this);
        return (ISound)this.rocketSoundUpdater;
    }

    public void setWaitForPlayer(boolean waitForPlayer) {
        this.waitForPlayer = waitForPlayer;
    }

    protected boolean shouldCancelExplosion() {
        return this.hasValidFuel();
    }

    protected boolean shouldMoveClientSide() {
        return true;
    }

    public void stopRocketSound() {
        if (this.rocketSoundUpdater != null) {
            ((SoundUpdaterRocket)this.rocketSoundUpdater).stopRocketSound();
        }
        this.rocketSoundToStop = false;
    }

    public void updateControllerSettings(IFuelDock dock) {
        HashSet connectedTiles = dock.getConnectedTiles();
        try {
            block8: for (ILandingPadAttachable updatedTile : connectedTiles) {
                if (!controllerClass.isInstance(updatedTile)) continue;
                this.activeLaunchController = new BlockVec3((TileEntity)updatedTile);
                if (controllerClass.getField("launchEnabled").getBoolean(updatedTile)) {
                    this.autoLaunchSetting = EnumAutoLaunch.values()[controllerClass.getField("launchDropdownSelection").getInt(updatedTile)];
                    switch (this.autoLaunchSetting) {
                        case INSTANT: {
                            if (this.autoLaunchCountdown > 0 && this.autoLaunchCountdown <= 12) continue block8;
                            this.autoLaunchCountdown = 12;
                            continue block8;
                        }
                        case TIME_10_SECONDS: {
                            if (this.autoLaunchCountdown > 0 && this.autoLaunchCountdown <= 200) continue block8;
                            this.autoLaunchCountdown = 200;
                            continue block8;
                        }
                        case TIME_30_SECONDS: {
                            if (this.autoLaunchCountdown > 0 && this.autoLaunchCountdown <= 600) continue block8;
                            this.autoLaunchCountdown = 600;
                            continue block8;
                        }
                        case TIME_1_MINUTE: {
                            if (this.autoLaunchCountdown > 0 && this.autoLaunchCountdown <= 1200) continue block8;
                            this.autoLaunchCountdown = 1200;
                            continue block8;
                        }
                    }
                    continue;
                }
                this.autoLaunchSetting = null;
                this.autoLaunchCountdown = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.fuelTank.getFluid() != null) {
            nbt.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        }
        if (this.func_70302_i_() > 0) {
            ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.stacks);
        }
        nbt.func_74757_a("WaitingForPlayer", this.getWaitForPlayer());
        nbt.func_74757_a("Landing", this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal());
        nbt.func_74768_a("AutoLaunchSetting", this.autoLaunchSetting != null ? this.autoLaunchSetting.getIndex() : -1);
        nbt.func_74768_a("TimeUntilAutoLaunch", this.autoLaunchCountdown);
        if (this.activeLaunchController != null) {
            this.activeLaunchController.writeToNBT(nbt, "ALCat");
        }
    }

    static {
        try {
            controllerClass = Class.forName("com.mjr.planetprogression.tileEntities.TileEntitySatelliteRocketLauncher");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static enum EnumAutoLaunch {
        INSTANT(0, "instant"),
        TIME_10_SECONDS(1, "ten_sec"),
        TIME_30_SECONDS(3, "thirty_sec"),
        TIME_1_MINUTE(4, "one_min"),
        REDSTONE_SIGNAL(5, "redstone_sig");

        private final int index;
        private String title;

        private EnumAutoLaunch(int index, String title) {
            this.index = index;
            this.title = title;
        }

        public int getIndex() {
            return this.index;
        }

        public String getTitle() {
            return GCCoreUtil.translate((String)("gui.message." + this.title + ".name"));
        }
    }
}

