/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.api.slot;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import mcmultipart.api.slot.EnumSlotAccess;
import mcmultipart.api.slot.IPartSlot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public enum EnumEdgeSlot implements IPartSlot,
IPartSlot.IEdgeSlot
{
    EDGE_XNN(EnumFacing.Axis.X, EnumFacing.DOWN, EnumFacing.NORTH),
    EDGE_XNP(EnumFacing.Axis.X, EnumFacing.DOWN, EnumFacing.SOUTH),
    EDGE_XPN(EnumFacing.Axis.X, EnumFacing.UP, EnumFacing.NORTH),
    EDGE_XPP(EnumFacing.Axis.X, EnumFacing.UP, EnumFacing.SOUTH),
    EDGE_NYN(EnumFacing.Axis.Y, EnumFacing.WEST, EnumFacing.NORTH),
    EDGE_NYP(EnumFacing.Axis.Y, EnumFacing.WEST, EnumFacing.SOUTH),
    EDGE_PYN(EnumFacing.Axis.Y, EnumFacing.EAST, EnumFacing.NORTH),
    EDGE_PYP(EnumFacing.Axis.Y, EnumFacing.EAST, EnumFacing.SOUTH),
    EDGE_NNZ(EnumFacing.Axis.Z, EnumFacing.WEST, EnumFacing.DOWN),
    EDGE_NPZ(EnumFacing.Axis.Z, EnumFacing.WEST, EnumFacing.UP),
    EDGE_PNZ(EnumFacing.Axis.Z, EnumFacing.EAST, EnumFacing.DOWN),
    EDGE_PPZ(EnumFacing.Axis.Z, EnumFacing.EAST, EnumFacing.UP);

    public static final EnumEdgeSlot[] VALUES;
    private static final Table<EnumFacing, EnumFacing, EnumEdgeSlot> LOOKUP;
    private final ResourceLocation name = new ResourceLocation("mcmultipart", this.name().toLowerCase());
    private final EnumFacing.Axis axis;
    private final EnumFacing face1;
    private final EnumFacing face2;

    private EnumEdgeSlot(EnumFacing.Axis axis, EnumFacing face1, EnumFacing face2) {
        this.axis = axis;
        this.face1 = face1;
        this.face2 = face2;
    }

    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public EnumFacing.Axis getAxis() {
        return this.axis;
    }

    public EnumFacing getFace1() {
        return this.face1;
    }

    public EnumFacing getFace2() {
        return this.face2;
    }

    @Override
    public EnumSlotAccess getFaceAccess(EnumFacing face) {
        return face == this.getFace1() || face == this.getFace2() || face.func_176740_k() == this.getAxis() ? EnumSlotAccess.MERGE : EnumSlotAccess.NONE;
    }

    @Override
    public int getFaceAccessPriority(EnumFacing face) {
        return 200;
    }

    @Override
    public EnumSlotAccess getEdgeAccess(EnumEdgeSlot edge, EnumFacing face) {
        return edge == this && (face == this.getFace1() || face == this.getFace2()) ? EnumSlotAccess.OVERRIDE : EnumSlotAccess.NONE;
    }

    @Override
    public int getEdgeAccessPriority(EnumEdgeSlot edge, EnumFacing face) {
        return 300;
    }

    public static EnumEdgeSlot fromFaces(EnumFacing face1, EnumFacing face2) {
        if (LOOKUP.isEmpty()) {
            for (EnumEdgeSlot slot : VALUES) {
                boolean swap = slot.face1.ordinal() < slot.face2.ordinal();
                LOOKUP.put((Object)(swap ? slot.face1 : slot.face2), (Object)(swap ? slot.face2 : slot.face1), (Object)slot);
            }
        }
        boolean swap = face1.ordinal() < face2.ordinal();
        return (EnumEdgeSlot)LOOKUP.get((Object)(swap ? face1 : face2), (Object)(swap ? face2 : face1));
    }

    static {
        VALUES = EnumEdgeSlot.values();
        LOOKUP = HashBasedTable.create();
    }
}

