/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.api.multipart;

import mcmultipart.api.container.IPartInfo;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public interface IMultipartTile {
    public static IMultipartTile wrap(final TileEntity tile) {
        return new IMultipartTile(){

            @Override
            public TileEntity getTileEntity() {
                return tile;
            }
        };
    }

    default public TileEntity getTileEntity() {
        if (!(this instanceof TileEntity)) {
            throw new IllegalStateException("This multipart tile isn't a TileEntity. Override IMultipartTile#getTileEntity()!");
        }
        return (TileEntity)this;
    }

    default public boolean isTickable() {
        return this.getTickable() != null;
    }

    default public ITickable getTickable() {
        return this.getTileEntity() instanceof ITickable ? (ITickable)this.getTileEntity() : null;
    }

    default public void setPartInfo(IPartInfo info) {
    }

    default public World getPartWorld() {
        return this.getTileEntity().func_145831_w();
    }

    default public void setPartWorld(World world) {
        this.getTileEntity().func_145834_a(world);
    }

    default public boolean hasPartWorld() {
        return this.getTileEntity().func_145830_o();
    }

    default public BlockPos getPartPos() {
        return this.getTileEntity().func_174877_v();
    }

    default public void setPartPos(BlockPos pos) {
        this.getTileEntity().func_174878_a(pos);
    }

    default public void readPartFromNBT(NBTTagCompound compound) {
        this.getTileEntity().func_145839_a(compound);
    }

    default public NBTTagCompound writePartToNBT(NBTTagCompound compound) {
        return this.getTileEntity().func_189515_b(compound);
    }

    default public void markPartDirty() {
        this.getTileEntity().func_70296_d();
    }

    default public double getMaxPartRenderDistanceSquared() {
        return this.getTileEntity().func_145833_n();
    }

    default public boolean isPartInvalid() {
        return this.getTileEntity().func_145837_r();
    }

    default public void invalidatePart() {
        this.getTileEntity().func_145843_s();
    }

    default public void validatePart() {
        this.getTileEntity().func_145829_t();
    }

    default public void updatePartContainerInfo() {
        this.getTileEntity().func_145836_u();
    }

    default public void rotatePart(Rotation rotation) {
        this.getTileEntity().func_189667_a(rotation);
    }

    default public void mirrorPart(Mirror mirror) {
        this.getTileEntity().func_189668_a(mirror);
    }

    default public SPacketUpdateTileEntity getPartUpdatePacket() {
        return this.getTileEntity().func_189518_D_();
    }

    default public void onPartDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.getTileEntity().onDataPacket(net, pkt);
    }

    default public NBTTagCompound getPartUpdateTag() {
        return this.getTileEntity().func_189517_E_();
    }

    default public void handlePartUpdateTag(NBTTagCompound tag) {
        this.getTileEntity().handleUpdateTag(tag);
    }

    default public void onPartChunkUnload() {
        this.getTileEntity().onChunkUnload();
    }

    default public boolean shouldRefreshPart(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return this.getTileEntity().shouldRefresh(world, pos, oldState, newState);
    }

    default public boolean shouldRenderPartInPass(int pass) {
        return this.getTileEntity().shouldRenderInPass(pass);
    }

    default public AxisAlignedBB getPartRenderBoundingBox() {
        return this.getTileEntity().getRenderBoundingBox();
    }

    default public boolean canPartRenderBreaking() {
        return this.getTileEntity().canRenderBreaking();
    }

    default public void onPartLoad() {
        this.getTileEntity().onLoad();
    }

    default public boolean hasFastPartRenderer() {
        return this.getTileEntity().hasFastRenderer();
    }

    default public boolean hasPartCapability(Capability<?> capability, EnumFacing facing) {
        return this.getTileEntity().hasCapability(capability, facing);
    }

    default public <T> T getPartCapability(Capability<T> capability, EnumFacing facing) {
        return (T)this.getTileEntity().getCapability(capability, facing);
    }

    default public boolean onlyOpsCanSetPartNbt() {
        return this.getTileEntity().func_183000_F();
    }
}

