/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.laggoggles.server;

import com.github.terminatornl.laggoggles.Main;
import com.github.terminatornl.laggoggles.util.Perms;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

@Config(modid="laggoggles", name="LagGoggles-server")
public class ServerConfig {
    @Config.Comment(value={"What's the permission level available to non-operators (Normal players)?\nPlease note that this ONLY works on dedicated servers. If you're playing singleplayer or LAN, the FULL permission is used.\nAvailable permissions in ascending order are:\n   'NONE'  No permissions are granted, all functionality is denied.\n   'GET'   Allow getting the latest scan result, this will be stripped down to the player's surroundings\n   'START' Allow starting the profiler\n   'FULL'  All permissions are granted, teleporting to entities, blocks"})
    public static Perms.Permission NON_OP_PERMISSION_LEVEL = Perms.Permission.START;
    @Config.Comment(value={"Allow normal users to see event subscribers?"})
    public static boolean ALLOW_NON_OPS_TO_SEE_EVENT_SUBSCRIBERS = false;
    @Config.Comment(value={"If normal users can start the profiler, what is the maximum time in seconds?"})
    public static int NON_OPS_MAX_PROFILE_TIME = 20;
    @Config.Comment(value={"If normal users can start the profiler, what is the cool-down between requests in seconds?"})
    public static int NON_OPS_PROFILE_COOL_DOWN_SECONDS = 120;
    @Config.Comment(value={"What is the maximum HORIZONTAL range in blocks normal users can get results for?"})
    public static double NON_OPS_MAX_HORIZONTAL_RANGE = 50.0;
    @Config.Comment(value={"What is the maximum VERTICAL range in blocks normal users can get results for?"})
    public static double NON_OPS_MAX_VERTICAL_RANGE = 20.0;
    @Config.Comment(value={"From where should we range-limit blocks vertically for normal users?\nThis will override the MAX_VERTICAL_RANGE when the block is above this Y level"})
    public static int NON_OPS_WHITELIST_HEIGHT_ABOVE = 64;
    @Config.Comment(value={"How often can normal users request the latest scan result in seconds?"})
    public static int NON_OPS_REQUEST_LAST_SCAN_DATA_TIMEOUT = 30;

    @Mod.EventBusSubscriber
    public static class ConfigurationHolder {
        private static final MethodHandle CONFIGS_GETTER = ConfigurationHolder.findFieldGetter(ConfigManager.class, "CONFIGS");
        private static Configuration configuration;

        public static MethodHandle findFieldGetter(Class<?> clazz, String ... fieldNames) {
            Field field = ReflectionHelper.findField(clazz, (String[])fieldNames);
            try {
                return MethodHandles.lookup().unreflectGetter(field);
            }
            catch (IllegalAccessException e) {
                throw new ReflectionHelper.UnableToAccessFieldException(fieldNames, (Exception)e);
            }
        }

        public static Configuration getConfiguration() {
            if (configuration == null) {
                try {
                    String fileName = "LagGoggles-server.cfg";
                    Map configsMap = CONFIGS_GETTER.invokeExact();
                    Optional<Map.Entry> entryOptional = configsMap.entrySet().stream().filter(entry -> "LagGoggles-server.cfg".equals(new File((String)entry.getKey()).getName())).findFirst();
                    if (entryOptional.isPresent()) {
                        configuration = (Configuration)entryOptional.get().getValue();
                    }
                }
                catch (Throwable e) {
                    Main.LOGGER.error("Failed to get Configuration instance", e);
                }
            }
            return configuration;
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("laggoggles")) {
                ConfigManager.load((String)"laggoggles", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

