/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.advancement.criterion;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.cyclops.cyclopscore.advancement.criterion.BaseCriterionTrigger;
import org.cyclops.cyclopscore.advancement.criterion.ICriterionInstanceTestable;
import org.cyclops.integrateddynamics.api.advancement.criterion.VariableFacadePredicate;
import org.cyclops.integrateddynamics.core.logicprogrammer.event.LogicProgrammerVariableFacadeCreatedEvent;

public class VariableCreatedTrigger
extends BaseCriterionTrigger<LogicProgrammerVariableFacadeCreatedEvent, Instance> {
    public VariableCreatedTrigger() {
        super(new ResourceLocation("integrateddynamics", "variable_created"));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        JsonElement blockElement = json.get("block");
        Block block = null;
        if (blockElement != null && !blockElement.isJsonNull() && (block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(json.get("block").getAsString()))) == null) {
            throw new JsonSyntaxException("No block found with name: " + json.get("block").getAsString());
        }
        return new Instance(this.func_192163_a(), block, VariableFacadePredicate.deserialize(json.get("variable_facade")));
    }

    @SubscribeEvent
    public void onEvent(LogicProgrammerVariableFacadeCreatedEvent event) {
        if (event.getPlayer() != null && event.getPlayer() instanceof EntityPlayerMP) {
            this.trigger((EntityPlayerMP)event.getPlayer(), (Object)event);
        }
    }

    public static class Instance
    extends AbstractCriterionInstance
    implements ICriterionInstanceTestable<LogicProgrammerVariableFacadeCreatedEvent> {
        private final Block block;
        private final VariableFacadePredicate variableFacadePredicate;

        public Instance(ResourceLocation criterionIn, @Nullable Block block, VariableFacadePredicate variableFacadePredicate) {
            super(criterionIn);
            this.block = block;
            this.variableFacadePredicate = variableFacadePredicate;
        }

        public boolean test(EntityPlayerMP player, LogicProgrammerVariableFacadeCreatedEvent event) {
            return (this.block == null || event.getBlock() == this.block) && this.variableFacadePredicate.test(event.getVariableFacade());
        }
    }
}

