/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.fluiddict;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FluidDictionary {
    public static final Logger log = LogManager.getLogger((String)"Fluid Dictionary");
    private static boolean hasInit = false;
    private static final Map<String, List<String>> idToFn = Maps.newHashMapWithExpectedSize((int)96);
    private static final Map<String, String> fnToId = Maps.newHashMapWithExpectedSize((int)96);
    private static final Map<String, NonNullList<FluidStack>> fnToStack = Maps.newHashMapWithExpectedSize((int)96);

    private static void initVanillaEntries() {
        if (!hasInit) {
            FluidDictionary.registerFluid(FluidRegistry.WATER, "water");
            FluidDictionary.registerFluid(FluidRegistry.LAVA, "lava");
            hasInit = true;
        }
    }

    public static void registerFluid(Fluid fluid, String fname) {
        FluidDictionary.registerFluid(fluid, fname, null);
    }

    public static void registerFluid(Fluid fluid, String fname, NBTTagCompound fluidTags) {
        FluidDictionary.registerFluid(new FluidStack(fluid, 1, fluidTags), fname);
    }

    public static void registerFluid(FluidStack fluid, String fname) {
        if (FluidDictionary.isEmpty(fluid)) {
            log.warn("Invalid registration attempt for a Fluid Dictionary fluid with name %s has occurred. The registration has been denied to prevent crashes. The mod responsible for the registration needs to correct this.", (Object)fname);
            return;
        }
        String id = FluidDictionary.getFluidId(fluid);
        FluidDictionary.getNamesByFluidId(id).add(fname);
        fnToId.put(fname, id);
        FluidDictionary.getFluidsByName(fname).add((Object)fluid);
        MinecraftForge.EVENT_BUS.post((Event)new FluidRegisterEvent(fname, fluid));
    }

    public static List<String> getNamesByFluidId(String id) {
        List<String> l = idToFn.get(id);
        if (l == null) {
            l = new ArrayList<String>();
            idToFn.put(id, l);
        }
        return l;
    }

    public static NonNullList<FluidStack> getFluidsByName(String fname) {
        NonNullList l = fnToStack.get(fname);
        if (l == null) {
            l = NonNullList.func_191196_a();
            fnToStack.put(fname, (NonNullList<FluidStack>)l);
        }
        return l;
    }

    public static String getFluidId(FluidStack stack) {
        if (FluidDictionary.isEmpty(stack)) {
            return "";
        }
        return FluidRegistry.getFluidName((FluidStack)stack) + "^" + stack.tag;
    }

    public static String[] getFluidNames() {
        return fnToId.keySet().toArray(new String[0]);
    }

    public static boolean isEmpty(FluidStack stack) {
        return stack == null || stack.amount < 1 || stack.getFluid() == null;
    }

    static {
        FluidDictionary.initVanillaEntries();
    }

    public static class FluidRegisterEvent
    extends Event {
        private final String Name;
        private final FluidStack Fluid;

        public FluidRegisterEvent(String name, @Nonnull FluidStack fluid) {
            this.Name = name;
            this.Fluid = fluid;
        }

        public String getName() {
            return this.Name;
        }

        @Nonnull
        public FluidStack getFluid() {
            return this.Fluid;
        }
    }
}

