/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.utils;

import com.zeitheron.hammercore.api.items.IRenderAwareItem;
import com.zeitheron.hammercore.client.render.item.IItemRender;
import com.zeitheron.hammercore.client.render.item.ItemRenderingHandler;
import com.zeitheron.hammercore.client.render.shader.GlShaderStack;
import com.zeitheron.hammercore.client.utils.IEnchantmentColorManager;
import com.zeitheron.hammercore.internal.items.ICustomEnchantColorItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemColorHelper {
    public static final int DEFAULT_GLINT_COLOR = -8372020;
    public static final Map<Item, List<IEnchantmentColorManager>> managers = new HashMap<Item, List<IEnchantmentColorManager>>();
    static ItemStack target;

    public static void addManager(IEnchantmentColorManager mgr, Iterable<Item> its) {
        for (Item it : its) {
            ItemColorHelper.addManager(it, mgr);
        }
    }

    public static void addManager(IEnchantmentColorManager mgr, Item ... its) {
        for (Item it : its) {
            ItemColorHelper.addManager(it, mgr);
        }
    }

    public static void addManager(Item it, IEnchantmentColorManager mgr) {
        List<IEnchantmentColorManager> mgrs = managers.get(it);
        if (mgrs == null) {
            mgrs = new ArrayList<IEnchantmentColorManager>();
            managers.put(it, mgrs);
        }
        mgrs.add(mgr);
    }

    public static void renderItemModelIntoGUIPre(ItemStack stack, int x, int y, IBakedModel bakedmodel) {
        GlShaderStack.glsPushShader();
        IRenderAwareItem bruh = IRenderAwareItem.get(stack);
        if (bruh != null) {
            bruh.preRenderInGUI(stack, x, y, bakedmodel);
        }
        TextureManager txmgr = Minecraft.func_71410_x().func_110434_K();
        GlStateManager.func_179094_E();
        txmgr.func_110577_a(TextureMap.field_110575_b);
        txmgr.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)x, (float)y, (float)450.0f);
        if (!stack.func_190926_b()) {
            for (IItemRender render : ItemRenderingHandler.INSTANCE.getRenderHooks(stack.func_77973_b())) {
                if (render == null) continue;
                GlStateManager.func_179094_E();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                render.renderItem(stack, bakedmodel, ItemCameraTransforms.TransformType.GUI);
                GlStateManager.func_179121_F();
            }
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        txmgr.func_110577_a(TextureMap.field_110575_b);
        txmgr.func_110581_b(TextureMap.field_110575_b).func_174935_a();
    }

    public static void renderItemModelIntoGUIPost(ItemStack stack, int x, int y, IBakedModel bakedmodel) {
        IRenderAwareItem bruh = IRenderAwareItem.get(stack);
        if (bruh != null) {
            bruh.postRenderInGUI(stack, x, y, bakedmodel);
        }
        GlShaderStack.glsPopShader();
    }

    public static void renderItemModel(ItemStack stack, IBakedModel bakedmodel, ItemCameraTransforms.TransformType transform) {
        if (!stack.func_190926_b()) {
            for (IItemRender render : ItemRenderingHandler.INSTANCE.getRenderHooks(stack.func_77973_b())) {
                if (render == null) continue;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179091_B();
                render.renderItem(stack, bakedmodel, transform);
                GlStateManager.func_179121_F();
            }
        }
    }

    public static void setTargetStackAndHandleRender(ItemStack stack) {
        target = stack;
        if (!stack.func_190926_b()) {
            for (IItemRender render : ItemRenderingHandler.INSTANCE.getRenderHooks(stack.func_77973_b())) {
                if (render == null) continue;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179091_B();
                render.renderItem(stack);
                GlStateManager.func_179121_F();
            }
        }
    }

    public static int getCustomColor(int prev) {
        if (!(target.func_77973_b() instanceof ICustomEnchantColorItem)) {
            try {
                Class<?> ColorRunes = Class.forName("vazkii.quark.misc.feature.ColorRunes");
                ColorRunes.getMethod("setTargetStack", ItemStack.class).invoke(null, target);
                int col = (Integer)ColorRunes.getDeclaredMethod("getColor", Integer.TYPE).invoke(null, -8372020);
                if (col != -8372020) {
                    return col;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return ItemColorHelper.getColorFromStack(target, prev);
    }

    public static int getColorFromStack(ItemStack stack, int prev) {
        int b;
        int g;
        int r;
        int t;
        NBTTagCompound nbt;
        int s;
        List<IEnchantmentColorManager> mgrs;
        if (stack.func_190926_b()) {
            return prev;
        }
        int retColor = prev;
        boolean truncate = true;
        if (stack.func_77973_b() instanceof ICustomEnchantColorItem) {
            int color = ((ICustomEnchantColorItem)stack.func_77973_b()).getEnchantEffectColor(stack);
            truncate = ((ICustomEnchantColorItem)stack.func_77973_b()).shouldTruncateColorBrightness(stack);
            retColor = 0xFF000000 | color;
        }
        if ((mgrs = managers.get(stack.func_77973_b())) != null && (s = mgrs.size()) > 0) {
            for (int i = 0; i < s; ++i) {
                IEnchantmentColorManager m = mgrs.get(i);
                if (m == null || !m.applies(stack)) continue;
                retColor = m.apply(stack, retColor);
            }
        }
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_150297_b("HCCustomEnch", 8)) {
            try {
                retColor = Integer.parseInt(nbt.func_74779_i("HCCustomEnch"), 16);
            }
            catch (Throwable i) {
                // empty catch block
            }
        }
        if (truncate && (t = (r = retColor >> 16 & 0xFF) + (g = retColor >> 8 & 0xFF) + (b = retColor & 0xFF)) > 396) {
            float mul = 396.0f / (float)t;
            r = (int)((float)r * mul);
            g = (int)((float)g * mul);
            b = (int)((float)b * mul);
            retColor = -16777216 + (r << 16) + (g << 8) + b;
        }
        return retColor;
    }
}

