/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting.table;

import com.blakebr0.extendedcrafting.config.ModConfig;
import com.blakebr0.extendedcrafting.crafting.table.ITieredRecipe;
import com.blakebr0.extendedcrafting.crafting.table.TableRecipeShaped;
import com.blakebr0.extendedcrafting.crafting.table.TableRecipeShapeless;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TableRecipeManager {
    private static final TableRecipeManager INSTANCE = new TableRecipeManager();
    private final List<ITieredRecipe> recipes = new ArrayList<ITieredRecipe>();

    public static TableRecipeManager getInstance() {
        return INSTANCE;
    }

    public void addShaped(ItemStack result, CraftingHelper.ShapedPrimer primer) {
        this.addShaped(0, result, primer.width, primer.height, (NonNullList<Ingredient>)primer.input);
    }

    public void addShaped(int tier, ItemStack result, CraftingHelper.ShapedPrimer primer) {
        this.addShaped(tier, result, primer.width, primer.height, (NonNullList<Ingredient>)primer.input);
    }

    public void addShaped(int tier, ItemStack result, int width, int height, NonNullList<Ingredient> recipe) {
        TableRecipeShaped craft = new TableRecipeShaped(tier, result, width, height, recipe);
        if (ModConfig.confTableEnabled) {
            this.recipes.add(craft);
        }
    }

    public void addShapeless(ItemStack result, NonNullList<Ingredient> ingredients) {
        this.addShapeless(0, result, ingredients);
    }

    public void addShapeless(int tier, ItemStack result, NonNullList<Ingredient> ingredients) {
        TableRecipeShapeless recipe = new TableRecipeShapeless(tier, result, ingredients);
        if (ModConfig.confTableEnabled) {
            this.recipes.add(recipe);
        }
    }

    public ItemStack findMatchingRecipe(InventoryCrafting grid, World world) {
        int i = 0;
        ItemStack stack = ItemStack.field_190927_a;
        ItemStack stack1 = ItemStack.field_190927_a;
        for (int j = 0; j < grid.func_70302_i_(); ++j) {
            ItemStack stack2 = grid.func_70301_a(j);
            if (stack2.func_190926_b()) continue;
            if (i == 0) {
                stack = stack2;
            }
            if (i == 1) {
                stack1 = stack2;
            }
            ++i;
        }
        Item item = stack.func_77973_b();
        if (i == 2 && item == stack1.func_77973_b() && stack.func_190916_E() == 1 && stack1.func_190916_E() == 1 && item.isRepairable()) {
            int k;
            int n;
            int l;
            int maxDamage = stack.func_77958_k();
            int i1 = maxDamage - (l = (n = maxDamage - stack.func_77952_i()) + (k = maxDamage - stack1.func_77952_i()) + maxDamage * 5 / 100);
            if (i1 < 0) {
                i1 = 0;
            }
            return new ItemStack(item, 1, i1);
        }
        for (IRecipe iRecipe : this.recipes) {
            if (!iRecipe.func_77569_a(grid, world)) continue;
            return iRecipe.func_77572_b(grid);
        }
        if (ModConfig.confTableUseRecipes && grid.func_174922_i() == 3 && grid.func_174923_h() == 3) {
            for (IRecipe iRecipe : ForgeRegistries.RECIPES.getValuesCollection()) {
                if (!iRecipe.func_77569_a(grid, world)) continue;
                return iRecipe.func_77572_b(grid);
            }
        }
        return ItemStack.field_190927_a;
    }

    public List<ITieredRecipe> getRecipes() {
        return this.recipes;
    }

    public void removeRecipes(ItemStack stack) {
        this.recipes.removeIf(recipe -> recipe != null && recipe.func_77571_b().func_77969_a(stack));
    }

    public List<IRecipe> getRecipes(int size) {
        ArrayList<IRecipe> recipes = new ArrayList<IRecipe>();
        for (IRecipe iRecipe : this.getRecipes()) {
            if (!iRecipe.func_194133_a(size, size)) continue;
            recipes.add(iRecipe);
        }
        return recipes;
    }

    public List<ITieredRecipe> getRecipesTiered(int tier) {
        ArrayList<ITieredRecipe> recipes = new ArrayList<ITieredRecipe>();
        for (ITieredRecipe r : this.getRecipes()) {
            if (r == null || r.getTier() != tier) continue;
            recipes.add(r);
        }
        return recipes;
    }

    public static NonNullList<ItemStack> getRemainingItems(InventoryCrafting grid, World world) {
        for (int j = 0; j < TableRecipeManager.getInstance().recipes.size(); ++j) {
            IRecipe recipe = TableRecipeManager.getInstance().recipes.get(j);
            if (!recipe.func_77569_a(grid, world)) continue;
            return recipe.func_179532_b(grid);
        }
        return CraftingManager.func_180303_b((InventoryCrafting)grid, (World)world);
    }
}

