/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.fluid;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.network.packet.UpdateWorldSharedTankClientCachePacket;

public class WorldSharedTankCache {
    public static final int INTERPOLATION_TICK_OFFSET = 10;
    private static WorldSharedTankCache _instance = null;
    private Map<String, FluidStack> tankCache = Maps.newHashMap();
    private Map<String, UpdateWorldSharedTankClientCachePacket> packetBuffer = Maps.newHashMap();
    private int tick = 0;

    private WorldSharedTankCache() {
    }

    public void reset() {
        this.tankCache = Maps.newHashMap();
        this.packetBuffer = Maps.newHashMap();
        this.tick = 0;
    }

    public static WorldSharedTankCache getInstance() {
        if (_instance == null) {
            _instance = new WorldSharedTankCache();
        }
        return _instance;
    }

    protected String getMapID(String tankID) {
        return tankID + (MinecraftHelpers.isClientSide() ? "C" : "S");
    }

    protected String removeMapID(String mapID) {
        return mapID.substring(0, mapID.length() - 1);
    }

    public synchronized FluidStack getTankContent(String tankID) {
        FluidStack stack = this.tankCache.get(this.getMapID(tankID));
        return stack == null ? null : stack.copy();
    }

    protected static boolean shouldRefreshFluid(FluidStack old, FluidStack newF) {
        return !MinecraftHelpers.isFluidAndAmountEqual((FluidStack)old, (FluidStack)newF);
    }

    public synchronized void setTankContent(String tankID, FluidStack fluidStack) {
        String key = this.getMapID(tankID);
        boolean shouldRefresh = WorldSharedTankCache.shouldRefreshFluid(this.tankCache.get(key), fluidStack);
        if (fluidStack == null || fluidStack.amount == 0) {
            this.tankCache.remove(key);
        } else if (shouldRefresh) {
            this.tankCache.put(key, fluidStack.copy());
        }
        if (!MinecraftHelpers.isClientSide() && shouldRefresh) {
            this.bufferPacket(tankID, new UpdateWorldSharedTankClientCachePacket(tankID, fluidStack));
        }
    }

    protected void bufferPacket(String tankID, UpdateWorldSharedTankClientCachePacket packet) {
        this.packetBuffer.put(tankID, packet);
    }

    public int getTickOffset() {
        return this.tick;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onTick(TickEvent event) {
        if (event.phase == TickEvent.Phase.START && (event.type == TickEvent.Type.CLIENT || event.type == TickEvent.Type.SERVER)) {
            ++this.tick;
            if (event.side == Side.SERVER && this.getTickOffset() > 10) {
                Iterator<Map.Entry<String, UpdateWorldSharedTankClientCachePacket>> it = this.packetBuffer.entrySet().iterator();
                while (it.hasNext()) {
                    EvilCraft._instance.getPacketHandler().sendToAll((PacketBase)it.next().getValue());
                    it.remove();
                }
                this.tick = 0;
            }
        }
    }

    @SubscribeEvent
    public void onLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!MinecraftHelpers.isClientSide()) {
            for (Map.Entry<String, FluidStack> entry : this.tankCache.entrySet()) {
                EvilCraft._instance.getPacketHandler().sendToPlayer((PacketBase)new UpdateWorldSharedTankClientCachePacket(this.removeMapID(entry.getKey()), entry.getValue()), (EntityPlayerMP)event.player);
            }
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (tag != null) {
            NBTTagList list = tag.func_150295_c("tankCache", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound subTag = list.func_150305_b(i);
                this.setTankContent(subTag.func_74779_i("key"), FluidStack.loadFluidStackFromNBT((NBTTagCompound)subTag.func_74775_l("value")));
            }
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<String, FluidStack> entry : this.tankCache.entrySet()) {
            NBTTagCompound subTag = new NBTTagCompound();
            subTag.func_74778_a("key", this.removeMapID(entry.getKey()));
            NBTTagCompound fluidTag = new NBTTagCompound();
            entry.getValue().writeToNBT(fluidTag);
            subTag.func_74782_a("value", (NBTBase)fluidTag);
            list.func_74742_a((NBTBase)subTag);
        }
        tag.func_74782_a("tankCache", (NBTBase)list);
    }
}

