/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.biomes.decorators;

import erebus.world.biomes.decorators.BiomeDecoratorBaseErebus;
import erebus.world.biomes.decorators.data.OreSettings;
import erebus.world.biomes.decorators.data.SurfaceType;
import erebus.world.feature.decoration.WorldGenAmberGround;
import erebus.world.feature.decoration.WorldGenAmberUmberstone;
import erebus.world.feature.decoration.WorldGenPonds;
import erebus.world.feature.decoration.WorldGenRottenAcacia;
import erebus.world.feature.decoration.WorldGenSavannahRock;
import erebus.world.feature.plant.WorldGenBamboo;
import erebus.world.feature.structure.WorldGenLocustShrine;
import erebus.world.feature.tree.WorldGenAsperTree;
import erebus.world.feature.tree.WorldGenBaobabTree;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BiomeDecoratorSubterraneanSavannah
extends BiomeDecoratorBaseErebus {
    private final WorldGenPonds genPonds = new WorldGenPonds();
    private final WorldGenBamboo genBamboo = new WorldGenBamboo(7, true);
    private final WorldGenSavannahRock genRocks = new WorldGenSavannahRock();
    private final WorldGenRottenAcacia genRottenAcacia = new WorldGenRottenAcacia();
    private final WorldGenAmberGround genAmberGround = new WorldGenAmberGround();
    private final WorldGenAmberUmberstone genAmberUmberstone = new WorldGenAmberUmberstone();
    private final WorldGenLocustShrine genLocustShrine = new WorldGenLocustShrine();
    private final WorldGenerator genTreeAcacia = new WorldGenSavannaTree(true);
    private final WorldGenerator genTreeAsper = new WorldGenAsperTree();
    private final WorldGenerator genTreeBaobab = new WorldGenBaobabTree();

    @Override
    public void populate() {
        if (this.rand.nextBoolean() && this.rand.nextBoolean()) {
            BlockPos pos;
            this.attempt = 0;
            while (this.attempt < 8) {
                this.xx = this.x + 16;
                this.yy = this.rand.nextInt(120);
                this.zz = this.z + 16;
                pos = new BlockPos(this.xx, this.yy, this.zz);
                if (this.checkSurface(SurfaceType.GRASS, pos)) {
                    this.genPonds.prepare((this.rand.nextDouble() + 0.75) * 1.2);
                    this.genPonds.func_180709_b(this.world, this.rand, pos.func_177984_a());
                }
                ++this.attempt;
            }
            if (this.rand.nextInt(3) != 0) {
                this.yy = 100;
                while (this.yy > 20) {
                    this.xx = this.x + this.offsetXZ();
                    this.zz = this.z + this.offsetXZ();
                    pos = new BlockPos(this.xx, this.yy, this.zz);
                    if (this.checkSurface(SurfaceType.GRASS, pos)) {
                        this.genBamboo.func_180709_b(this.world, this.rand, pos.func_177984_a());
                    }
                    --this.yy;
                }
            }
        }
    }

    @Override
    public void decorate() {
        BlockPos pos;
        this.xx = this.x + 16;
        this.yy = 16;
        this.zz = this.z + 16;
        if (this.rand.nextInt(12) == 0) {
            this.attempt = 0;
            while (this.attempt < 5 && !this.genAmberUmberstone.func_180709_b(this.world, this.rand, new BlockPos(this.x + this.offsetXZ(), this.rand.nextInt(120), this.z + this.offsetXZ()))) {
                ++this.attempt;
            }
        }
        if (this.rand.nextInt(24) == 0) {
            this.attempt = 0;
            while (this.attempt < 4 && !this.genAmberGround.func_180709_b(this.world, this.rand, new BlockPos(this.x + this.offsetXZ(), 10 + this.rand.nextInt(40), this.z + this.offsetXZ()))) {
                ++this.attempt;
            }
        }
        this.attempt = 0;
        while (this.attempt < 65) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 15 + this.rand.nextInt(90);
            this.zz = this.z + this.offsetXZ();
            pos = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.GRASS, pos)) {
                this.genTreeAcacia.func_180709_b(this.world, this.rand, pos.func_177984_a());
            }
            ++this.attempt;
        }
        if (this.rand.nextBoolean() && this.rand.nextBoolean()) {
            this.xx = this.x + this.offsetXZ();
            this.zz = this.z + this.offsetXZ();
            this.yy = 100;
            while (!(this.yy <= 20 || this.checkSurface(SurfaceType.GRASS, pos = new BlockPos(this.xx, this.yy, this.zz)) && this.genRocks.func_180709_b(this.world, this.rand, pos))) {
                --this.yy;
            }
        }
        this.attempt = 0;
        while (this.attempt < 10) {
            this.xx = this.x + this.offsetXZ();
            this.yy = this.rand.nextInt(120);
            this.zz = this.z + this.offsetXZ();
            pos = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.GRASS, pos)) {
                this.genTreeAsper.func_180709_b(this.world, this.rand, pos.func_177984_a());
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 20) {
            this.xx = this.x + this.rand.nextInt(5) + 12;
            this.yy = this.rand.nextInt(120);
            this.zz = this.z + this.rand.nextInt(5) + 12;
            pos = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.GRASS, pos) && this.checkSurface(SurfaceType.GRASS, pos.func_177965_g(2)) && this.checkSurface(SurfaceType.GRASS, pos.func_177985_f(2)) && this.checkSurface(SurfaceType.GRASS, pos.func_177964_d(2)) && this.checkSurface(SurfaceType.GRASS, pos.func_177970_e(2))) {
                this.genTreeBaobab.func_180709_b(this.world, this.rand, pos.func_177984_a());
            }
            ++this.attempt;
        }
        if (this.rand.nextBoolean() && this.rand.nextBoolean()) {
            this.xx = this.x + this.offsetXZ();
            this.zz = this.z + this.offsetXZ();
            this.yy = 100;
            while (!(this.yy <= 20 || this.checkSurface(SurfaceType.GRASS, pos = new BlockPos(this.xx, this.yy, this.zz)) && this.genLocustShrine.func_180709_b(this.world, this.rand, pos.func_177984_a()))) {
                --this.yy;
            }
        }
        this.attempt = 0;
        while (this.attempt < 28) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 15 + this.rand.nextInt(90);
            this.zz = this.z + this.offsetXZ();
            pos = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.GRASS, pos)) {
                // empty if block
            }
            this.genRottenAcacia.func_180709_b(this.world, this.rand, pos.func_177984_a());
            ++this.attempt;
        }
        IBlockState tallGrassState = Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS);
        this.attempt = 0;
        while (this.attempt < 35) {
            this.xx = this.x + this.offsetXZ();
            this.zz = this.z + this.offsetXZ();
            int n = this.yy = this.rand.nextInt(3) == 0 ? 40 + this.rand.nextInt(35) : 22;
            while (this.yy < 100) {
                BlockPos pos2 = new BlockPos(this.xx, this.yy, this.zz);
                if (this.checkSurface(SurfaceType.GRASS, pos2)) {
                    if (this.rand.nextInt(10) == 0 && this.world.func_175623_d(pos2.func_177981_b(2))) {
                        Blocks.field_150398_cm.func_176491_a(this.world, pos2.func_177984_a(), BlockDoublePlant.EnumPlantType.GRASS, 2);
                    } else if (this.world.func_175623_d(pos2.func_177984_a())) {
                        this.world.func_175656_a(pos2.func_177984_a(), tallGrassState);
                    }
                }
                this.yy += this.rand.nextBoolean() ? 2 : 1;
            }
            ++this.attempt;
        }
    }

    @Override
    protected void modifyOreGen(OreSettings oreGen, OreSettings.OreType oreType, boolean extraOres) {
        switch (oreType) {
            case GOLD: {
                oreGen.setChance(0.75f).setIterations(extraOres ? 1 : 2).setY(50, 126).generate(this.world, this.rand, this.x, this.z);
                oreGen.setChance(0.9f).setIterations(extraOres ? 1 : 2, extraOres ? 2 : 3).setY(25, 50).generate(this.world, this.rand, this.x, this.z);
                oreGen.setIterations(extraOres ? 2 : 3, extraOres ? 3 : 4).setY(5, 25);
                break;
            }
            case EMERALD: {
                oreGen.setChance(0.22f);
                break;
            }
            case DIAMOND: {
                oreGen.setChance(0.4f).setIterations(1, 2).setOreAmount(2).setY(5, 16);
                break;
            }
            case JADE: {
                oreGen.setChance(0.3f).setIterations(0, 3);
                break;
            }
            case PETRIFIED_WOOD: {
                oreGen.setChance(0.5f).setIterations(0, extraOres ? 2 : 3).setY(5, 64);
            }
        }
    }
}

