/*
 * Decompiled with CFR 0.152.
 */
package erebus.inventory;

import com.google.common.base.Objects;
import erebus.tileentity.TileEntityPetrifiedWoodChest;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class PetrifiedDoubleChestItemHandler
extends WeakReference<TileEntityPetrifiedWoodChest>
implements IItemHandlerModifiable {
    public static final PetrifiedDoubleChestItemHandler NO_ADJACENT_CHESTS_INSTANCE = new PetrifiedDoubleChestItemHandler(null, null, false);
    private final boolean mainChestIsUpper;
    private final TileEntityPetrifiedWoodChest mainChest;
    private final int hashCode;

    public PetrifiedDoubleChestItemHandler(@Nullable TileEntityPetrifiedWoodChest mainChest, @Nullable TileEntityPetrifiedWoodChest other, boolean mainChestIsUpper) {
        super(other);
        this.mainChest = mainChest;
        this.mainChestIsUpper = mainChestIsUpper;
        this.hashCode = Objects.hashCode((Object[])new Object[]{mainChestIsUpper ? mainChest : other}) * 31 + Objects.hashCode((Object[])new Object[]{!mainChestIsUpper ? mainChest : other});
    }

    @Nullable
    public static PetrifiedDoubleChestItemHandler get(TileEntityPetrifiedWoodChest chest) {
        World world = chest.func_145831_w();
        BlockPos pos = chest.func_174877_v();
        if (world == null || pos == null || !world.func_175667_e(pos)) {
            return null;
        }
        Block blockType = chest.func_145838_q();
        EnumFacing[] horizontals = EnumFacing.field_176754_o;
        for (int i = horizontals.length - 1; i >= 0; --i) {
            TileEntity otherTE;
            EnumFacing enumfacing = horizontals[i];
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            Block block = world.func_180495_p(blockpos).func_177230_c();
            if (block != blockType || !((otherTE = world.func_175625_s(blockpos)) instanceof TileEntityPetrifiedWoodChest)) continue;
            TileEntityPetrifiedWoodChest otherChest = (TileEntityPetrifiedWoodChest)otherTE;
            return new PetrifiedDoubleChestItemHandler(chest, otherChest, enumfacing != EnumFacing.WEST && enumfacing != EnumFacing.NORTH);
        }
        return NO_ADJACENT_CHESTS_INSTANCE;
    }

    @Nullable
    public TileEntityPetrifiedWoodChest getChest(boolean accessingUpper) {
        if (accessingUpper == this.mainChestIsUpper) {
            return this.mainChest;
        }
        return this.getOtherChest();
    }

    @Nullable
    private TileEntityPetrifiedWoodChest getOtherChest() {
        TileEntityPetrifiedWoodChest tileEntityChest = (TileEntityPetrifiedWoodChest)((Object)this.get());
        return tileEntityChest != null && !tileEntityChest.func_145837_r() ? tileEntityChest : null;
    }

    public int getSlots() {
        return 54;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        TileEntityPetrifiedWoodChest chest = this.getChest(accessingUpperChest);
        return chest != null ? chest.func_70301_a(targetSlot) : ItemStack.field_190927_a;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        IItemHandler singleHandler;
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        TileEntityPetrifiedWoodChest chest = this.getChest(accessingUpperChest);
        if (chest != null && (singleHandler = chest.getSingleChestHandler()) instanceof IItemHandlerModifiable) {
            ((IItemHandlerModifiable)singleHandler).setStackInSlot(targetSlot, stack);
        }
        if ((chest = this.getChest(!accessingUpperChest)) != null) {
            chest.func_70296_d();
        }
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        TileEntityPetrifiedWoodChest chest = this.getChest(accessingUpperChest);
        if (chest == null) {
            return stack;
        }
        int starting = stack.func_190916_E();
        ItemStack ret = chest.getSingleChestHandler().insertItem(targetSlot, stack, simulate);
        if (ret.func_190916_E() != starting && !simulate && (chest = this.getChest(!accessingUpperChest)) != null) {
            chest.func_70296_d();
        }
        return ret;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        TileEntityPetrifiedWoodChest chest = this.getChest(accessingUpperChest);
        if (chest == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = chest.getSingleChestHandler().extractItem(targetSlot, amount, simulate);
        if (!ret.func_190926_b() && !simulate && (chest = this.getChest(!accessingUpperChest)) != null) {
            chest.func_70296_d();
        }
        return ret;
    }

    public int getSlotLimit(int slot) {
        boolean accessingUpperChest = slot < 27;
        return this.getChest(accessingUpperChest).func_70297_j_();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PetrifiedDoubleChestItemHandler that = (PetrifiedDoubleChestItemHandler)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        TileEntityPetrifiedWoodChest otherChest = this.getOtherChest();
        if (this.mainChestIsUpper == that.mainChestIsUpper) {
            return Objects.equal((Object)((Object)this.mainChest), (Object)((Object)that.mainChest)) && Objects.equal((Object)((Object)otherChest), (Object)((Object)that.getOtherChest()));
        }
        return Objects.equal((Object)((Object)this.mainChest), (Object)((Object)that.getOtherChest())) && Objects.equal((Object)((Object)otherChest), (Object)((Object)that.mainChest));
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean needsRefresh() {
        if (this == NO_ADJACENT_CHESTS_INSTANCE) {
            return false;
        }
        TileEntityPetrifiedWoodChest tileEntityChest = (TileEntityPetrifiedWoodChest)((Object)this.get());
        return tileEntityChest == null || tileEntityChest.func_145837_r();
    }
}

