/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.Erebus;
import erebus.ModSounds;
import erebus.core.handler.configs.ConfigHandler;
import erebus.entity.EntityMoneySpider;
import erebus.entity.EntityWebSling;
import erebus.entity.ai.EntityAIErebusAttackMelee;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityLavaWebSpider
extends EntityMob {
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityLavaWebSpider.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityLavaWebSpider(World world) {
        super(world);
        this.func_70105_a(3.0f, 1.5f);
        this.func_184644_a(PathNodeType.LAVA, 8.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.field_70178_ae = true;
        this.field_70728_aV = 10;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AILavaWebSlingAttack(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIErebusAttackMelee((EntityCreature)this, 0.5, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 60.0 : 60.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 2.0 : 2.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public int func_70641_bl() {
        return 1;
    }

    public boolean func_70601_bi() {
        return this.func_130014_f_().func_72855_b(this.func_174813_aQ()) && this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && this.func_130014_f_().func_72875_a(this.func_174813_aQ(), Material.field_151587_i);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
        if (this.func_130014_f_().field_72995_K && this.func_130014_f_().func_72820_D() % 5L == 0L) {
            this.lavaParticles(this.func_130014_f_(), this.field_70165_t, this.field_70163_u + 1.3, this.field_70161_v, this.field_70146_Z);
        }
    }

    public void func_70636_d() {
        if (this.field_70146_Z.nextInt(50) == 0) {
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70163_u);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            for (int l = 0; l < 4; ++l) {
                i = MathHelper.func_76128_c((double)(this.field_70165_t + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
                j = MathHelper.func_76128_c((double)this.field_70163_u);
                k = MathHelper.func_76128_c((double)(this.field_70161_v + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f)));
                BlockPos blockpos = new BlockPos(i, j, k);
                if (this.func_130014_f_().func_180495_p(blockpos).func_185904_a() != Material.field_151579_a || !Blocks.field_150480_ab.func_176196_c(this.func_130014_f_(), blockpos)) continue;
                this.func_130014_f_().func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
            }
        }
        super.func_70636_d();
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187817_fK;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187821_fM;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    protected SoundEvent getWebSlingThrowSound() {
        return ModSounds.WEBSLING_THROW;
    }

    protected Item func_146068_u() {
        return Items.field_151059_bz;
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        super.func_70628_a(recentlyHit, looting);
        if (recentlyHit && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0)) {
            this.func_145779_a(Items.field_151070_bp, 1);
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70110_aj() {
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() == MobEffects.field_76436_u || potioneffectIn.func_188419_a() == MobEffects.field_82731_v ? false : super.func_70687_e(potioneffectIn);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (this.func_130014_f_().field_73012_v.nextInt(100) == 0) {
            EntityMoneySpider moneyspider = new EntityMoneySpider(this.func_130014_f_());
            moneyspider.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            moneyspider.func_180482_a(difficulty, null);
            this.func_130014_f_().func_72838_d((Entity)moneyspider);
            moneyspider.func_184220_m((Entity)this);
        }
        if (livingdata == null) {
            Potion potion;
            livingdata = new EntitySpider.GroupData();
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && this.field_70170_p.field_73012_v.nextFloat() < 0.1f * difficulty.func_180170_c()) {
                ((EntitySpider.GroupData)livingdata).func_111104_a(this.field_70170_p.field_73012_v);
            }
            if (livingdata instanceof EntitySpider.GroupData && (potion = ((EntitySpider.GroupData)livingdata).field_188478_a) != null) {
                this.func_70690_d(new PotionEffect(potion, Integer.MAX_VALUE));
            }
        }
        return livingdata;
    }

    @SideOnly(value=Side.CLIENT)
    public void lavaParticles(World world, double x, double y, double z, Random rand) {
        Erebus.PROXY.spawnCustomParticle("lava", this.func_130014_f_(), x, y, z, 0.0, 0.0, 0.0);
    }

    static class AILavaWebSlingAttack
    extends EntityAIBase {
        private final EntityLavaWebSpider lavaweb_spider;
        private int attackStep;
        private int attackTime;

        public AILavaWebSlingAttack(EntityLavaWebSpider lavaweb_spiderIn) {
            this.lavaweb_spider = lavaweb_spiderIn;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.lavaweb_spider.func_70638_az();
            return entitylivingbase != null && entitylivingbase.func_70089_S();
        }

        public void func_75249_e() {
            this.attackStep = 0;
        }

        public void func_75246_d() {
            --this.attackTime;
            EntityLivingBase entitylivingbase = this.lavaweb_spider.func_70638_az();
            double distance = this.lavaweb_spider.func_70068_e((Entity)entitylivingbase);
            if (distance < 4.0) {
                if (this.attackTime <= 0) {
                    this.attackTime = 20;
                    this.lavaweb_spider.func_70652_k((Entity)entitylivingbase);
                }
                this.lavaweb_spider.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, this.lavaweb_spider.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
            } else if (distance < 256.0) {
                double targetX = entitylivingbase.field_70165_t - this.lavaweb_spider.field_70165_t;
                double targetY = entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.field_70131_O / 2.0f) - (this.lavaweb_spider.field_70163_u + (double)(this.lavaweb_spider.field_70131_O / 2.0f));
                double targetZ = entitylivingbase.field_70161_v - this.lavaweb_spider.field_70161_v;
                if (this.attackTime <= 0) {
                    ++this.attackStep;
                    if (this.attackStep == 1) {
                        this.attackTime = 60;
                    } else if (this.attackStep <= 4) {
                        this.attackTime = 6;
                    } else {
                        this.attackTime = 100;
                        this.attackStep = 0;
                    }
                    if (this.attackStep > 1 && entitylivingbase instanceof EntityPlayer) {
                        this.lavaweb_spider.func_130014_f_().func_180498_a((EntityPlayer)null, 1009, this.lavaweb_spider.func_180425_c(), 0);
                        this.lavaweb_spider.func_130014_f_().func_184133_a((EntityPlayer)null, this.lavaweb_spider.func_180425_c(), this.lavaweb_spider.getWebSlingThrowSound(), SoundCategory.HOSTILE, 1.0f, 1.0f);
                        for (int count = 0; count < 1; ++count) {
                            EntityWebSling webSling = new EntityWebSling(this.lavaweb_spider.func_130014_f_(), (EntityLiving)this.lavaweb_spider);
                            webSling.field_70163_u = this.lavaweb_spider.field_70163_u + (double)(this.lavaweb_spider.field_70131_O / 2.0f) + 0.5;
                            webSling.setType((byte)2);
                            webSling.func_70186_c(targetX, targetY, targetZ, 1.0f, 0.0f);
                            this.lavaweb_spider.func_130014_f_().func_72838_d((Entity)webSling);
                        }
                    }
                }
                this.lavaweb_spider.func_70671_ap().func_75651_a((Entity)entitylivingbase, 10.0f, 10.0f);
                this.lavaweb_spider.func_70661_as().func_75499_g();
                this.lavaweb_spider.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, this.lavaweb_spider.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
            }
            super.func_75246_d();
        }
    }
}

