/*
 * Decompiled with CFR 0.152.
 */
package erebus.blocks;

import erebus.ModTabs;
import erebus.blocks.EnumWood;
import erebus.world.feature.plant.WorldGenBamboo;
import erebus.world.feature.tree.WorldGenAsperTree;
import erebus.world.feature.tree.WorldGenBalsamTree;
import erebus.world.feature.tree.WorldGenBaobabTree;
import erebus.world.feature.tree.WorldGenCypressTree;
import erebus.world.feature.tree.WorldGenErebusHugeTree;
import erebus.world.feature.tree.WorldGenEucalyptusTree;
import erebus.world.feature.tree.WorldGenMarshwoodTree;
import erebus.world.feature.tree.WorldGenMossbarkTree;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSaplingErebus
extends BlockSapling {
    private final EnumWood wood;

    public BlockSaplingErebus(EnumWood wood) {
        this.wood = wood;
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(ModTabs.PLANTS);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == ModTabs.PLANTS) {
            list.add((Object)new ItemStack((Block)this));
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            super.func_180650_b(world, pos, state, rand);
            if (world.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                if (this != EnumWood.BAMBOO.getSapling()) {
                    this.func_176478_d(world, pos, state, rand);
                } else {
                    world.func_180501_a(pos, EnumWood.BAMBOO.getLog().func_176223_P(), 3);
                }
            }
        }
    }

    public void func_176476_e(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)world, (Random)rand, (BlockPos)pos)) {
            return;
        }
        WorldGenerator worldGen = null;
        switch (this.wood) {
            case EUCALYPTUS: {
                worldGen = new WorldGenEucalyptusTree();
                break;
            }
            case BAOBAB: {
                worldGen = new WorldGenBaobabTree();
                break;
            }
            case ASPER: {
                worldGen = new WorldGenAsperTree();
                break;
            }
            case CYPRESS: {
                worldGen = new WorldGenCypressTree();
                break;
            }
            case MAHOGANY: {
                worldGen = new WorldGenErebusHugeTree(true, true, this.wood);
                ((WorldGenErebusHugeTree)worldGen).prepare(20 + rand.nextInt(5));
                break;
            }
            case BALSAM: {
                worldGen = new WorldGenBalsamTree();
                break;
            }
            case MOSSBARK: {
                worldGen = new WorldGenMossbarkTree();
                break;
            }
            case MARSHWOOD: {
                worldGen = new WorldGenMarshwoodTree();
                break;
            }
            case BAMBOO: {
                worldGen = new WorldGenBamboo(true, false);
                break;
            }
        }
        if (worldGen == null) {
            return;
        }
        world.func_175698_g(pos);
        if (!worldGen.func_180709_b(world, rand, pos)) {
            world.func_175656_a(pos, this.func_176223_P());
        }
    }
}

