/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.network;

import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.base.filter.FilterRegistry;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.conduits.conduit.item.IItemConduit;
import crazypants.enderio.conduits.network.AbstractConduitPacket;
import info.loenwind.autoconfig.util.NullHelper;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketItemConduitFilter
extends AbstractConduitPacket.Sided<IItemConduit> {
    private boolean loopMode;
    private boolean roundRobin;
    private DyeColor colIn;
    private DyeColor colOut;
    private int priority;
    private IItemFilter inputFilter;
    private IItemFilter outputFilter;

    public PacketItemConduitFilter() {
    }

    public PacketItemConduitFilter(@Nonnull IItemConduit con, @Nonnull EnumFacing dir) {
        super(con, dir);
        this.loopMode = con.isSelfFeedEnabled(dir);
        this.roundRobin = con.isRoundRobinEnabled(dir);
        this.colIn = con.getInputColor(dir);
        this.colOut = con.getOutputColor(dir);
        this.priority = con.getOutputPriority(dir);
        this.inputFilter = con.getInputFilter(dir);
        this.outputFilter = con.getOutputFilter(dir);
    }

    @Override
    public void write(@Nonnull ByteBuf buf) {
        super.write(buf);
        buf.writeBoolean(this.loopMode);
        buf.writeBoolean(this.roundRobin);
        buf.writeInt(this.priority);
        buf.writeShort(this.colIn.ordinal());
        buf.writeShort(this.colOut.ordinal());
        FilterRegistry.writeFilter(buf, this.inputFilter);
        FilterRegistry.writeFilter(buf, this.outputFilter);
    }

    @Override
    public void read(@Nonnull ByteBuf buf) {
        super.read(buf);
        this.loopMode = buf.readBoolean();
        this.roundRobin = buf.readBoolean();
        this.priority = buf.readInt();
        this.colIn = DyeColor.fromIndex((int)buf.readShort());
        this.colOut = DyeColor.fromIndex((int)buf.readShort());
        this.inputFilter = (IItemFilter)FilterRegistry.readFilter(buf);
        this.outputFilter = (IItemFilter)FilterRegistry.readFilter(buf);
    }

    public static class Handler
    implements IMessageHandler<PacketItemConduitFilter, IMessage> {
        public IMessage onMessage(PacketItemConduitFilter message, MessageContext ctx) {
            IItemConduit conduit = (IItemConduit)message.getConduit(ctx);
            if (conduit != null) {
                conduit.setSelfFeedEnabled(message.dir, message.loopMode);
                conduit.setRoundRobinEnabled(message.dir, message.roundRobin);
                conduit.setInputColor(message.dir, (DyeColor)NullHelper.first((Object[])new DyeColor[]{message.colIn, DyeColor.BLACK}));
                conduit.setOutputColor(message.dir, (DyeColor)NullHelper.first((Object[])new DyeColor[]{message.colOut, DyeColor.BLACK}));
                conduit.setOutputPriority(message.dir, message.priority);
                this.applyFilter(message.dir, conduit, message.inputFilter, true);
                this.applyFilter(message.dir, conduit, message.outputFilter, false);
                IBlockState bs = message.getWorld(ctx).func_180495_p(message.getPos());
                message.getWorld(ctx).func_184138_a(message.getPos(), bs, bs, 3);
            }
            return null;
        }

        private void applyFilter(@Nonnull EnumFacing dir, @Nonnull IItemConduit conduit, IItemFilter filter, boolean isInput) {
            if (filter != null) {
                if (isInput) {
                    conduit.setInputFilter(dir, filter);
                } else {
                    conduit.setOutputFilter(dir, filter);
                }
            }
        }
    }
}

